/*
 * Decompiled with CFR 0.152.
 */
package com.paragent.observer;

import com.paragent.observer.RfbProto;
import com.paragent.observer.VncViewer;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

class ButtonPanel
extends Panel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    VncViewer viewer;
    Button disconnectButton;
    Button optionsButton;
    Button recordButton;
    Button clipboardButton;
    Button refreshButton;

    ButtonPanel(VncViewer v) {
        this.viewer = v;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.disconnectButton = new Button("Disconnect");
        this.disconnectButton.setEnabled(false);
        this.add(this.disconnectButton);
        this.disconnectButton.addActionListener(this);
        this.optionsButton = new Button("Options");
        this.add(this.optionsButton);
        this.optionsButton.addActionListener(this);
        this.clipboardButton = new Button("Clipboard");
        this.clipboardButton.setEnabled(false);
        this.add(this.clipboardButton);
        this.clipboardButton.addActionListener(this);
        if (this.viewer.rec != null) {
            this.recordButton = new Button("Record");
            this.add(this.recordButton);
            this.recordButton.addActionListener(this);
        }
        this.refreshButton = new Button("Refresh");
        this.refreshButton.setEnabled(false);
        this.add(this.refreshButton);
        this.refreshButton.addActionListener(this);
    }

    public void enableButtons() {
        this.disconnectButton.setEnabled(true);
        this.clipboardButton.setEnabled(true);
        this.refreshButton.setEnabled(true);
    }

    public void disableButtonsOnDisconnect() {
        this.remove(this.disconnectButton);
        this.disconnectButton = new Button("Hide desktop");
        this.disconnectButton.setEnabled(true);
        this.add((Component)this.disconnectButton, 0);
        this.disconnectButton.addActionListener(this);
        this.optionsButton.setEnabled(false);
        this.clipboardButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.validate();
    }

    public void enableRemoteAccessControls(boolean enable) {
    }

    public void actionPerformed(ActionEvent evt) {
        this.viewer.moveFocusToDesktop();
        if (evt.getSource() == this.disconnectButton) {
            this.viewer.disconnect();
        } else if (evt.getSource() == this.optionsButton) {
            this.viewer.options.setVisible(!this.viewer.options.isVisible());
        } else if (evt.getSource() == this.recordButton) {
            this.viewer.rec.setVisible(!this.viewer.rec.isVisible());
        } else if (evt.getSource() == this.clipboardButton) {
            this.viewer.clipboard.setVisible(!this.viewer.clipboard.isVisible());
        } else if (evt.getSource() == this.refreshButton) {
            try {
                RfbProto rfb = this.viewer.rfb;
                rfb.writeFramebufferUpdateRequest(0, 0, rfb.framebufferWidth, rfb.framebufferHeight, false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

