.TH modify_rpmdb 1 "Yggdrasil Software Tracking Utilities" "Yggdrasil" \" -*- nroff -*-
.SH NAME
modify_rpmdb \- Modify a Red Hat RPM software tracking database without
using RPM files.
.SH SYNOPSIS
cat updated_file_list |
.B modify_rpmdb
\-\-name=name \-\-version=version \-\-mode=replace [ rpm_options ]
.SH DESCRIPTION
.B modify_rpmdb
reads a list of recently modified or installed files from standard input
and records these modifications in the internal database used by
Red Hat's RPM.
.PP
The purpose of this program is to enable installation of software in
formats other than RPM to be trackable by users of the RPM datase system.
.SS ARGUMENTS
.TP
.I "\-\-name=name"
The name of the package under which the file modifications should
be recorded.  This argument is mandatory.
.TP
.I "\-\-version=version"
The version string of the package under which the file modifications should
be recorded.  This argument is mandatory.
.TP
.I "\-\-mode=replace"
Define how
.B modify_rpmdb
should deal with the existence of a package with the same name.  In
"replace" mode, the old package will be deleted from the RPM database.
The actual files that the RPM database refers to are not effected.
In the future, this argument may be extended to deal with extending
existing packages (patch mode), allowing two packages with the same
name to exist on the system (add mode), or actually deleting the files
that were in the removed version of the package but not in the new version
(clobber mode).  At the moment, only replace mode is supported.  This
argument is mandatory.
.TP
.I "\-\-rpmfield=value"
The various RPM package fields that are not internally computed by
.B modify_rpmdb
can be specified on the command line.  Do "modify_rpmdb \-\-help" for
a complete list of these options.
.SH COPYRIGHT
.B modify_rpmdb
Copyright 1998 Yggdrasil Computing Incorporated.
Copyright 1995-1998 Red Hat Software, Inc.

The reasons for the Red Hat copyright are that
(
.B modify_rpmdb
)
contains a header file from Red Hat Software's RPM program and links
against their RPM library.

.B modify_rpmdb
may be copied according to the terms and conditions of version 2 of
the GNU General Public License, as published by the Free Software
Foundation (see the file COPYING in this source tree for details).

.SH AUTHOR
Adam J. Richter

.SH BUGS
.B modify_rpmdb
is incomplete and not tested very much yet.  Please send patches to
rpmdb-patches@yggdrasil.com.



