//=====================================================================
//
//	Package Viewer - A little aid to System Administrators
//
//  This software is distributed under the terms of the General Public License.
//  THIS IS CONSIDERED BETA CODE - ALTHOUGH TESTED - USE AT OWN RISK.
//  
//  Motivation:
//  :| Why did I wrote and why am I publishing as GNU-GPL?
//  :) Because I felt pride, joy and had great moments of fun learning and doing.
//  :) Now it is something useful and accessible to many others.
//  :) It is something positive that perhaps will add something to someone.
//
//                    *** THE `CONSUMER' MODEL ***
//
//  ":) In order to some - uncapable of produce anything useful - can
//      speculate with something, others - more capable - must produce 
//      something first. I have already choosen the side I want to belong to. 
//  
//  :( The question now is: What to do(?) with those who want to take, exploit 
//     and speculate the fruits of this work, specially when they are protected 
//     by laws that create capital/work relationship systems where capital
//     interests wins against social needs and where individuals are becoming
//     statistic numbers and receiving alias like `consumer' from economists
//     that nowadays attempt to sustain socio-political-economic systems based 
//     in stock market speculations, `the-market-thing' and a whole bunch of
//     unstable solutions that do not produce social global stability...
//  
//  :| They should at least attemp to produce socio-political-economic systems 
//     capable of wide spread to individuals some life quality instead of benefit 
//     some groups costing so much to many others...
//   
//  :| The truth is not out there - it is inside each one of us.
//     And at the final you are nothing more than you actually did and leave 
//     behind you. You define yourself by your acts, not by what you say nor by
//     what others may think or say about you. You are what you do.
//
//  :) It's not all about justice because life is really not fair (it's indeed
//     a dog-eat-dog world - I did not made it), it's all about being smart and
//     building (in fact producing) a bit better world to live in... and not
//     any kind of mess where some just think about themselves `living well' or
//     where `*I* want to be rich' is the life's reason, or anything like this... 
//
//  :) We are more and really rich when more and more around us are rich.
//  :( Unfortunately I see the opposite spread around quite frequently.
//  :| Generally associated with poor minded men living under the `consumer'
//     flag which gives nothing to values like family, friendship, tolerance...
//
//  :( The `consumer' model seems to measure a man by what he can buy...
//     by how much money he can make - as if one could eat or feed others
//     with painted paper - strictly speaking... It serves the purpose of
//     creating groups that succeed more than others feeding competition.
//     This is achieved by making a lot think they need to consume to be.
//
//     `The Marketing_thing' is the instrument to acomplish this - propaganda.
//     This is reaching a so vain and dangerous level that social concerns
//     about what is being `sold' in the market -like what for, targets,
//     consequences..- really doesn't matter any more... if weapons, 
//     `social acceptable drugs', sex, `bank papers'... all this stuff mixed
//     together in a whole true insane environment...
//
//     What matters is sell products! Consume! Money!
//     The main value is the power of consume -no matter what or how- Consume!
//     And the main point: No matter what you have to do to have this power... Consume!
//     Oh, great! And what the hell all this is related with computers???
//     Computers (are)will (eventually) replace virtually all propagenda medium
//     like TVs, Radios, Celulars, Mails, Faxs.... It's all about programs... 
//     Can you realize???
//
//  :( This model tends to feed `consuming' trying to make objects obsolete
//     as fast as possible. It is the end of the era where things were made
//     to be `good-things' and `long-life'. This model tries to make the same
//     things appear to be different and so estimulate the replacement... 
//     Poor concepts...from poor minds...trying to be rich with `the_market_thing'.
//     Living in function of `the money', `the market', `consumers'...
//     Perhaps thinking that is a good way - oh, yeah, earn money, job....
//
//  :| Programmed obsolescence called `improvements', nothing more then poor
//     ideas materialized in the form of `Market Competition'. Waste of time
//     resources and effort of many people that, instead, can produce real
//     better things, to benefit many and help living...instead of serving the
//     `Market-Economic-Thing'. If `There is No Market' `There is no Reason to
//     do, to make it'. Can exist a more dumb logic ??? ..  a more vain reason
//     to live and make things happen ???
//
//  :) The base of life is survive -together-as a whole-as a specie. Not as a 
//     group of idiots living in function of some artificial and unstable
//     system created by ourselves with unpredictable results, or at worst,
//     with some egoistic predictable results...just trying to be a bit better
//     than our own sibilants! Competing for nothing more than arrogance,
//     intolerance, individualism and all the `power-thing'.
//     
//  :| The `Economic-Thing' is assuming the status of the most important thing...
//     Man is becoming a slave of the `Economic-Thing'...A thing created by 
//     himself... as if the nature could accept this economic thing and all
//     the insane stuff created with it like taxes, duties, taxes over taxes...
//     Profit is a word that the mother nature will never know the meaning...
//
//  :( It is a poor way of living...Promoting the `market_thing_war' technique
//     with no benefits to nobody despites great economic groups. It is not
//     necessary to say the huge amount of problems this technique introduce.
//     We live in a limitted environment with exhaustable resources that eventually
//     will be exhausted some day - and not all of them are capable of renewal.
//     And those who are, shure are not with the speed this model imposes! 
//     
//  :| Money matters in this ideology! Everything is driven by `the_market->money($)'.
//     With money you are everything - so power, so good, so capable of, HUM ?!?
//     The rest... well the rest are secondary considerations...
//
//  :( Like any hierarchy system the society is based on primary building
//     blocks. The base block -which inheritance is made from- is the family.
//     How to build families without Father_Mother->living.together(?)...
//     If each one forgets the real natural place of each other and start
//     thinking in the `artificial power' of the `consumer' model - what the
//     next generations will get ???
//
//  :X Virtual_Father_Mother->bought.InTheMarket_thing(!) = Insane; (HUH!)
//     Much like `cloning' yourself to get some children. More insane yet...
//     Somebody help my sanity check test (ARRGHHH!!!)... `C L O N I N G'...
//     UAU,Man! This thing has a huge market! It makes A LOT OF MONEY! POWER!
//
//     Think this way in a possible hightech genetic clone-prone future:
//       What about a man `cloning' a woman from himself to serve him..
//       And about a woman cloning a man from herself to serve her...
//     Does it makes some sense? Well, some say it'll be possible to some 
//     -with money- in an obscure `consumer' model high-tech future....
//     Who knows... Who cares... Money matters in the `consumer' model!
//
//     Can you imagine the stock market power of such companies??? HMM??
//     All CEOs being `clones' of each other...UAU! This IS INHERITANCE....
//     And what about this one...
//     A Politician in re-election campaign saying...
//        - DO NOT vote on me! Vote on my clone! He is the future!
//        - He is the real truth of improvement and renovation...
//          Made with the best technology from WinCloning Co. Ver.5.0....
//          It costed my face's eyes to make this guy....
//
//  :) Probably the generations to come will need a `callback' (a CONNECTion
//     using the superior QT tech) to some old and lost values that this
//     `comsumer' model, imposed by insane  global-socio-economic forces, is
//     throwing away (in a shiny and brand new trash can - produced
//     somewhere in the global economy, making some small group rich -ARGH!).
// 
//     In fact, the `Consumer Model' is intended to make just some few to
//     have the `consuming power' while a huge mass of others, that live in
//     this small and limitted environment too, will watch them consuming the
//     natural resources and manufactured objects produced with them...
//
//     This will happen for generations to come... 
//     While this huge groups will also watch Mr.Death slowly kill their
//     children of hungry, envy, hate, sick, ignorance... or, eventually, an
//     army sponsored by some economic interests to mass-kill in the name of 
//     Order, Justice, Democracy, or any other blabla used to pretend very 
//     Legal but not Moral acts... 
//
//     I guess you already know that what is sometimes Legal is not - even 
//     close - Moral, fair and correct.... Legality is for Lawyers, Morality
//     is for true humans. This planet can lot live with models like this for
//     much longer! It will be `consumed' too!
//
//     This is what the `Consumer Model' in truth produce once it is not
//     capable of wide spread the power of consuming... A silent and non
//     declared war to gain the control of this resources and consume them...
//     Like any other group of animals in the jungle fighting for food...
//
//     It's a matter of fact, we're just one more of them...
//     And some claim that we are superior and smarter....
//     The real big difference is that we are `consuming' much, much more...
//     We are killing them all, by hand or by hungry! By our stupidity.
//     And in the top of the hill of arrogance some of us think that they
//     are the animals...
//
//     Those well integrated in this model - which of course benefits and see
//     the illusion of properity from it - will probably disagree and call
//     me frustrated, nuts, think I am little insane, anger or anything
//     like this... my words may fall into ridiculous...
//
//     But I am just looking in a greater time scale and with social and non 
//     personal or group interests... The apparent prosperity that seems to
//     come from this model is a illusion. It implies prosperity for just a
//     few with a great cost to many and with future higher costs to all.
//     But who cares? Certainly those who benefits from this model won't!
//     And certainly the egoism that this model imposes by it is nature will
//     fight against every word and idea pointed here...
//
//  :/ I am trying to point what the dark and egoistic side of this model is
//     spreading - and I would like to note that in the time scale that I am
//     talking about - this decades are just the early beggining...
//
//  :) I am Anti-`Market-War-Thing'! Let's find out better ways to live....
//     In fact I am completely Anti-Market. This is a stupid thing.
//     Or are we creating a `Consuming System' that we'll have to feed ???
//     We can do better than this, we are smart enough, aren't we ???
//     Can we stop this thing before it consume us with it's own interests,
//     can't we ??? I guess no, but I hope so."
//
// 
//  *** About:
//  Author  : Eng. Paulo Castro
//  E-Mail  : hook@netrio.com.br
//  Home    : http://www.momentus.com.br/users/hook/kpackviewer.html
//
//  *** Readme:
//  This is under work, please report any bugs you may find.
//  Suggestions, opinions additions or contributions are always welcome too.
//  Be shure to check the home page (under bugs) to see current status.
//  Enjoy the reading and - I hope with no problems - the use...
//
//  *** Hackers:
//  Effort was made to make a `readable' code, sometimes at `speed' cost.
//  You will note an attempt of a `linear progressive' approach. Also
//  you will note a `point by point way' in the Verbose issues.
//  So, there is a lot of space for `hacking' and improvements...
//  Be creative!
//
//=====================================================================

//--<Debug Level>------------------------------------------------------

#define VERBOSE 	true
#define VERB_PLUS	false
#define VERB_ERR    false

#define	KPACK_VER	"0.28"

//--<Macro>------------------------------------------------------------

#define DESTROY(ptr) if (ptr != 0) { delete ptr; ptr = 0; }

//--<Uses>-------------------------------------------------------------

// C libraries
#include <stdio.h>
#include <dirent.h>
#include <iostream.h>

// Qt libraries
#include <qapp.h>
#include <qdialog.h>
#include <qmainwindow.h>
#include <qlayout.h>
#include <qcursor.h>
#include <qwidget.h>
#include <qmessagebox.h>

#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qtooltip.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qprogressdialog.h>

#include <qlabel.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qmultilinedit.h>
#include <qlined.h>
#include <qgrpbox.h>
#include <qradiobt.h>
#include <qframe.h>
#include <qbutton.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qscrollbar.h>
#include <qtableview.h>

#include <qdir.h>
#include <qfile.h>
#include <qregexp.h>
#include <qdatetime.h>

// KDE libraries
#include <kapp.h>
#include <kprocess.h>
#include <ktreelist.h>
#include <ktabbar.h>
#include <kfiledialog.h>
#include <kmsgbox.h>
#include <htmlview.h>
#include <klocale.h>
#include <drag.h>
#include <kcombo.h>

//--<Const>------------------------------------------------------------

// Buffer limits
#define	BUFLEN	1024
#define MEMLEN	 256

// File List Names
#define FLE_DIR		"/KPackView.dirs"	// File to store directory analisys
#define FLE_LOG		"/KPackView.log"	// File to store command execution `log'
#define FLE_PAK		"/KPackView.pack"	// File to store final -readable- pack list
#define FLE_SLK		"/KPackView.slak"	// File to store slackware subtree scan
#define FLE_DSC		"/KPackView.descs"	// File to store all slak descriptions
#define FLE_RPM		"/KPackView.rpms"	// File to store rpm installed packs
#define FLE_LST		"/KPackView.sort"	// File to store unsorted list

// Default Package(s) Stuff
#define SLA_PAK		"/var/adm/packages/"
#define SLA_SCP		"/var/adm/scripts/"
#define DEB_PAK		"/var/lib/dpkg/available"
#define DEB_STA		"/var/lib/dpkg/status"
#define DEB_LST		"/var/lib/dpkg/info/"

// String Table (Here to enable translations....)
#define	TITLE   	"Package Viewer"
#define STANDBY 	"Scanning package..."
#define NOTSLAK		"File does not seems to be a Slackware Package."
#define WELCOME		"*************************************************************\n*  KPackViewer                                              *\n*                                                           *\n*  WARNING: This is BETA code - Please report bugs          *\n*                                                           *\n*  This software is based upon the terms of the GNU-GPL     *\n*************************************************************\n\n"
#define ERR_MSG		"ERROR: Package listing file contains no meaningfull data.\n\nProbably cause: Failure while generating list.\nCheck file and permissions.\n"
#define UBTSTA		"You must restart application to ensure changes take effect to all widgets..."

#define M_SLACK	 	"Browse Slackware Packages"
#define M_RPM  	 	"Browse RPM Packages"
#define M_DEB  	 	"Browse Debian Packages"
#define M_ZIP  	 	"Browse Zip Packages"
#define M_TGZ  	 	"Browse TarGZip Packages"
#define M_TBZ  	 	"Browse TarBZip2 Packages"
#define M_LHA  	 	"Browse LHA Packages"
#define M_GZP  	 	"Browse GZIP Packages"
#define M_ALL  	 	"Browse all valid packs"
#define M_MNTRPM 	"Browse RPM Installed Packages Database"
#define M_DEBSTA 	"View Debian `Status File' Database"
#define M_MNTSLK 	"Mount a Slackware Distribution Tree or CDROM"
#define M_LOOK	 	"View the last Shell output issued"
#define M_ALIEN  	"Convert Package using Alien..."
#define M_QUIT		"Exit application"
#define M_FRESH		"Refresh current folder"
#define M_GUIWIN	"Change GUI to Windows Style"
#define M_GUIMOT	"Change GUI Motif Style"
#define M_ABOUT		"About the author"
#define M_HELP		"Help Index"

#define O_FRESH		"-- Refresh current folder... --"
#define O_ALIEN		"-- Convert Package using Alien... -- "
#define O_QUIT		"-- Exit Application (saving user preferences) --"
#define O_MOUNT		"-- Mount a Slackware Distribution Tree or CDROM -- \n\nJust like if it was installed...\nThis allow easy package browsing even for non Slackware users because anyone can see all distribution packages\nGo to your home directory, under KPV dir and look Virtual_Slack using Slackware mode browsing after mounting the virtual packages..."
#define O_RPMDB		"-- View the RPM installed packages database --"
#define O_DEBDB		"-- View the DEB `Status File' Database --"
#define O_SLACK		"-- Open Slackware Packages --\n\nATTENTION: Be carefull when selecting what you will try to open because slackpacks don't have fixed extension.\n\nPrefer to look only in: /var/adm/packages/ or in the virtual Slackware mounted directory..."
#define O_RPM		"-- Open RPM Packages --\nChoose a package into a folder and\nall RPMs in the folder will be logged in the listbox..."
#define O_DEB		"-- Open Debian Packages --\nChoose a package into a folder and\nall DEB packs in the folder will be logged in the listbox..."
#define O_ZIP		"-- Open Zip Packages --\nChoose a zip pack into a folder and\nall ZIPs in the folder will be logged in the listbox..."
#define O_TGZ		"-- Open Tar.GZip Packages --\nChoose a package into a folder and\nall packs in the folder will be logged in the listbox..."
#define O_TBZ		"-- Open Tar.BZip2 Packages --\nChoose a package into a folder and\nall packs in the folder will be logged in the listbox..."
#define O_LHA		"-- Open LHA Packages --\nChoose a package into a folder and\nall packs in the folder will be logged in the listbox..."
#define O_GZP		"-- Open GZIP Packages --\nChoose a package into a folder and\nall packs in the folder will be logged in the listbox..."
#define O_ALL		"-- Open All Valid Packages --\nChoose a folder and all valid packs\nwill be logged in the listbox..."

#define	O_TREE		"Here you have a visual representation\nof the package listing in a hierachical view..."
#define	O_LIST		"Here you have the file list\nreported by the package.."
#define	O_PACK		"Here you have all packages found\non selected directory under selected pattern..."
#define O_INFO		"Here you have selected package\nreported information by query."

#define MNU_POP1	"Extract to..."
#define MNU_POP2	"Convert pack..."
#define MNU_POP3	"Show RPM Groups..."
#define MNU_POP4	"Show DEB Available..."
#define MNU_POP5	"Remove this item"
#define MNU_POP6	"Copy"
#define MNU_POP7	"Select All"
#define MNU_POP8	"Deselect"

#define MNU_BAR1	"Open &Slackware packages"
#define MNU_BAR2	"Open &RPM packages"
#define MNU_BAR3	"Open &Debian packages"
#define MNU_BAR4	"Open &Zip packages"
#define MNU_BAR5	"Open &TarGZip packages"
#define MNU_BAR6	"Open Tar&BZip2 packages"
#define MNU_BAR7	"Open &Lha packages"
#define MNU_BAR8	"Open &GZip packages"
#define MNU_BAR9	"Open &All valid packages"
#define MNU_BAR10	"Mount Slac&kware CDROM"
#define MNU_BAR11	"View RPM &installed packs"
#define MNU_BAR12	"View D&EB packs database"
#define MNU_BAR13	"View Last Output..."
#define MNU_BAR14	"Re&fresh Pack Folder..."
#define MNU_BAR15	"&Quit"
#define MNU_BAR16	"&Windows Style"
#define MNU_BAR17	"&Motif Style"
#define MNU_BAR18	"&About"
#define MNU_BAR19	"&Index"
#define MNU_BAR20	"&File"
#define MNU_BAR21	"&Options"
#define MNU_BAR22	"&Help"

#define TAB_BAR1	"Package Structure"
#define TAB_BAR2	"Package Contents"
#define TAB_BAR3	"Package Information"

#define MSG_DIV1	"Ready"
#define MSG_DIV2	"Select folder and package..."
#define MSG_DIV3	"Logging Directory"
#define MSG_DIV4	"Preparing package"
#define MSG_DIV5	"Please wait..."
#define MSG_DIV6	"Please wait... Querying RPM package"
#define MSG_DIV7	"Ready - Elapsed:"
#define MSG_DIV8	"Scanning"
#define MSG_DIV9	"Searching"
#define MSG_DIV10	"Analyzing dir struct..."
#define MSG_DIV11	"Creating package list file..."
#define MSG_DIV12	"Adding"
#define MSG_DIV13	"Select Alien converting options..."
#define MSG_DIV14	"Select install Debian options..."
#define MSG_DIV15	"Extracting Debian package "
#define MSG_DIV16	"Select install RPM options..."
#define MSG_DIV17	"Select extract to directory..."
#define MSG_DIV18	"Sorting Pack List..."
#define MSG_DIV19	"Scanning Debian Packages..."
#define MSG_DIV20	"Scanning packages...."
#define MSG_DIV21	"Loading RPM installed packages....."
#define MSG_DIV22	"Building RPM Groups Structure..."
#define MSG_DIV23	"Select Slackware CDROM root folder..."
#define MSG_DIV24	"Getting Slackware Descriptions..."
#define MSG_DIV25	"Mounting Virtual Slackware Distribution in:"
#define MSG_DIV26	"Please wait, this will take a while... Mounting"

#define MSG_WARN1	"Please, refer to associated Debian pack instead..."
#define MSG_WARN2	"Please, refer to associated RPM pack instead..."
#define MSG_WARN3	"Please, refer to associated TGZ pack instead..."
#define MSG_WARN4	"Could not create user $HOME Directory to Alien, using root..."
#define MSG_WARN5	"Not a valid pack for conversion."
#define MSG_WARN6	"Please, re-select a valid file first..."
#define MSG_WARN7	"Can not find path: "
#define MSG_WARN8	"OOPPS! Not enough memory to complete operation."
#define MSG_WARN9	"Can not check available memory.\nProgram will terminate now."
#define MSG_WARN10	"Can not find Debian Status File: /var/lib/dpkg/status !"
#define MSG_WARN11	"Could not create Debian Packs Folder."
#define MSG_WARN12	"Can not create Debian Packs Group List."
#define MSG_WARN13	"Can not create DEB package list to: "
#define MSG_WARN14	"Can not create RPM Group File in: "
#define MSG_WARN15	"No RPM files to show groups."
#define MSG_WARN16	"Your Slackware Virtual Folder is not empty. Remove or rename it before building a new one."
#define MSG_WARN17	"Could not create Virtual Slackware Folder."
#define MSG_WARN18	"Could not find required directories on "

#define DLG_DIV1	"Slackware Initial Folder"
#define DLG_DIV2	"Extract Debian pack"
#define DLG_DIV3	"ExtractTo..."
#define DLG_DIV4	"Install-NoForce"
#define DLG_DIV5	"Install-ForceDepends"
#define DLG_DIV6	"Install-ForceConflicts"
#define DLG_DIV7	" Options "
#define DLG_DIV8	"Ok"
#define DLG_DIV9	"Cancel"
#define DLG_DIV10	"Auto Load Directory"
#define DLG_DIV11	"Free Browsing"
#define DLG_DIV12	"Convert package with Alien"

//--<Type>-------------------------------------------------------------

typedef enum tag_TPack { tall, tslack, tdeb, trpm, tzip, tgz, tbz2, tlzh, tz } TPack;
typedef enum tag_TOption { Option_1, Option_2, Option_3, Option_4 } TOption;

class TDoubleClick_RB : public QRadioButton
{
	Q_OBJECT

	public:
		TDoubleClick_RB(QWidget* parent = NULL, const char* name = NULL)
		:QRadioButton(parent,name) {} ;
		~TDoubleClick_RB() {} ;
		
	signals:
		void SIG_DoubleClicked(void);
		
	protected:
		void mouseDoubleClickEvent( QMouseEvent *e ) 
		{ 
			QRadioButton::mouseDoubleClickEvent(e);
			emit SIG_DoubleClicked();
		};
};

class TKPVStatus : public QDialog
{
	Q_OBJECT

	public:
		TKPVStatus(QString amsg, QWidget* parent = NULL, const char* name = NULL)
		:QDialog(parent, name, false)
		{
			Label_1 = new QLabel( this, "Label_1" );
			Label_1->setAutoResize(true);
			Label_1->setAlignment(AlignLeft);
			Label_1->setText("   " + amsg + "   ");

			int dlgW = (int) (1.2 * Label_1->sizeHint().width()),
				dlgH = (int) (2.5 * Label_1->sizeHint().height());
				
			resize( dlgW, dlgH );
			setMinimumSize( dlgW, dlgH );
			setMaximumSize( dlgW, dlgH );
			setCaption(" Please Wait... ");
			
			QWidget *scr = QApplication::desktop();
			int scrW = scr->width(), scrH = scr->height();
			setGeometry( (int)(((scrW-dlgW)/2)+1), (int)(((scrH-dlgH)/2)+1) , dlgW , dlgH );
			Label_1->move( 7, 9 );
		};
		
		~TKPVStatus() 
		{
			DESTROY(Label_1);
		};
		
	private:
		QLabel	*Label_1;
};

class TKPVExtractDeb : public QDialog
{
	Q_OBJECT

	public:
		TKPVExtractDeb(QWidget* parent = NULL, const char* name = NULL);
		TOption GetOptions(void)
		{
			if (RadioButton_1->isChecked()) return Option_1;
			if (RadioButton_2->isChecked()) return Option_2;
			if (RadioButton_3->isChecked()) return Option_3;
			if (RadioButton_4->isChecked()) return Option_4;
			return Option_1;	// avoid warnings
		};
		
		~TKPVExtractDeb()
		{
			DESTROY(OK_Button);
			DESTROY(Cancel_Button);
			DESTROY(Label_1);
			DESTROY(RadioButton_1);
			DESTROY(RadioButton_2);
			DESTROY(RadioButton_3);
			DESTROY(RadioButton_4);
			DESTROY(GroupBox_1);
		};
		
	private:
		QButtonGroup	*GroupBox_1;
		QLabel 			*Label_1;
		QPushButton 	*OK_Button, *Cancel_Button;
		TDoubleClick_RB	*RadioButton_1, *RadioButton_2, *RadioButton_3, *RadioButton_4;
};

class TKPVChoSlak : public QDialog
{
	Q_OBJECT

	public:
		TOption GetOptions(void)
		{
			if (RadioButton_1->isChecked()) return Option_1;
			if (RadioButton_2->isChecked()) return Option_2;
			if (RadioButton_3->isChecked()) return Option_3;
			return Option_1;	// avoid warnings
		};
		
		bool AutoLoadDir(void) { return (CheckBox_1->isChecked() && !RadioButton_3->isChecked()); }

		TKPVChoSlak(QWidget* parent = NULL, const char* name = NULL);
		~TKPVChoSlak()
		{
			DESTROY(Label_1);
			DESTROY(CheckBox_1);
			DESTROY(RadioButton_1);
			DESTROY(RadioButton_2);
			DESTROY(RadioButton_3);
			DESTROY(PushButton_1);
			DESTROY(PushButton_2);
			DESTROY(GroupBox_1);
		};

	private:
		QLabel 			*Label_1;
		QButtonGroup	*GroupBox_1;
		QCheckBox		*CheckBox_1;
		QPushButton		*PushButton_1,  *PushButton_2;
		TDoubleClick_RB *RadioButton_1, *RadioButton_2, *RadioButton_3;
};

class TKPVExtract : public QDialog
{
	Q_OBJECT

	public:
		TKPVExtract(QString, bool = false, QWidget* parent = NULL, const char* name = NULL);
		const char *GetPath(void) { return Combo_1->currentText(); }
		QString GetOptions(void)
		{
			QString aux("");
			if (isAlien)
			{
				if (RadioButton_4->isChecked()) aux = "alien -g";
				if (RadioButton_3->isChecked()) aux = "alien -t";
				if (RadioButton_2->isChecked()) aux = "alien -r";
				if (RadioButton_1->isChecked()) aux = "alien -d";
			}
			else
			{
				CheckBox_2->isChecked() ? aux = "rpm -U" : aux = "rpm -i";
				if (CheckBox_1->isChecked()) aux += "vh";
				if (CheckBox_3->isChecked()) aux += " --force";
				if (CheckBox_4->isChecked()) aux += " --nodeps";
			} 
			aux += " ";
			return aux;
		};
		
		~TKPVExtract()
		{
			if (Combo_1 != 0) SaveHistory();
			DESTROY(OK_Button);
			DESTROY(Cancel_Button);
			DESTROY(Browse_Button);
			DESTROY(LineEdit_1);
			DESTROY(Combo_1);
			DESTROY(Label_1);
			DESTROY(Label_2);
			DESTROY(Label_3);
			DESTROY(CheckBox_1);
			DESTROY(CheckBox_2);
			DESTROY(CheckBox_3);
			DESTROY(CheckBox_4);
			DESTROY(RadioButton_1);
			DESTROY(RadioButton_2);
			DESTROY(RadioButton_3);
			DESTROY(RadioButton_4);
			DESTROY(RadioButton_5);
			DESTROY(RadioButton_6);
			DESTROY(GroupBox_2);
			DESTROY(GroupBox_1);
		};
		
	public slots:
		void ChooseDir(void)
		{
		    QString sel_dir = KDirDialog::getDirectory(Combo_1->currentText(),this);
			if (!sel_dir.isEmpty()) { AddToHistory(sel_dir); Combo_1->setFocus(); }
		};
		
		void AddToHistory(const char* anitem)
		{
			Combo_1->setEditText(anitem);
			if (NotInHistory(anitem)) Combo_1->insertItem(anitem,0);
		};
		
	private:
		QButtonGroup	*GroupBox_1;
		QGroupBox		*GroupBox_2;
		QLineEdit		*LineEdit_1;
		KCombo			*Combo_1;
		QLabel 			*Label_1, *Label_2, *Label_3;
		QRadioButton	*RadioButton_5, *RadioButton_6;
		QPushButton 	*Browse_Button, *OK_Button, *Cancel_Button;
		QCheckBox		*CheckBox_1, *CheckBox_2, *CheckBox_3, *CheckBox_4;
		TDoubleClick_RB	*RadioButton_1, *RadioButton_2, *RadioButton_3, *RadioButton_4;
		
		QString ext;
		bool isAlien;
		void LoadHistory(void);
		void SaveHistory(void);
		void BuildRPM(void);
		void BuildDeb(void);
		void BuildAlien(void);
		void BuildGeneric(QString,QString);
		bool NotInHistory(QString);
};

class TKTreeList : public KTreeList
{
	Q_OBJECT
	
	public:
		TKTreeList(QWidget *parent=0, const char *name=0) 
		:KTreeList(parent,name)
		{
			popmnu = new QPopupMenu();
			popmnu->insertItem(MNU_POP1, parent, SLOT(ExtractTo()));
			popmnu->insertItem(MNU_POP2, parent, SLOT(ConvertPack()));
			popmnu->insertSeparator();
			popmnu->insertItem(MNU_POP3, parent, SLOT(ShowRPMGroups()));
			popmnu->insertItem(MNU_POP4, parent, SLOT(ShowDEBGroups()));
			
			drophere = new KDNDDropZone(this, DndText);
 			connect(drophere, SIGNAL(dropAction(KDNDDropZone*)), parent, SLOT(Dropped(KDNDDropZone*)));
		};
		
		~TKTreeList()
		{
			DESTROY(popmnu);
			DESTROY(drophere);
		};
	
	signals:
		void SIG_DoubleClicked(void);

	protected:
		void mousePressEvent( QMouseEvent *e ) 
		{ 
			KTreeList::mousePressEvent(e);
			if (this->count() == 0) return;
			if ( e->button() == RightButton ) popmnu->popup(QCursor::pos());
		};

		void mouseDoubleClickEvent( QMouseEvent *e ) 
		{ 
			KTreeList::mouseDoubleClickEvent(e);
			if (this->count() == 0) return;
			emit SIG_DoubleClicked();
		};

		void keyPressEvent( QKeyEvent *e )
		{
			KTreeList::keyPressEvent(e);
			if (currentItem() == -1) return;
			KTreeListItem *curritm = getCurrentItem();
			QScrollBar *vsb = (QScrollBar*)verticalScrollBar();
			switch ( e->key() )
			{
				case Key_Home: 
					setCurrentItem(0);
					vsb->setValue(vsb->minValue());
					break;
				case Key_End : 
					setCurrentItem(visibleCount()-1);
					if (testTableFlags(Tbl_vScrollBar)) vsb->setValue(vsb->maxValue());
					break;
				case Key_Left: 
					if (!curritm->hasParent()) return;
					if (!curritm->hasChild()) curritm = curritm->getParent();
					else { if (!curritm->isExpanded()) curritm = curritm->getParent(); }
					setCurrentItem(itemIndex(curritm));
					collapseItem(itemIndex(curritm));
					break;
				case Key_Right:
					if (!curritm->hasChild()) return;
					expandItem(itemIndex(curritm));
					setCurrentItem(itemIndex(curritm->getChild()));
					break;
			}
		}

	private:
		QPopupMenu  	*popmnu;
		KDNDDropZone	*drophere;
};

class TKMultiEd : public QMultiLineEdit
{
	Q_OBJECT
	
	public:
		TKMultiEd(QWidget *parent=0, const char *name=0)
		:QMultiLineEdit(parent,name)
		{
			setReadOnly(true);
			popmnu = new QPopupMenu();
			popmnu->insertItem(MNU_POP6, this, SLOT(copyText())  );
			popmnu->insertItem(MNU_POP7, this, SLOT(selectAll()) );
			popmnu->insertItem(MNU_POP8, this, SLOT(deselect())  );
		};
		
		~TKMultiEd()
		{
			DESTROY(popmnu);
		};
		
	protected:
		void mousePressEvent( QMouseEvent *e ) 
		{ 
			QMultiLineEdit::mousePressEvent(e);
			if ( e->button() == RightButton ) popmnu->popup(QCursor::pos());
		};

	private:
		QPopupMenu  *popmnu;
};

class TKListView : public QListView
{
	Q_OBJECT
	
	public:
		TKListView(QWidget *parent=0, const char *name=0) 
		:QListView(parent,name)
		{
			popmnu = new QPopupMenu();
			popmnu->insertItem(MNU_POP1, parent, SLOT(ExtractTo()));
			popmnu->insertItem(MNU_POP2, parent, SLOT(ConvertPack()));
			popmnu->insertSeparator();
			popmnu->insertItem(MNU_POP3, parent, SLOT(ShowRPMGroups()));
			popmnu->insertItem(MNU_POP4, parent, SLOT(ShowDEBGroups()));
			
			drophere = new KDNDDropZone(this, DndText);
 			connect(drophere, SIGNAL(dropAction(KDNDDropZone*)), parent, SLOT(Dropped(KDNDDropZone*)));
		};
		
		~TKListView()
		{
			DESTROY(popmnu);
			DESTROY(drophere);
		};
		
	protected:
		void mousePressEvent( QMouseEvent *e ) 
		{ 
			QListView::mousePressEvent(e);
			if (this->childCount() == 0) return;
			if ( e->button() == RightButton ) popmnu->popup(QCursor::pos());
		};

	private:
		QPopupMenu  	*popmnu;
		KDNDDropZone	*drophere;
};

class TKListBox : public QListBox
{
	Q_OBJECT
	
	public:
		TKListBox(bool CanRemove=false, QWidget *parent=0, const char *name=0) 
		: QListBox(parent,name)
		{
			popmnu = new QPopupMenu();
			popmnu->insertItem(MNU_POP1, parent, SLOT(ExtractTo()));
			popmnu->insertItem(MNU_POP2, parent, SLOT(ConvertPack()));
			popmnu->insertSeparator();
			popmnu->insertItem(MNU_POP3, parent, SLOT(ShowRPMGroups()));
			popmnu->insertItem(MNU_POP4, parent, SLOT(ShowDEBGroups()));
			if (CanRemove) { popmnu->insertSeparator(); popmnu->insertItem(MNU_POP5, parent, SLOT(RemoveItem())); }
			
			drophere = new KDNDDropZone(this, DndText);
 			connect(drophere, SIGNAL(dropAction(KDNDDropZone*)), parent, SLOT(Dropped(KDNDDropZone*)));
		};
		
		~TKListBox()
		{
			DESTROY(popmnu);
			DESTROY(drophere);
		};

	signals:
		void SIG_DoubleClicked(void);

	protected:
		void mousePressEvent( QMouseEvent *e ) 
		{ 
			QListBox::mousePressEvent(e);
			if (this->count() == 0) return;
			if ( e->button() == RightButton ) popmnu->popup(QCursor::pos());
		};

		void mouseDoubleClickEvent( QMouseEvent *e ) 
		{ 
			QListBox::mouseDoubleClickEvent(e);
			if (this->count() == 0) return;
			emit SIG_DoubleClicked();
		};

		void keyPressEvent( QKeyEvent *e )
		{
			QListBox::keyPressEvent(e);
			if (currentItem() == -1) return;
			switch ( e->key() )
			{
				case Key_Home: 
					setCurrentItem(0); 
					break;
				case Key_End : 
					setCurrentItem(count()-1); 
					break;
			}
		}

	private:
		QPopupMenu		*popmnu;
		KDNDDropZone	*drophere;
};

class TInfoWindow : public QDialog 
{
	Q_OBJECT

	public:
		TInfoWindow(QString, QString, bool inHTML = false, bool isModal = true, QWidget *parent = 0, const char *name = 0);
		~TInfoWindow()
		{
			if (atxt != 0) SaveConfig();
			DESTROY(OK_Button);
			DESTROY(atxt);
			DESTROY(ahtml);
			DESTROY(WLayout);
		};

	public slots:
		void SetText(QString aTxt) { atxt->setText(aTxt); };
		void AddText(QString aTxt) { atxt->append(aTxt);  };
		
	private:
		QVBoxLayout		*WLayout;
		QPushButton 	*OK_Button;
		TKMultiEd		*atxt;
		KHTMLView		*ahtml;
		
		void Restore(void);
		void SaveConfig(void);
};

class TKPackViewer : public QMainWindow
{
	Q_OBJECT
	
	public:
		TKPackViewer(QString, QWidget *parent=0, const char *name=0);
		~TKPackViewer()
		{
			DESTROY(Shell_Viewer);
			DESTROY(ProgDlg);
			DESTROY(timer);
			DESTROY(lt);
			DESTROY(ls);
			DESTROY(lp);
			DESTROY(li);
			DESTROY(packtree);
			DESTROY(packages);
			DESTROY(results);
			DESTROY(info);
			DESTROY(listview);
			DESTROY(openSlack)
			DESTROY(openRpm);
			DESTROY(openDeb);
			DESTROY(openZip);
			DESTROY(openTgz);
			DESTROY(openTbz);
			DESTROY(openLha);
			DESTROY(openGzp);
			DESTROY(modeAll);
			DESTROY(mountSlack);
			DESTROY(mountRpm);
			DESTROY(mountDeb);
			DESTROY(lookOut);
			DESTROY(Fresh);
			DESTROY(quitapp);
			DESTROY(packtools)
			DESTROY(tabbar);
			DESTROY(mnufle);
			DESTROY(mnuopt);
			DESTROY(mnuhlp);
			DESTROY(packmenu);
			DESTROY(lboxes);
			DESTROY(topLayout);
		};
		
	public slots:
		void Help(void);	
		void Quit(void);
		void About(void);
		void MenuMsg(int);		
		void ShowPack(void);
		void TabSelected(int);
		void ViewOutput(void);
		void ExtractTo(void);
		void MountSlack(void);
		void MountRPM(void);
		void ConvertPack(void);
		void RefreshPacks(void);
		void ShowRPMGroups(void);
		void RemoveItem(void);

		void ShowDEBGroups(void){ MountDEB(DEB_PAK); };
		void ShowDEBStatus(void){ MountDEB(DEB_STA); };

		void GetSLAKPack(void)	{ GetPacks(tslack); };
		void GetDEBPack(void) 	{ GetPacks(tdeb  ); };
		void GetRPMPack(void) 	{ GetPacks(trpm  ); };
		void GetZIPPack(void) 	{ GetPacks(tzip  ); };
		void GetTGZPack(void) 	{ GetPacks(tgz   ); };
		void GetTBZPack(void) 	{ GetPacks(tbz2  ); };
		void GetLHAPack(void) 	{ GetPacks(tlzh  ); };
		void GetGZPPack(void) 	{ GetPacks(tz    ); };
		void GetALLPack(void) 	{ GetPacks(tall  ); };

		void SetWinStyle(void)	{ SetAppStyle(WindowsStyle); };
		void SetMtfStyle(void)	{ SetAppStyle(MotifStyle  ); };

		void DoneProc(KProcess*);
		void ProcessEnd(KProcess*);
		void DoMountRPM(KProcess*);
		void DoMountSlak(KProcess*);		
		void ExternEnd(KProcess*);
		void ProcessOutput(KProcess*, char*, int);
		void ExternOutput(KProcess*, char*, int);
		
		void Dropped(KDNDDropZone*);
		
	private:
		QLabel		*lt, *ls, *lp, *li;
		QBoxLayout  *topLayout;		
		QGridLayout *lboxes;
		KTabBar		*tabbar;
		TKTreeList	*packtree;
		TKListBox 	*packages, *results;
		TKMultiEd	*info;
		TKListView	*listview;
		QToolBar	*packtools;
		QMenuBar    *packmenu;
		QPopupMenu  *mnufle, *mnuopt, *mnuhlp;
		TInfoWindow	*Shell_Viewer;
	 	QTab 		*stab, *ltab, *itab;

		QToolButton *openSlack, *openRpm, *openDeb, *openZip, *openTgz, 
					*openTbz,   *openLha, *openGzp, *modeAll, *mountSlack, 
					*mountRpm,  *lookOut, *Fresh,   *quitapp, *mountDeb;
		
		// Auxiliary
		FILE *sf;
		void BuildTabBar(void);
		void BuildObjects(void);
		void BuildLayout(void);
		void BuildMenu(void);
		void BuildToolBar(void);
		void SetAppStyle(GUIStyle);
		void SaveConfig(void);
		void BlockFrame(bool);
		void Warn(QString);
		void Fatal(QString);
		bool TrivialErr(void);

		// Memory check
		QString memdum, MemFree, SwapFree, MemTot, SwapTot;
		char membuf[MEMLEN];
		bool MemAvail(void);

		// Basic "pack" operations
		bool pack_mode_all;					// Flag to state MODE_ALL
		FILE *f;							// Deals with THE pack
		char buf[BUFLEN];					// Buffer to fgets()
		void LogDir(QString);
		bool InitFrame(void);
		void ReadPack();
		void SetPack(void);
		void DoShowPack(void);
		bool ChoosePacks(void);
		void SetPathTo(QString);
		void SetModeTo(TPack,bool);
		void GetParameter(QString);
		QString	readable_pack, requested_pack, path_to_packs, xtern_opt;
		
		// Basic "Extract/Convert" operations
		void SetConvertPath(void);
		void DoExtractPack(void);
		void ExternExec(QString);

		// Pack handling
		TPack pack_type, prev_type;
		void    GetPacks(TPack);
		QString GetValidExts(TPack);
		TPack	GetPackType(QString);
		QString GetPackExt(QString);
		
		// Timer stuff
		QTime	*timer;
		void PrintElapsed(void);
		
		// Pack interface
		int parentpos;						// Optimizes the scanparent function
		QString dirlog, lastparent;			// Buffer to monitor tree dirs
		QString amsg, whatidid;				// General Buffers
		FILE *nf;							// Deals with intermediate packs
		QString shell_out;					// Buffer to process output		
		bool isInfo, frmt;					// General flags

		// Debian Specific
		bool bf_DEBdb;
		void MountDEB(QString);
		void ShowDEBInfo(void);
		void ShowDEBList(void);
		bool isDEBdb(void) { return (pack_type == tdeb &&  bf_DEBdb ); };
		bool isDEBxt(void) { return (pack_type == tdeb && !bf_DEBdb ); };

		// RPM Specific
		bool bf_RPMdb;
		void LoadRPMs(void);
		bool ExistRPMs(void);
		void GetRPMInfo(void);
		void FormatRPMInfo(void);
		void GetRPMGroup(QString);
		void DoGetRPMInfo(QString,QString);
		bool isRPMdb(void) { return (pack_type == trpm &&  bf_RPMdb ); };
		bool isRPMxt(void) { return (pack_type == trpm && !bf_RPMdb ); };

		// Slak Specific
		bool bf_virtslak;
		QString virt_slak_path;
		bool IsSlack(void);
		bool IsVirtualSlack(void);
		void CheckSlakContents(void);
		void AppendSlackScript(void);
		void GenAllDescs(void);		
		void MountSlakPacks(void);
		void GetVSlackDesc(QString);
		void GetVSlackScript(QString);
		void GetVSlackList(QString);
		
		void SortList(void);
		void FormatPackInfo(void);
		void ProcessExec(QString);
		void Pack_Parse(void);
		void PreparePackFile(void);
		void Process_Pack_Entry(QString);
		void DoProcess(QString,QString,QString);

		// Basic "item" operations
		QString curr, prev, cbuf;			// Tree item buffers
		int  idx;							// Tree index controller
		void AddToTree(void);
		void FormatItem(QString);		
		void AddItem(void);		
		void ScanParent(void);
		void GetParent(QString&);
		void GetFullPath(int, QString&);
		
		// Query status functions
		bool ListBegins(void);
		int  PackSize(QString);	
		bool InRoot(QString&);
		bool ValidStr(QString);
		bool StringAccepted(QString&);
		bool IsDirectory(QString);
		bool IsSubDirectory(QString,QString);
		bool InItemFolder(QString);
		int  GetItemIndex(QString);
		bool ExtensionMatch(QString);
		bool ParentInBuf(QString);
		int  GetDirIdx(QString);

		// Icon stuff
		QPixmap hom, fol, doc, zip, hpp, cpp, shl, lib, pel, man, pyt, grf, 
				lsm, htm, pdf, snd, awk, inf, tex, txt, mak, exl, fnt, tcl, 
				dif, eye, pod, css, jav, pyo, pyc, dbf, sgm, lyx, vid, rtf,
				exe, ini, m4, deb, rpm;

		// Toolbar icons
		QPixmap openSLACK, openRPM, openDEB, openZIP, openTGZ, openTBZ, 
				openLHA  , openGZP, quitAPP, modeALL, lookOUT, mntSLACK,
				mntRPM, KPV, fresh, alien, mntDEB, ledred, ledgreen;

		void LoadIcons(void);
		void LoadIcon(QPixmap&, QString);
		QPixmap GetItemPixmap(QString);		

		// Meter stuff
		bool isBusy;						// Try to avoid LED flickering
		int flelns, count;					// Monitor Progress
		TKPVStatus		*WaitDlg;
		QProgressDialog *ProgDlg;
		void BuildMeter(void);
		void ShowWait(QString);
		void WaitDone(void);
		void StartMeter(void);
		bool UpdateMeter(void);
		void StopMeter(void);
		void SetLedOn(void);
		void SetLedOff(void);
		void PrintMsg(QString);
		
		// Information View
		QString GetInfoLen(QString); 
		QString GetInfoAtr(QString); 
		QString GetInfoStp(QString); 
		QString GetInfoItm(QString);
		void SetInfoView(void);
};

//--<Var>--------------------------------------------------------------

KApplication	*KPVApp;
TKPackViewer	*KPackViewer;
bool			STYLE_MOTIF, exec_ok;
int				WinW, WinH, WinX, WinY;
QString 		data_path, cfgbuf, user_path;

//--<Extern>-----------------------------------------------------------

#include "KPackViewer.moc"

//=====================================================================
//	IMPLEMENTATION
//=====================================================================

//==<Main Function>====================================================

int main(int argc, char **argv)
{
	cerr << WELCOME;
	KPVApp = new KApplication(argc, argv);

	// Set references before initialize Objects...
	data_path = KPVApp->kde_datadir().data();
	data_path += "/KPackViewer";
	if (VERB_ERR) { cerr << "Application Directory is: " << data_path << "\n"; }

	// Verify and attempts to create a user specific directory to KPV...
	user_path = KPVApp->localkdedir() + "/share/apps";
	user_path += "/KPackViewer";
	QDir test_user_path(user_path); 
	if (!test_user_path.exists()) if (!test_user_path.mkdir(user_path)) user_path = data_path;
	cerr << "User Profile Directory is: " << user_path << "\n";
	
	// Read configuration
	KConfig *conf = KPVApp->getConfig();
	conf->setGroup( "Options" );
	STYLE_MOTIF = conf->readBoolEntry( "Style", true );
	conf->setGroup( "Window" );
	WinX = conf->readNumEntry( "WinXPos"  ,   1 );
	WinY = conf->readNumEntry( "WinYPos"  ,   1 );
	WinW = conf->readNumEntry( "WinWidth" , 700 );
	WinH = conf->readNumEntry( "WinHeight", 700 );
	STYLE_MOTIF ? KPVApp->setStyle(MotifStyle) : KPVApp->setStyle(WindowsStyle);

	// Accepts the first passed parameter as a file or a directory...
	QString param("");
	if (argc > 1) param = argv[1];
	KPackViewer = new TKPackViewer(param,0,TITLE);
	KPVApp->setMainWidget(KPackViewer);
	KPackViewer->show();
	if (!KPVApp->isRestored()) KPackViewer->setGeometry(WinX,WinY,WinW,WinH);
	int retcode = KPVApp->exec();
	DESTROY(KPackViewer);
	return retcode;
}

//==<Class TKPackViewer>================================================

TKPackViewer::TKPackViewer(QString aparam, QWidget *parent, const char *name)
: QMainWindow(parent, name)
{
	WaitDlg = 0; Shell_Viewer = 0;
	timer = new QTime(); timer->start();
	LoadIcons();
	BuildTabBar();
	BuildObjects();
	BuildToolBar();	
	BuildMenu();
	BuildLayout();
	BuildMeter();
	PrintMsg("Ready");
	setIcon(KPV);
	if (aparam != "") GetParameter(aparam);
}
//---------------------------------------------------------------------
void TKPackViewer::Dropped(KDNDDropZone *whatisthis)
{
	QString aux(whatisthis->getData());
	if (VERBOSE) { cerr << "Drop detected - " << aux << "\n"; }
	if (aux.left(5) == "file:") aux = aux.mid(5,aux.length());
	GetParameter(aux);
}
//---------------------------------------------------------------------
void TKPackViewer::GetParameter(QString the_param)
{
	if (VERBOSE) { cerr << "Command is:" << the_param << "\n"; }
	QString aux(""); aux = the_param.copy();
	QDir d = QDir::root();
	if (!d.cd(aux)) 
	{
		if (VERBOSE) { cerr << "HMMM...Command is *NOT* a directory:" << aux << "\n"; }
		GetParent(aux);
		if (!d.cd(aux))
		{
			if (VERBOSE) { cerr << "ARGH! Can *NOT* load: " << the_param << "\n"; }
			Warn("Can not load: " + the_param); return;
		}
		else 
		{ 
			exec_ok = d.setCurrent(aux);
			if (VERBOSE) { cerr << "HMMM...But I can load a parent Directory: " << aux << "\n"; }
			if (aux == "/") { if (VERBOSE) { cerr << "OOPPSS! But I will *NOT* load the root directory!" << "\n"; } return; }
			aux = the_param.mid(the_param.findRev("/")+1,the_param.length());
			QFile afile(aux);
			if (afile.exists()) { if (VERBOSE) { cerr << "GOOD...Request for File: " << aux << "\n"; } }
			else { if (VERBOSE) { cerr << "ARGH! Can *NOT* load this File: " << aux << "\n"; } }
		}
	}
	else
	{
		if (VERBOSE) { cerr << "HMMM...Command is a Directory: " << the_param << "\n"; }
		if (the_param.right(1) != "/") the_param += "/"; 
	}
	requested_pack = the_param;
	ShowWait("   Querying " + requested_pack + "...");
	SetModeTo(tall, false); KPVApp->processEvents();
	SetPathTo(the_param);   KPVApp->processEvents();
	if (IsDirectory(the_param)) WaitDone();
	SetPack(); KPVApp->processEvents();
}
//---------------------------------------------------------------------
void TKPackViewer::BuildTabBar()
{
 	tabbar = new KTabBar(this, "tabbar");
 	stab = new QTab; ltab = new QTab; itab = new QTab;
	stab->label = TAB_BAR1;
	stab->enabled = true;
	ltab->label = TAB_BAR2;
	ltab->enabled = true;
	itab->label = TAB_BAR3;
	itab->enabled = true;
	tabbar->addTab(stab);
	tabbar->addTab(ltab);
	tabbar->addTab(itab);
	tabbar->setMinimumWidth( tabbar->sizeHint().width() );
	connect(tabbar,SIGNAL(selected(int)), SLOT(TabSelected(int)));
}
//---------------------------------------------------------------------
void TKPackViewer::BuildObjects()
{
	lt = new QLabel(this); ls = new QLabel(this); 
	lp = new QLabel(this); li = new QLabel(this);
			
	lt->setText(" ");
	lt->setMinimumSize( lt->sizeHint() );
	lt->setAlignment(AlignRight);
	lt->setMaximumHeight( 2 * lt->sizeHint().height() );
	lt->setPixmap( ledgreen );
	
	lp->setText("Packages");
	lp->setAlignment(AlignCenter);
	lp->setLineWidth(2);
	lp->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	lp->setMinimumSize( lp->sizeHint() );			
	lp->setMinimumWidth ( 2 * lp->sizeHint().width()  );
	lp->setMaximumHeight( 1 * lp->sizeHint().height() );						
	lp->setMaximumWidth ( 4 * lp->sizeHint().width()  );

	// Make a divider line to adjust better the layout
	li->setLineWidth(2);
	li->setMinimumSize(li->sizeHint());
	li->setFrameStyle(QFrame::HLine | QFrame::Raised);
	li->setMaximumHeight(7);

	ls->setText(" ");
	ls->setMinimumSize( ls->sizeHint() );
	ls->setMaximumHeight( ls->sizeHint().height() );
	
	// Main widgets...
	results  = new TKListBox(false, this,"results");
	packages = new TKListBox(true, this,"packages");
	packtree = new TKTreeList(this,"packtree");	
	info     = new TKMultiEd(this,"info");
	listview = new TKListView(this,"listview");

	listview->addColumn("Attribs");
	listview->addColumn("Time Stamp");	
	listview->addColumn("Size");
	listview->addColumn("File");
	listview->setAllColumnsShowFocus(true);
	listview->setColumnWidthMode(0,QListView::Maximum);
	listview->setColumnWidthMode(1,QListView::Maximum);
	listview->setColumnWidthMode(2,QListView::Maximum);
	listview->setColumnWidthMode(3,QListView::Maximum);
	listview->setColumnAlignment(0,AlignRight);
	listview->setColumnAlignment(1,AlignRight);
	listview->setColumnAlignment(2,AlignRight);
	listview->setColumnAlignment(3,AlignLeft);
	listview->setSorting(3,true);
	listview->setMultiSelection(true);

	connect(packages, SIGNAL(   highlighted(int)  ), this, SLOT(  ShowPack() ));
	connect(packages, SIGNAL( SIG_DoubleClicked() ), this, SLOT( ExtractTo() ));
	connect(packtree, SIGNAL( SIG_DoubleClicked() ), this, SLOT( ExtractTo() ));
}
//---------------------------------------------------------------------
void TKPackViewer::BuildToolBar()
{
    // Toolbar stuff...
	packtools  = new QToolBar( this, "Package Operations" );	
	openSlack  = new QToolButton(openSLACK, M_SLACK , 0, this, SLOT(GetSLAKPack())  ,packtools, M_SLACK );
	openRpm    = new QToolButton(openRPM  , M_RPM   , 0, this, SLOT(GetRPMPack())   ,packtools, M_RPM   );
	openDeb    = new QToolButton(openDEB  , M_DEB   , 0, this, SLOT(GetDEBPack())   ,packtools, M_DEB   );
	packtools->addSeparator();
	openZip    = new QToolButton(openZIP  , M_ZIP   , 0, this, SLOT(GetZIPPack())   ,packtools, M_ZIP );
	openTgz    = new QToolButton(openTGZ  , M_TGZ   , 0, this, SLOT(GetTGZPack())   ,packtools, M_TGZ );
	openTbz    = new QToolButton(openTBZ  , M_TBZ   , 0, this, SLOT(GetTBZPack())   ,packtools, M_TBZ );
	openLha    = new QToolButton(openLHA  , M_LHA   , 0, this, SLOT(GetLHAPack())   ,packtools, M_LHA );
	openGzp    = new QToolButton(openGZP  , M_GZP   , 0, this, SLOT(GetGZPPack())   ,packtools, M_GZP );
	modeAll    = new QToolButton(modeALL  , M_ALL   , 0, this, SLOT(GetALLPack())   ,packtools, M_ALL );
	packtools->addSeparator();
	mountSlack = new QToolButton(mntSLACK , M_MNTSLK, 0, this, SLOT(MountSlack())   ,packtools, M_MNTSLK);
	mountRpm   = new QToolButton(mntRPM   , M_MNTRPM, 0, this, SLOT(MountRPM()  )   ,packtools, M_MNTRPM);
	mountDeb   = new QToolButton(mntDEB   , M_DEBSTA, 0, this, SLOT(ShowDEBStatus()),packtools, M_DEBSTA);
	lookOut    = new QToolButton(lookOUT  , M_LOOK  , 0, this, SLOT(ViewOutput())   ,packtools, M_LOOK	);
	Fresh      = new QToolButton(fresh    ,"Refresh", 0, this, SLOT(RefreshPacks()) ,packtools, "Refresh");
	quitapp    = new QToolButton(quitAPP  ,"Quit"   , 0, this, SLOT(Quit())         ,packtools, "Quit"   );
	(void)QWhatsThis::whatsThisButton(packtools);	

	// Whatsthis stuff...
	QWhatsThis::add(openSlack , O_SLACK, false);
	QWhatsThis::add(openRpm   , O_RPM  , false);
	QWhatsThis::add(openDeb   , O_DEB  , false);
	QWhatsThis::add(openZip   , O_ZIP  , false);		
	QWhatsThis::add(openTgz   , O_TGZ  , false);		
	QWhatsThis::add(openTbz   , O_TBZ  , false);
	QWhatsThis::add(openLha   , O_LHA  , false);
	QWhatsThis::add(openGzp   , O_GZP  , false);
	QWhatsThis::add(modeAll   , O_ALL  , false);
	QWhatsThis::add(mountSlack, O_MOUNT, false);
	QWhatsThis::add(mountRpm  , O_RPMDB, false);
	QWhatsThis::add(mountDeb  , O_DEBDB, false);
	QWhatsThis::add(lookOut   , M_LOOK , false);
	QWhatsThis::add(Fresh     , O_FRESH, false);
	QWhatsThis::add(quitapp   , O_QUIT , false);

	QWhatsThis::add(packtree  , O_TREE , false);		
	QWhatsThis::add(results   , O_LIST , false);		
	QWhatsThis::add(packages  , O_PACK , false);
	QWhatsThis::add(info      , O_INFO , false);
	QWhatsThis::add(listview  , O_INFO , false);
}
//---------------------------------------------------------------------
void TKPackViewer::BuildMenu()
{
	// Creates menu...
    packmenu = new QMenuBar(this);
	connect(packmenu,SIGNAL(highlighted(int)), SLOT(MenuMsg(int)));	
	
	// File...
	mnufle = new QPopupMenu;
	mnufle->insertItem(openSLACK , MNU_BAR1 , this, SLOT(GetSLAKPack())  , CTRL + Key_S , 101);
	mnufle->insertItem(openRPM   , MNU_BAR2 , this, SLOT(GetRPMPack())   , CTRL + Key_R , 102);
	mnufle->insertItem(openDEB   , MNU_BAR3 , this, SLOT(GetDEBPack())   , CTRL + Key_D , 103);	
	mnufle->insertSeparator();
	mnufle->insertItem(openZIP   , MNU_BAR4 , this, SLOT(GetZIPPack())   , CTRL + Key_Z , 104);
	mnufle->insertItem(openTGZ   , MNU_BAR5 , this, SLOT(GetTGZPack())   , CTRL + Key_T , 105);
	mnufle->insertItem(openTBZ   , MNU_BAR6 , this, SLOT(GetTBZPack())   , CTRL + Key_B , 106);
	mnufle->insertItem(openLHA   , MNU_BAR7 , this, SLOT(GetLHAPack())   , CTRL + Key_L , 107);
	mnufle->insertItem(openGZP   , MNU_BAR8 , this, SLOT(GetGZPPack())   , CTRL + Key_G , 108);
	mnufle->insertItem(modeALL   , MNU_BAR9 , this, SLOT(GetALLPack())   , CTRL + Key_A , 109);
	mnufle->insertSeparator();
	mnufle->insertItem(mntSLACK  , MNU_BAR10, this, SLOT(MountSlack())   , CTRL + Key_K , 112);
	mnufle->insertItem(mntRPM    , MNU_BAR11, this, SLOT(MountRPM()  )   , CTRL + Key_I , 113);
	mnufle->insertItem(mntDEB    , MNU_BAR12, this, SLOT(ShowDEBStatus()), CTRL + Key_E , 115);
	mnufle->insertItem(lookOUT   , MNU_BAR13, this, SLOT(ViewOutput())   , CTRL + Key_V , 110);
	mnufle->insertItem(fresh     , MNU_BAR14, this, SLOT(RefreshPacks()) , CTRL + Key_F , 114);
	mnufle->insertSeparator();
	mnufle->insertItem(quitAPP   , MNU_BAR15, this, SLOT(Quit())         , CTRL + Key_X , 111);

	// Options...
	mnuopt = new QPopupMenu;
	mnuopt->setCheckable(true);
	mnuopt->insertItem( MNU_BAR16, this, SLOT(SetWinStyle()), CTRL + Key_W, 201);
	mnuopt->insertItem( MNU_BAR17, this, SLOT(SetMtfStyle()), CTRL + Key_M, 202);
	STYLE_MOTIF ? mnuopt->setItemChecked(202,true) : mnuopt->setItemChecked(201,true);

    // Help...
	mnuhlp = new QPopupMenu;
	mnuhlp->insertItem( MNU_BAR18, this, SLOT(About()), 0, 301);
	mnuhlp->insertItem( MNU_BAR19, this, SLOT(Help() ), 0, 302); 

	packmenu->insertItem( MNU_BAR20, mnufle);
	packmenu->insertItem( MNU_BAR21, mnuopt);
	packmenu->insertItem( MNU_BAR22, mnuhlp);
}
//---------------------------------------------------------------------
void TKPackViewer::BuildLayout()
{
	topLayout = new QVBoxLayout( this, 3); 
	lboxes = new QGridLayout(5, 2);
	topLayout->setMenuBar( packmenu );
	topLayout->addLayout( lboxes );	
	lboxes->addMultiCellWidget(     lt, 0, 0, 0, 1 );
	lboxes->addMultiCellWidget( tabbar, 1, 1, 0, 0 );
	lboxes->addWidget(       lp, 1, 1 );
	lboxes->addWidget( packtree, 2, 0 );
	lboxes->addWidget(  results, 2, 0 );
	lboxes->addWidget(     info, 2, 0 );
	lboxes->addWidget( listview, 2, 0 );
	lboxes->addWidget( packages, 2, 1 );
	lboxes->addMultiCellWidget(  li, 3, 3, 0, 1 );
	lboxes->addMultiCellWidget(  ls, 4, 4, 0, 1 );
	info->hide();
	results->hide();
	listview->hide();
	topLayout->activate();
}
//---------------------------------------------------------------------
bool TKPackViewer::ChoosePacks()
{	
	QString org("");
	if (pack_type == tslack) 
	{
		TKPVChoSlak *choslak = new TKPVChoSlak();
		int retval = choslak->exec();
		TOption option = choslak->GetOptions();
		bool autoload = choslak->AutoLoadDir();
		DESTROY(choslak);
		if (retval == QDialog::Rejected) return false;
		switch (option)
		{
			case Option_1: org = SLA_PAK; break;
			case Option_2: org = user_path + "/Virtual_Slack"; break;
			default: org = SLA_PAK;
		}
		if (autoload) 
		{
			requested_pack = org + "/";
			packtree->setFocus();
			packages->clearSelection();
			return true;
		}
	}
	QString aux("");
	PrintMsg("Select folder and package...");
	aux = GetValidExts(pack_type);
	requested_pack = KFileDialog::getOpenFileName(org, aux, this);
	QCursor ifwaiting; ifwaiting.setShape(ArrowCursor);
	return ( ! requested_pack.isEmpty() );
}
//---------------------------------------------------------------------
void TKPackViewer::SetModeTo(TPack apack_type, bool aflag)
{
	// Set flags to proper operation mode according income request...
	pack_mode_all ? prev_type = tall : prev_type = pack_type;
	pack_type = apack_type;	
	pack_mode_all = (apack_type == tall);
	bf_RPMdb = (apack_type == trpm && aflag);
	bf_DEBdb = (apack_type == tdeb && aflag);
}
//---------------------------------------------------------------------
void TKPackViewer::SetPathTo(QString apath)
{
	if (VERB_PLUS) { cerr << "Requested Pack: " << requested_pack << "\n"; }
	
	if (!IsDirectory(apath)) 
	{
		readable_pack = apath;
		GetParent(apath);
	}

	if (path_to_packs != apath || packages->count() == 0 || prev_type != pack_type)
	{
		path_to_packs = apath;
		LogDir(path_to_packs);
		amsg = "Packs in: " + path_to_packs;
		lp->setText(amsg);
		QToolTip::add(lp,amsg);
	}

	if (VERB_PLUS) { cerr << "Readable Pack: " << readable_pack << "\n"; }
	if (VERB_PLUS) { cerr << "Pack Folder: "   << path_to_packs << "\n"; }
}
//---------------------------------------------------------------------
void TKPackViewer::RemoveItem()
{
	if (packages->currentItem() > -1) packages->removeItem(packages->currentItem());
}
//---------------------------------------------------------------------
void TKPackViewer::LogDir(QString adir)
{
	DIR *dir;
	struct dirent *dirent;

	packtree->setFocus();
	packages->clear();
	packages->clearSelection();
	PrintMsg("Logging Directory `" + adir + "'....."); 
	if (VERB_PLUS) { cerr << "Logging Dir: " << adir << "\n"; }
	BlockFrame(true);
	dir = opendir(adir);
	if (dir != NULL) 
	{
		do 
		{
			dirent = readdir(dir);
			if (dirent != NULL && strcmp(dirent->d_name,".") != 0 && strcmp(dirent->d_name,"..")!= 0)
			{
				if (pack_mode_all) 
				{
					if (GetPackType(dirent->d_name) != tslack) packages->inSort(dirent->d_name);
				}
				else
				{
					if (pack_type == GetPackType(dirent->d_name)) packages->inSort(dirent->d_name);
				}
			}
			if (VERB_PLUS) { cerr << "."; }
			KPVApp->processEvents();
		} while (dirent != NULL);
		if (VERB_PLUS) { cerr << "\n"; }
		closedir(dir);
	}
	else { adir = "Verify! Can not log directory: " + adir; Warn(adir); }
	BlockFrame(false);
}
//---------------------------------------------------------------------
void TKPackViewer::BlockFrame(bool blockit)
{
	blockit ?  SetLedOn() : SetLedOff();
	tabbar->blockSignals(blockit);
	packages->blockSignals(blockit);
	packtree->blockSignals(blockit);
	results->blockSignals(blockit);
	info->blockSignals(blockit);	
	listview->blockSignals(blockit);
	KPVApp->processEvents();
}
//---------------------------------------------------------------------
TPack TKPackViewer::GetPackType(QString astr)
{
	QString ext("");
	ext = GetPackExt(astr);
	if (ext == "rpm"					)  	return trpm;
	if (ext == "deb"					)	return tdeb;
	if (ext == "zip"					)	return tzip;
	if (ext == "tar.bz2"				)	return tbz2;
	if (ext == "tgz" || ext == "tar.gz"	)	return tgz;
	if (ext == "lzh" || ext == "lha"	)	return tlzh;
	if (ext == "gz"  || ext == "z"		)	return tz;
	return tslack;
}
//---------------------------------------------------------------------
QString TKPackViewer::GetPackExt(QString astr)
{
	QString ext(astr.lower());
	switch (ext.contains("."))
	{	
		case 0:  return ""; // We have no extension to check...
		case 1:  return ext.mid(ext.findRev(".")+1,ext.length());
		default: // We have more than one dot...
		// The last part of the extension is
		ext = ext.mid(ext.findRev(".")+1,ext.length());
		// Cases that need special care: .tar.gz and .tar.bz2
		if (ext == "gz" || ext == "bz2")
		{
			QString aux("");
			aux = astr.mid(0,astr.findRev(".")-1);
			int tarpoint = aux.findRev(".");	// Position of second point
			if (tarpoint <=0) return ext;
			aux = astr.mid(tarpoint+1,astr.length());
			if (aux == "tar.gz" || aux == "tar.bz2") return aux;
		}
	}
	return ext;
}
//---------------------------------------------------------------------
QString TKPackViewer::GetValidExts(TPack apack_type)
{
	if (pack_mode_all) return "*.deb *.rpm *.zip *.tar.bz2 *.tgz *.z *.gz *.lzh *.lha";
	switch (apack_type)
	{
		case tdeb: return "*.deb";
		case trpm: return "*.rpm";
		case tzip: return "*.zip";
		case tgz : return "*.tgz *.tar.gz";
		case tbz2: return "*.tar.bz2";
		case tlzh: return "*.lzh *.lha";
		case tz  : return "*.z *.gz";
		default  : return "*";		
	}
}
//---------------------------------------------------------------------
void TKPackViewer::GetPacks(TPack apack_type)
{
	bool bf_savRPMdb = bf_RPMdb;
	SetModeTo(apack_type, false);
	
	// Now choose folder...
	if (!ChoosePacks()) 
	{ 
		bf_RPMdb = bf_savRPMdb;
		pack_mode_all = (prev_type == tall);
		pack_type = prev_type; 
		PrintMsg("Ready"); 
		return; 
	}
	
	// Attempts to cd and log dir based on pattern...
	SetPathTo(requested_pack);
	SetPack();
}
//---------------------------------------------------------------------
void TKPackViewer::SetPack()
{
	// Attempts to select the proper item in list based on requested_pack...
	int itmidx = GetItemIndex(requested_pack);
	(itmidx == -1) ? packages->clearSelection() : packages->setCurrentItem(itmidx);
	packages->setFocus();
}
//---------------------------------------------------------------------
void TKPackViewer::RefreshPacks()
{
	if (pack_type == tslack) return;

	// Relogs path_to_packs...
	if (VERB_PLUS) { cerr << "Refreshing... \n"; }
	if (isRPMdb()) { MountRPM(); return; }	
	LogDir(path_to_packs);
	SetPack();
}
//---------------------------------------------------------------------
int TKPackViewer::GetItemIndex(QString anitem)
{
	unsigned int i;
	QString lstitm("");
	if (VERB_PLUS) { cerr << "Looking for: " << anitem << " in pack list...\n"; }	
	for(i=0; i < packages->count(); i++)
	{
		lstitm = packages->text(i);
		lstitm = path_to_packs + lstitm.stripWhiteSpace();
		if (VERB_ERR) { cerr << "Comparing: (" << anitem << " with " << lstitm << "\n"; }
		if (anitem == lstitm)
		{
			if (VERB_PLUS) { cerr << "Found @: (" << i << ") in pack list.\n"; }
			return i;
		}
		KPVApp->processEvents();
	}
	if (VERB_PLUS) { cerr << "NOT Found (" << i << ") item: " << anitem << "\n"; }
	return -1;
}
//---------------------------------------------------------------------
void TKPackViewer::ShowPack()
{
	if (bf_DEBdb) { ShowDEBList(); ShowDEBInfo(); return; }
	requested_pack = path_to_packs + packages->text(packages->currentItem());
	if (VERBOSE) { cerr << "Pack Request: " << requested_pack << "\n"; }
	PrintMsg("Preparing package `" + requested_pack + "'.....");
	readable_pack = requested_pack;
	DoShowPack();
}
//---------------------------------------------------------------------
void TKPackViewer::DoShowPack()
{
	// MODE_ALL needs to detect pack_type based on file extension...
	if (pack_mode_all) pack_type = GetPackType(packages->text(packages->currentItem()));

	amsg = "KPackViewer - " + requested_pack;	
	setCaption(amsg);
	timer->restart();
	amsg = "Querying package " + requested_pack;
	switch (pack_type)
	{
		case trpm: DoProcess("rpm -qip "   , "rpm -qpl "   , ""           ); break;
		case tdeb: DoProcess("dpkg --info ", "dpkg-deb -c ", ""           ); break;
		case tgz : DoProcess(""            , "gzip -dc "   , " | tar tvv "); break;
		case tbz2: DoProcess(""            , "bunzip2 -c " , " | tar tvv "); break;
		case tzip: DoProcess("unzip -Zs "  , "unzip -Z1 "  , ""           ); break;
		case tlzh: DoProcess(""            , "lha -l "     , ""           ); break;
		case tz  : DoProcess(""            , "gzip -lvc "  , ""           ); break;
		default  : info->clear(); ReadPack();
	}
}
//---------------------------------------------------------------------
void TKPackViewer::DoProcess(QString p1, QString p2, QString p3)
{
	ShowWait("Querying Package: " + requested_pack);
	isInfo = (!p1.isEmpty());
	if (isInfo)
	{
		amsg += " information";
		PrintMsg("Please wait... " + amsg);
		if (pack_type == trpm) GetRPMInfo();
		else ProcessExec(p1 + requested_pack); 
	}
	
	amsg = "Querying package " + requested_pack;
	isInfo = false;
	amsg += " structure";
	PrintMsg("Please wait... " + amsg);	
	if (isRPMdb()) p2 = "rpm -ql ";
	if (p3.isEmpty()) ProcessExec(p2 + requested_pack); 
	else ProcessExec(p2 + requested_pack + p3); 
}
//---------------------------------------------------------------------
void TKPackViewer::ProcessExec(QString AQry)
{
	SetLedOn();;
	exec_ok = true;
	KShellProcess *proc = new KShellProcess();	
	AQry += " > " + user_path + FLE_LOG;
	(*proc) << AQry;
	connect(proc,SIGNAL(receivedStderr(KProcess *,char *,int)),this,SLOT(ProcessOutput(KProcess *,char *,int)));
	connect(proc,SIGNAL(receivedStdout(KProcess *,char *,int)),this,SLOT(ProcessOutput(KProcess *,char *,int)));
	connect(proc,SIGNAL(processExited(KProcess *)),this,SLOT(ProcessEnd(KProcess *)));
	KPVApp->processEvents(5000);
	proc->start(KProcess::Block, KProcess::AllOutput);
}
//---------------------------------------------------------------------
void TKPackViewer::ProcessEnd(KProcess *proc)
{
	SetLedOff();
	KPVApp->processEvents();
	DESTROY(proc);
	if (VERB_PLUS) { cerr << "Query Log file DONE!\n"; }
	if (!exec_ok) return;
	SetInfoView();
	BlockFrame(true);
	if (isInfo) 
	{
		(pack_type == trpm) ? FormatRPMInfo() : FormatPackInfo();
	}
	else
	{
		if (pack_type != trpm && pack_type != tzip && pack_type != tdeb) FormatPackInfo();
		if (pack_type == trpm || pack_type == tzip) Pack_Parse();
		PreparePackFile();
		readable_pack = user_path + FLE_PAK;
		ReadPack();
	}
	BlockFrame(false);	
}
//---------------------------------------------------------------------
void TKPackViewer::ProcessOutput(KProcess*, char *buffer, int buflen)
{
	KPVApp->processEvents();
	exec_ok = true; shell_out = buffer; shell_out = shell_out.mid(0,buflen);
	if (shell_out.find(" fail "     ,0,false) > -1 || 
		shell_out.find(" error "    ,0,false) > -1 || 
		shell_out.find("cannot find",0,false) > -1 || 
		shell_out.find("no such"    ,0,false) > -1 || 
		shell_out.find(" unknown "  ,0,false) > -1)
	{
		exec_ok = false;
		cerr << shell_out << "\n";
		shell_out = "\nERROR while querying package: " + requested_pack + "\n\nProcess Output is:\n\n" + shell_out;
		ViewOutput();
		results->clear();
		packtree->clear();
		info->clear();
	}
}
//---------------------------------------------------------------------
void TKPackViewer::ViewOutput()
{
	DESTROY(Shell_Viewer);
	Shell_Viewer= new TInfoWindow("Output Viewer", shell_out);
	Shell_Viewer->exec();
	DESTROY(Shell_Viewer)
}
//---------------------------------------------------------------------
void TKPackViewer::FormatPackInfo()
{
	QString dummy(""), dprev("");
	QString len(""), atr(""), stp(""), itm("");

	info->clear(); 
	listview->clear();
	listview->setColumnWidth(0,70);
	listview->setColumnWidth(1,70);
	listview->setColumnWidth(2,70);
	listview->setColumnWidth(3,70);
 	f= fopen(user_path + FLE_LOG, "r");
	if (f != NULL ) 
	{
		listview->setUpdatesEnabled(false);
		do
		{
			fgets(buf,BUFLEN,f); dummy = buf;
			if (dummy != dprev) 
			{
				info->insertLine(dummy.stripWhiteSpace());
				if (dummy.left(7) != "-------" && dummy.left(1) != " " && 
					dummy.find("bytes uncompressed,",0,false) == -1 && dummy.left(9) != "Archive: ")
				{
					len = GetInfoLen(dummy); atr = GetInfoAtr(dummy); 
					stp = GetInfoStp(dummy); itm = GetInfoItm(dummy);
					(void) new QListViewItem(listview,atr,stp,len,itm);
				}
			}
			dprev = dummy;
			KPVApp->processEvents();
		} while (!feof(f));
		fclose(f);
		listview->setUpdatesEnabled(true);
		listview->repaint();
	}
}
//---------------------------------------------------------------------
QString TKPackViewer::GetInfoLen(QString astr)
{
	switch (pack_type)
	{
		case tzip: astr = astr.mid(20,9); break;
		case tbz2:
		case tgz : astr = astr.mid(22,9); break;
		case tlzh: astr = astr.mid(17,9); break;
		case tz  : astr = astr.mid(39,9); break;
		default  : astr = "";
	}
	return astr.stripWhiteSpace();
}
//---------------------------------------------------------------------
QString TKPackViewer::GetInfoAtr(QString astr)
{
	switch (pack_type)
	{
		case tzip: astr = astr.mid( 0,8); break;
		case tbz2:
		case tgz : astr = astr.mid(0,21); break;
		case tlzh: astr = astr.mid(0,17); break;
		case tz  :
		default  : astr = "";
	}
	return astr.stripWhiteSpace();
}
//---------------------------------------------------------------------
QString TKPackViewer::GetInfoStp(QString astr)
{
	switch (pack_type)
	{
		case tzip: astr = astr.mid(35,17); break;
		case tbz2:
		case tgz : astr = astr.mid(31,17); break;
		case tlzh: astr = astr.mid(33,13); break;
		case tz  : astr = astr.mid(15,13); break;
		default  : astr = "";
	}
	return astr.stripWhiteSpace();
}
//---------------------------------------------------------------------
QString TKPackViewer::GetInfoItm(QString astr)
{
	switch (pack_type)
	{
		case tzip: astr = astr.mid(52,astr.length()); break;
		case tbz2:
		case tgz : astr = astr.mid(48,astr.length()); break;
		case tlzh: astr = astr.mid(46,astr.length()); break;
		case tz  : astr = astr.mid(55,astr.length()); break;
		default  : astr = "";
	}
	return astr.stripWhiteSpace();
}
//---------------------------------------------------------------------
void TKPackViewer::GetRPMInfo() // Well, let's make the hard way...
{								// once -qip does not cooperate
	frmt = true;
	info->clear();
	PrintMsg("Please wait... Querying RPM package " + requested_pack + " information...");
	if (VERBOSE) { cerr << "*** " << amsg << "...\n"; }
	DoGetRPMInfo("NAME"         , " \"%{NAME}-%{VERSION}-%{RELEASE}\n\" ");
	DoGetRPMInfo("RELEASE"      , " \"%{RELEASE}\n\" "                   );
	DoGetRPMInfo("GROUP"        , " \"%{GROUP}\n\" "                     );
	DoGetRPMInfo("DISTRIBUTION" , " \"%{DISTRIBUTION}\n\" "              );
	DoGetRPMInfo("VENDOR"       , " \"%{VENDOR}\n\" "                    );
	DoGetRPMInfo("SUMMARY"      , " \"%{SUMMARY}\n\" "                   );
	DoGetRPMInfo("SIZE"         , " \"%{SIZE} bytes\n\" "                );
	DoGetRPMInfo("COPYRIGHT"    , " \"%{COPYRIGHT}\n\" "                 );	
	DoGetRPMInfo("OS"           , " \"%{OS}\n\" "                        );
	DoGetRPMInfo("BUILDHOST"    , " \"%{BUILDHOST}\n\" "                 );
	DoGetRPMInfo("SOURCERPM"    , " \"%{SOURCERPM}\n\" "                 );
	DoGetRPMInfo("PACKAGER"     , " \"%{PACKAGER}\n\" "                  );
	DoGetRPMInfo("URL"          , " \"%{URL}\n\" "                       );
	DoGetRPMInfo("BUILDTIME"    , " \"%{BUILDTIME:date}\n\" "            );
	DoGetRPMInfo("SERIAL"       , " \"%{SERIAL}\n\" "                    );
	DoGetRPMInfo("RPMVERSION"   , " \"%{RPMVERSION}\n\" "                );
	frmt = false;
	DoGetRPMInfo("PREINSTALL"   , " \"%{RPMTAG_PREIN}\n\" "              );
	DoGetRPMInfo("POSTINSTALL"  , " \"%{RPMTAG_POSTIN}\n\" "             );
	DoGetRPMInfo("PREUNINST"    , " \"%{RPMTAG_PREUN}\n\" "              );
	DoGetRPMInfo("POSTUNINST"   , " \"%{RPMTAG_POSTUN}\n\" "             );
	DoGetRPMInfo("VERIFY"       , " \"%{VERIFYSCRIPT}\n\" "              );
	DoGetRPMInfo("PROVIDES"     , " \"[%{PROVIDES}\n]\n\" "              );	
	DoGetRPMInfo("REQUIRES"     , " \"[%{REQUIRENAME} %{REQUIREFLAGS:depflags} %{REQUIREVERSION}\n]\n\" ");
	DoGetRPMInfo("DESCRIPTION"  , " \"%{DESCRIPTION}\n\" "               );		
	DoGetRPMInfo("CHANGELOG"    , " \"[* %{CHANGELOGTIME:date} %{CHANGELOGNAME}\n%{CHANGELOGTEXT}\n\n]\n\" ");
}
//---------------------------------------------------------------------
void TKPackViewer::DoGetRPMInfo(QString Param, QString AQry)
{
	amsg = Param + ": ";
	bf_RPMdb ? AQry = "rpm -q --qf" + AQry : AQry = "rpm -qp --qf" + AQry;
	AQry += requested_pack;
	ProcessExec(AQry);
}
//---------------------------------------------------------------------
void TKPackViewer::FormatRPMInfo()
{
	QString dummy(""), dprev("");
	
	if (!frmt) 
	{
		info->insertLine("    ");
		info->insertLine("--- " + amsg);
	}
 	f= fopen(user_path + FLE_LOG, "r");
	if (f != NULL ) 
	{
		do
		{
			fgets(buf,BUFLEN,f); dummy = buf;
			if (dummy != dprev) // paranoid
			{
				if (frmt) info->insertLine(amsg + dummy.stripWhiteSpace());
				else info->insertLine("   " + dummy.stripWhiteSpace());
			}
			dprev = dummy;
			KPVApp->processEvents();
		} while (!feof(f));
		fclose(f);
	}
}
//---------------------------------------------------------------------
void TKPackViewer::ReadPack()
{
	if (!InitFrame()) return;
	
	if (VERBOSE)   { cerr << "*** Scanning Package: " << requested_pack << "\n"; }
	if (VERB_PLUS) { cerr << "*** Readable Package: " << readable_pack << "\n"; }

	WaitDone();

	StartMeter();
	f=fopen(readable_pack,"r");
	if (f != NULL ) 
	{
		do 
		{
			fgets(buf,BUFLEN,f);
			if (!feof(f))
			{
				curr = buf;
				if (StringAccepted(curr))
				{
					if (ListBegins()) 
					{
						AddToTree();
						if (!UpdateMeter() || !MemAvail()) goto breakit;
					}
					prev = curr;
				}
			}
			// KPVApp->processEvents();
		} while (!feof(f));
breakit:fclose(f);
	}
	StopMeter();
	PrintElapsed();
}
//---------------------------------------------------------------------
bool TKPackViewer::StringAccepted(QString &astr)
{
	if (bf_virtslak) 
	{ 
		// Strip only not "formatted" lines...
		if (astr.left(1) != " " && astr.left(1) != "\t") 
		{ 
			astr = astr.stripWhiteSpace();
			return (ValidStr(astr));
		}
		if (astr.right(1) == "\n") astr = astr.mid(0,astr.length()-1);
		return true;
	}
	else 
	{
		astr = astr.stripWhiteSpace(); 
		return (ValidStr(astr));
	}
}
//---------------------------------------------------------------------
void TKPackViewer::PrintElapsed()
{
	QTime *tf = new QTime();
	*tf = tf->addMSecs(timer->elapsed());
	PrintMsg("Ready - Elapsed: " + tf->toString() + " (hh:mm:ss)");
	delete tf;	
	if (VERBOSE) { cerr << "\n*** DONE! - " << timer->elapsed() << " mseg - " << requested_pack << "\n"; }
}
//---------------------------------------------------------------------
bool TKPackViewer::ListBegins()
{
	// List already begin
	if (idx >= 0) { results->insertItem(curr); return true; }
	
	KPVApp->processEvents();
	
	bool is_FILE_LIST_LINE = (curr.find("FILE LIST:",0,false) > -1);
	
	if (is_FILE_LIST_LINE)
	{
		// Check presence of the "contents" in slakware distribution tree
		if (pack_type == tgz) CheckSlakContents();
		// Add this_item anyway
		results->insertItem(curr);
	}
	
	// Detects begin of FILE LIST...
	if (curr.left(2) == "./")
	{
		results->insertItem(curr);
		idx++;		
		curr = "/";	
		if (VERBOSE) { cerr << "Root   : " << idx << " - " << curr << "\n"; }
	}
	
	// Arrange things to slakware...
	if (pack_type == tslack)
	{
		if (!bf_virtslak)
		{
			if (!is_FILE_LIST_LINE && curr.find("/",0,false) == -1) info->insertLine(curr);
			if (is_FILE_LIST_LINE) AppendSlackScript();
		}
		else 
			if (!is_FILE_LIST_LINE && curr != "/") info->insertLine(curr);
	}
	return false;
}
//---------------------------------------------------------------------
void TKPackViewer::CheckSlakContents()
{
	FILE *skf;
	QString dummy(""), astr(path_to_packs);
	astr = astr.mid(0,astr.length()-1);
	astr = path_to_packs + "disk" + astr.mid(astr.findRev("/")+1, astr.length());
	skf= fopen(astr, "r");
	if (skf != NULL ) 
	{
		if (VERBOSE) { cerr << "*** Found slak contents file: " << astr << "\n"; }
		astr = packages->text(packages->currentItem());
		astr = astr.mid(0,astr.findRev(".")) + ":";
		if (VERB_PLUS) { cerr << "Filtering to: " << astr << "\n"; }
		do
		{
			fgets(buf,BUFLEN,skf); dummy = buf;
			dummy = dummy.stripWhiteSpace() + "\n";
			if (dummy.left(astr.length()) == astr) results->insertItem(dummy);
		} while (!feof(skf));
		fclose(skf);
	}
}
//---------------------------------------------------------------------
void TKPackViewer::AddToTree()
{
	cbuf = curr;
	if (IsDirectory(curr))
	{
		if (IsSubDirectory(curr, prev)) AddItem();
		else
		{
			ScanParent();
			AddItem();
		}
		idx = packtree->count()-1;
	}
	else
	{
		if (!InItemFolder(curr)) ScanParent();
		AddItem();
	}
}
//---------------------------------------------------------------------
void TKPackViewer::ScanParent()	// BruteForce is always something dumb....
{								// But you can bet that it - right applied - works...
	bool bfpop = true;
	QString ditem(""), dparent("");
	
	dparent = curr;
	GetParent(dparent);
	GetFullPath(idx, ditem);
	if (!ParentInBuf(dparent)) 
	{
		PrintMsg("Scanning `" + dparent + "'.....");
		if (VERBOSE) { cerr << "\nScanning ParentIDX (" << idx << "): " << dparent << "\n"; }
		do
		{
			if (InRoot(ditem) || InRoot(dparent))
			{ 
				idx = 0; 
				bfpop = false; 
			}
			else 
			{
				if (IsSubDirectory(curr, ditem.mid(1,ditem.length())))
				{
					bfpop = false;
					if (!IsDirectory(ditem))
					{
						idx--;
						GetFullPath(idx, ditem);
						if (VERB_PLUS) { cerr << "Pop Mor: " << idx << " - "<< ditem << "\n"; }
					}
				}
				else 
				{
					idx--;
					GetFullPath(idx, ditem);
					if (VERB_PLUS) { cerr << "Pop Dir: " << idx << " - "<< ditem << "\n"; }
					if (ditem == dparent) bfpop = false;
				}
			}
			KPVApp->processEvents();
		}while (bfpop);
	}
	if (VERBOSE) { cerr << "Match @: " << idx << " - "<< ditem << "\n"; }
}
//---------------------------------------------------------------------
bool TKPackViewer::ParentInBuf(QString aparent)
{
	QString aux("");
	aux = "#" + aparent + "@";
	int atpos = dirlog.find(aux,0,true);
	if (VERB_PLUS) { cerr << "In BUF ?: " << aux << "\n"; }
	
	if (atpos == -1) // Not found...
	{ 
		if (VERB_PLUS) { cerr << "NO!: " << dirlog << "\n"; }	
		return false;
	}

	if (VERB_PLUS) { cerr << "YES @(" << atpos << "): " << dirlog << "\n"; }
	if (aparent != lastparent) // Avoid repeating scanning process...
	{
		parentpos  = GetDirIdx(aparent);
		if (parentpos ==  -1) { if (VERBOSE) { cerr << "\n"; } return false; }
		lastparent = aparent;
	}
	idx = parentpos;
	if (VERBOSE) { cerr << "\n"; }
	return true;
}
//---------------------------------------------------------------------
int TKPackViewer::GetDirIdx(QString ADir)
{
	QString aux("");
	PrintMsg("Searching `" + ADir + "'.....");
	if (VERBOSE) { cerr << "\nSearching ParentIDX (" << idx << "): " << ADir << "\n"; }
	for(int i=0; i < (int)packtree->count(); i++)
	{
		GetFullPath(i,aux);
		if (VERBOSE) { cerr << "."; }
		if (aux == ADir) return i;
		KPVApp->processEvents();
	}
	return -1;
}
//---------------------------------------------------------------------
void TKPackViewer::Pack_Parse()
{
	char oldbuf[BUFLEN];
	QString strcurr("FILE LIST:\n./\n"), strprev("./"), strwrt("");

	whatidid = "#";
 	f = fopen(user_path + FLE_LOG, "r");
 	nf= fopen(user_path + FLE_DIR, "w");
	if (f != NULL && nf != NULL) 
	{
		fputs(strcurr,nf);
		PrintMsg("Analyzing dir struct...");
		if (VERBOSE) { cerr << "*** Analyzing dir struct...\n"; }		
		do 
		{
			fgets(buf,BUFLEN,f); strcurr = buf;
			strcurr = strcurr.stripWhiteSpace();
			if (ValidStr(strcurr))
			{
				if (strcurr.left(1) != "/") strcurr = "/" + strcurr;
				if (VERB_ERR) { cerr << "\nRead: " << strcurr; }
				if (strcurr.find("/") > -1)	// This must always be_true	
				{
					// So we separate the "directory part"...
					strcurr = strcurr.mid(1,strcurr.findRev("/"));
					if (VERB_ERR) { cerr << "\nDirSpec: " << strcurr << "\n"; }
				}
					
				// Now we have a clean directory to deal with...	
				if (strcurr != strprev) Process_Pack_Entry(strcurr);
				
				if (strcmp(buf, oldbuf) != 0)
				{
					strwrt = buf;
					if (strwrt.left(1) == "/") strwrt = strwrt.mid(1,strwrt.length());
					strwrt = strwrt.stripWhiteSpace() + "\n";
					fputs(strwrt,nf);
					if (VERB_ERR) { cerr << "Entryto: " << strwrt; }
				}
				strprev = strcurr;
				strcpy(oldbuf, buf);
			}
			if (VERB_PLUS) { cerr << "."; }
			KPVApp->processEvents();
		} while (!feof(f));
		if (VERB_PLUS) { cerr << ".\n"; }
		if (VERB_PLUS) { cerr << "Pack Dir analysis DONE!...\n"; }
		fclose(f);
		fclose(nf);
	}
}
//---------------------------------------------------------------------
void TKPackViewer::Process_Pack_Entry(QString strcurr)
{
	int numpar, j, atpos;
	QString	straux(""), strhold(""), strbuf("");

	// Now let's play... We have a different directory
	strhold = "";						// Accumulates path
	straux = strcurr;					// Retains the path part on focus
	numpar = strcurr.contains("/");
	
	// Let's ask if_every part of the directory entry is already "buffered"...
	for (int i=1; i <= numpar; i++)
	{
		straux = straux.mid(0,straux.find("/")+1);
		if (VERB_ERR) { cerr << "Focus: " << straux << "\n"; }
		
		strbuf = strhold + straux;
		if (VERB_ERR) { cerr << "IsInWhatIDid?: " << "#" + strbuf << "\n"; }
		atpos = whatidid.find("#" + strbuf);
		if (atpos == -1)
		{
			if (VERB_ERR) { cerr << "NO! Parses: " << numpar - i << "\n"; }
								
			fputs(strbuf + "\n",nf);
			if (VERB_ERR) { cerr << "Write: " << strbuf << "\n"; }
	
			whatidid += (strbuf + "#");
			if (VERB_ERR) { cerr << "WhatIDid: " << whatidid << "\n"; }
		}					
		else if (VERB_ERR) { cerr << "Found at: " << atpos << " skiping...\n"; }
		
		strhold += straux;
		if (VERB_ERR) { cerr << "Hold: " << strhold << "\n"; }
		
		straux = strcurr;
		for (j=1; j <= i;j++)
			straux = straux.mid(straux.find("/")+1, straux.length());
		if (VERB_ERR) { cerr << "Remains : " << straux << "\n"; }
		KPVApp->processEvents();
	}
}
//---------------------------------------------------------------------
void TKPackViewer::PreparePackFile()
{
	QString strcurr(""), strprev("");
 
  	nf= fopen(user_path + FLE_PAK, "w");
 	if (pack_type == trpm || pack_type == tzip)
		f = fopen(user_path + FLE_DIR, "r");
 	else
		f = fopen(user_path + FLE_LOG, "r");

	if (f != NULL && nf != NULL) 
	{
		PrintMsg("Creating package list file...");
		if (VERBOSE) { cerr << "*** Creating package list file...\n"; }		
		if (pack_type == tdeb) fputs("FILE LIST:\n",nf);
		if (pack_type == tgz || pack_type == tbz2 || pack_type == tlzh || pack_type == tz) fputs("FILE LIST:\n./\n",nf);
		if (pack_type == tlzh) { fgets(buf,BUFLEN,f); fgets(buf,BUFLEN,f); }
		do 
		{
			fgets(buf,BUFLEN,f); strcurr = buf;
			if (pack_type == tdeb || pack_type == tgz || pack_type == tbz2) strcurr = strcurr.mid(48,strcurr.length());
			if (pack_type == tlzh) strcurr = strcurr.mid(46,strcurr.length());
			if (pack_type == tz) strcurr = strcurr.mid(55,strcurr.length());
			strcurr = strcurr.stripWhiteSpace();
			if (pack_type == tgz && strcurr == "./") strcurr = "";
			if (ValidStr(strcurr))
			{
				if (pack_type == trpm)
				{
					if (strcurr != strprev + "/") fputs(strprev + "\n",nf);
				}
				else if (pack_type == tdeb || pack_type == tgz || pack_type == tbz2 || pack_type == tz)
				{
					if (strcurr != strprev) fputs(strcurr + "\n",nf);
				}
				else if (pack_type == tlzh)
				{
					if (strcurr != strprev && strcurr.right(3) != "---") fputs(strcurr + "\n",nf);
				}
				else
				{				
					if (strcurr != strprev && strcurr != strprev + "/") fputs(strprev + "\n",nf);
				}
			}	
			strprev = strcurr;
			if (VERB_PLUS) { cerr << "."; }
			KPVApp->processEvents();
		} while (!feof(f));
		if (VERB_PLUS) { cerr << ".\n"; }
		if (VERB_PLUS) { cerr << "Package list file DONE!...\n"; }
		fclose(f);
		fclose(nf);
	}
}
//---------------------------------------------------------------------
bool TKPackViewer::InitFrame()
{
	// Initialize Widgets...
	results->clear();
	packtree->clear();
	packtree->insertItem("/", &hom, -1);

	// Initialize vars...
	idx  =  -1;
	curr = "";
	prev = "/";
	dirlog = "";
	lastparent = "";
	parentpos = 0;

	// Verify valid data...
	bf_virtslak = false;
	if (pack_type == tslack) 
	{
		if (!IsSlack()) { Warn(NOTSLAK); return false; }
		bf_virtslak = IsVirtualSlack();
	}
	flelns = PackSize(readable_pack);
	if (flelns > 1) return true;
	Warn(ERR_MSG);  return false;
}
//---------------------------------------------------------------------
bool TKPackViewer::IsSlack()
{
	FILE *stf;
	exec_ok = false;
	QString dummy("");
 	stf= fopen(requested_pack, "r");
	if (stf != NULL)
	{
		fgets(buf,BUFLEN,stf); dummy = buf;
		if (dummy.find("PACKAGE NAME:",0,false) > -1 || dummy.find("./",0,false) > -1 || dummy.find("VIRTUAL PACKAGE:",0,false) > -1) exec_ok = true;
		fclose(stf);
	}
	return exec_ok;
}
//---------------------------------------------------------------------
bool TKPackViewer::IsVirtualSlack()
{
	FILE *stf;
	exec_ok = false;
	QString dummy("");
 	stf= fopen(requested_pack, "r");
	if (stf != NULL)
	{
		fgets(buf,BUFLEN,stf); dummy = buf;
		if (dummy.find("VIRTUAL PACKAGE:",0,false) > -1) exec_ok = true;
		fclose(stf);
	}
	return exec_ok;
}
//---------------------------------------------------------------------
void TKPackViewer::AppendSlackScript()
{
	QDir slackdir(SLA_SCP);
	if (!slackdir.exists()) return;
	if (!slackdir.setCurrent(SLA_SCP)) return;
	QFile slack_script(packages->text(packages->currentItem()));
	if (slack_script.open( IO_ReadOnly ))
	{
		info->insertLine("   ");
		info->insertLine("---<Script>--------------------------");
		info->insertLine("   ");
		QTextStream tx( &slack_script );
		while (!tx.eof()) info->insertLine( tx.readLine() );
		slack_script.close();
	}
	exec_ok = slackdir.setCurrent(SLA_PAK);
}
//---------------------------------------------------------------------
int TKPackViewer::PackSize(QString fname)
{
	int	 numlnspack = 0; 
	QString dummy("");
 
 	f= fopen(fname, "r");
	if (f != NULL ) 
	{
		do 
		{
			fgets(buf,BUFLEN,f); dummy = buf;
			if (dummy.find("./",0,false) > -1) numlnspack++;
			if (numlnspack > 0 && !dummy.isNull() && !dummy.isEmpty() && dummy != "\n") numlnspack++;
			if (VERB_PLUS) { cerr << "."; }
		} while (!feof(f));
		fclose(f);
	}
	numlnspack -= 3;
	if (VERB_PLUS) { cerr << "\n"; }
	if (VERBOSE) { cerr << "*** Pack Size: " << numlnspack << " lines \n"; }
	return numlnspack;
}
//---------------------------------------------------------------------
void TKPackViewer::GetParent(QString &astr)
{
	if (InRoot(astr)) return;
	// Chop dir specificator...
	if (IsDirectory(astr)) astr = astr.mid(0,astr.length()-1);
	// Scan last path string component...
	if (astr.find("/") == -1) astr = "/";
	else astr = astr.mid(0,astr.findRev("/"));
	// Ensure valid path...
	if (!IsDirectory(astr)) astr += "/";
	if (astr.left(1) != "/") astr = "/" + astr;
}
//---------------------------------------------------------------------
void TKPackViewer::GetFullPath(int itmidx, QString &abuf)
{
	abuf = "";
	KPath *paux;
	paux = packtree->itemPath(itmidx);
	do
	{ abuf = *paux->pop() + abuf; }
	while (!paux->isEmpty());
}
//---------------------------------------------------------------------
void TKPackViewer::AddItem()
{
	QString abuf("");
	FormatItem(curr);
	PrintMsg("Adding `" + curr + "'");
	if (IsDirectory(cbuf))
	{
		packtree->addChildItem(cbuf, &fol, idx);
		packtree->expandItem(idx);
		if (VERB_PLUS) { cerr << "Add Dir: " << idx << " - " << cbuf << "\n"; }
		else if (VERBOSE) { cerr << "."; }
		GetFullPath(idx, abuf);
		if (VERB_ERR) { cerr << "ABUF: " << abuf << "\n"; }
		dirlog = dirlog + "#" + abuf + cbuf + "@"; 
		if (VERB_ERR) { cerr << "dirlog: " << dirlog << "\n"; }
	}
	else
	{
		QPixmap tmp = GetItemPixmap(cbuf);	// avoid warnings
		packtree->addChildItem(cbuf, &tmp, idx);
		packtree->expandItem(idx);
		if (VERB_PLUS) { cerr << "Add Doc: " << idx << " - " << cbuf << "\n"; }
		else if (VERBOSE) { cerr << "."; }
	}
}
//---------------------------------------------------------------------
void TKPackViewer::FormatItem(QString itm)
{
	bool bfdir = IsDirectory(itm);
	if (bfdir) itm = itm.mid(0,itm.length()-1);
	if (itm.find("/") == -1) cbuf = itm;
	else 
	{
		cbuf = itm.mid(itm.findRev("/")+1, itm.length());
		if (cbuf.left(1) == "/") cbuf = cbuf.mid(1, cbuf.length());
	}
	if (bfdir) cbuf += "/";
}
//---------------------------------------------------------------------
bool TKPackViewer::ValidStr(QString astr)
{
	// paranoid testing...
	return (astr != "" && !astr.isNull() && !astr.isEmpty() && astr.find("\n",0,false) == -1);
}
//---------------------------------------------------------------------
bool TKPackViewer::IsDirectory(QString astr)
{
	return (astr.right(1) == "/");
}
//---------------------------------------------------------------------
bool TKPackViewer::IsSubDirectory(QString adir, QString subdir)
{
	return (adir.find(subdir) > -1);
}
//---------------------------------------------------------------------
bool TKPackViewer::InRoot(QString &astr)
{
	// paranoid testing...
	if (astr == "/" || astr.isNull() || astr.isEmpty() || astr.find("/") == -1) 
	{
		if (astr.isNull() || astr.isEmpty() || astr.find("/") == -1) astr = "/";
		return true;
	}
	else return false;
}
//---------------------------------------------------------------------
bool TKPackViewer::InItemFolder(QString itm)
{
	QString ditem(""), dparent("");
	dparent = itm;
	GetParent(dparent);
	GetFullPath(idx, ditem);
	if (VERB_PLUS) { cerr << "Parent/Current: " << dparent << " -X- " << ditem << "\n"; }
	return (ditem == dparent);
}
//---------------------------------------------------------------------
void TKPackViewer::LoadIcon(QPixmap &anicon, QString icon_file)
{
	if (!anicon.load(data_path + "/" + icon_file))
	{
		cerr << "ERROR loading:" << data_path + "/" + icon_file << "\n";
		cerr << "Did you run the make install procedure ?\n"; 
	}
}
//---------------------------------------------------------------------
void TKPackViewer::LoadIcons()
{
	LoadIcon(KPV      ,"KPackViewer.xpm");
    LoadIcon(openSLACK,"slack.xpm"	);	LoadIcon(openRPM  ,"rpmpack.xpm");
	LoadIcon(openDEB  ,"debian.xpm"	);	LoadIcon(openZIP  ,"zipack.xpm"	);	
	LoadIcon(openTGZ  ,"targzip.xpm");	LoadIcon(openTBZ  ,"tarbzip.xpm");
    LoadIcon(openLHA  ,"lhapack.xpm");	LoadIcon(openGZP  ,"gzipack.xpm");
	LoadIcon(quitAPP  ,"quitapp.xpm");	LoadIcon(modeALL  ,"modeall.xpm");
	LoadIcon(lookOUT  ,"look.xpm"   );	LoadIcon(mntSLACK ,"mntslk.xpm" );
	LoadIcon(mntRPM   ,"rpmlogo.xpm");	LoadIcon(fresh    ,"fresh.xpm"  );
	LoadIcon(alien    ,"alien.xpm"  );	LoadIcon(mntDEB   ,"debian_logo.xpm");
	LoadIcon(ledred   ,"status_red.xpm" );	LoadIcon(ledgreen ,"status_green.xpm");
	
	LoadIcon(hom, "home.xpm"); 	LoadIcon(fol, "dir.xpm"); 
	LoadIcon(doc, "doc.xpm");	LoadIcon(zip, "zip.xpm");
	LoadIcon(hpp, "hpp.xpm");	LoadIcon(cpp, "cpp.xpm");
	LoadIcon(shl, "shl.xpm");	LoadIcon(lib, "lib.xpm");
	LoadIcon(pel, "pel.xpm");	LoadIcon(man, "man.xpm");		
	LoadIcon(pyt, "pyt.xpm");	LoadIcon(grf, "grf.xpm");			
	LoadIcon(pdf, "pdf.xpm");	LoadIcon(htm, "htm.xpm");
	LoadIcon(snd, "snd.xpm");	LoadIcon(awk, "awk.xpm");	
	LoadIcon(inf, "inf.xpm");	LoadIcon(tex, "tex.xpm");		
	LoadIcon(txt, "txt.xpm");	LoadIcon(mak, "mak.xpm");				
	LoadIcon(exl, "exl.xpm");	LoadIcon(fnt, "fnt.xpm");
	LoadIcon(tcl, "tcl.xpm");	LoadIcon(dif, "dif.xpm");	
	LoadIcon(eye, "eye.xpm");	LoadIcon(lsm, "slack.xpm");
	LoadIcon(pod, "pod.xpm");	LoadIcon(css, "css.xpm");
	LoadIcon(jav, "jav.xpm");	LoadIcon(pyo, "pyo.xpm");
	LoadIcon(pyc, "pyc.xpm");	LoadIcon(dbf, "dbf.xpm");
	LoadIcon(sgm, "sgm.xpm");	LoadIcon(lyx, "lyx.xpm");
	LoadIcon(vid, "vid.xpm");	LoadIcon(rtf, "rtf.xpm");
	LoadIcon(exe, "exe.xpm");	LoadIcon(ini, "ini.xpm");
	LoadIcon(m4 , "m4.xpm" );	LoadIcon(rpm, "rpm.xpm");
	LoadIcon(deb,"debpack.xpm");
}
//---------------------------------------------------------------------
QPixmap TKPackViewer::GetItemPixmap(QString itm)
{
	if (requested_pack == "RPM Groups Structure") return rpm;
	if (requested_pack == "Debian packages database") return deb;

	// Whatever... is some sort of...
	if (itm.find("makefile",0,false) > -1)	return mak;
	if (itm.find("readme"  ,0,false) > -1)	return eye;

	if (itm.find(".",0,false) == -1) 
	{
		if (itm == "COPYING" || itm.find("COPYRIGHT",0,false) > -1 || itm == "TODO" || itm == "INSTALL")
			return exl;
		return doc;
	}
	
	QString ext("");
	ext = itm.mid(itm.findRev("."),itm.length());
	ext = ext.lower();
	
// These in general don't have numbers to confuse...
	
	// Language associated files
	if (ext == ".h"						)	return hpp;
	if (ext == ".m4"					)	return m4;
	if (ext == ".awk"					)	return awk;
	if (ext == ".py"					)	return pyt;
	if (ext == ".pyo"					)	return pyo;
	if (ext == ".pyc"					)	return pyc;
	if (ext == ".pl"  || ext == ".pm"	)	return pel;
	if (ext == ".tcl" || ext == ".tk" 	)	return tcl;
	if (ext.find(".patch",0,false) > -1  || ext.find(".dif",0,false) > -1)				return dif;	
	if (ext == ".jav" || ext == ".js"  || ext == ".jar" || ext == ".class")				return jav;
	if (ext.find(QRegExp(".*sh", false, true)) > -1 || ext == ".bat" || ext == ".btm")	return shl;
	if (ext == ".c"   || ext == ".cpp" || ext == ".cc"  || ext == ".asm" || ext == ".pas" || ext == ".bas")	return cpp;

	// Document associated files
	if (ext == ".lsm"					)	return lsm;
	if (ext == ".pod"					)	return pod;
	if (ext == ".css"					)	return css;
	if (ext == ".sgml"					)	return sgm;
	if (ext == ".lyx"					)	return lyx;
	if (ext == ".rtf"					)	return rtf;
	if (ext == ".tex" || ext == ".texi"	)	return tex;	
	if (ext == ".doc" || ext == ".txt"	)	return txt;
	if (ext == ".htm" || ext == ".html"	)	return htm;

	// Media associated files
	if (   ext == ".avi" || ext == ".mpg" || ext == ".mov")	
		return vid;
	if (   ext == ".wav" || ext == ".au"  || ext == ".mid" || ext == ".ra")	
		return snd;
	if (   ext == ".gif" || ext == ".jpg" || ext == ".xpm" || ext == ".ico" 
		|| ext == ".xbm" || ext == ".bmp" || ext == ".pbm" || ext == ".pix" 
		|| ext == ".pcx" || ext == ".png" || ext == ".tif" || ext == ".pov")
		return grf;
	
	// Binary/Misc associated files
	if (ext == ".dll" || ext == ".sys"	)	return lib;
	if (ext == ".com" || ext == ".exe"	)	return exe;
	if (ext == ".dbf" || ext == ".mdb" || ext == ".sql") return dbf;
	if (ext == ".cfg" || ext == ".ini" || ext == ".pif" || ext == ".lnk" || ext == ".inf")	return ini;
	
	// Zip associated files
	if (ext == ".tgz" || ext == ".zip" || ext == ".z" || ext == ".Z" || ext == ".bz2") return zip;
	if (ext == ".rpm") return rpm;
	if (ext == ".deb") return deb;

	// Now we can have multiple numbers and  multiple dots...
	// And we dont have the files to read MAGIC NUMBERS...
	// Very context dependant - god help the creator of the names...
	// Order matters when building better RegExps...

	ext = itm.mid(itm.find("."),itm.length());
	if (ext == ".gz" ) return zip;
	if (ext.find(QRegExp(".info*[0-9].gz", false, true)) > -1 || ext == ".info.gz" || ext == ".info")														return inf;
	if (ext == ".pdf" || ext == ".eps" || ext == ".ps" || ext.find(QRegExp(".[0-9].ps", false, true)) > -1 || ext.find(QRegExp(".ps*",false,true)) > -1 || ext == ".dvi")		return pdf;	
	if (ext.find(QRegExp(".pcf*",false,true)) > -1 || ext == ".ttf" ||  ext == ".pfm" || ext == ".pfb" || ext == ".pfa" || ext == ".afm" || ext == ".gsf" || ext == ".spd")	return fnt;	
	if ((ext.find(".so.",0,false) == -1 || ext.right(3) == ".gz") && (ext == ".n" || ext == ".n.gz" || ext.find(QRegExp("*[0-9]*gz", false, true)) > -1 || ext.find(QRegExp("*.[0-9]", false, true)) > -1 || ext.find(QRegExp("*.[0-9]x", false, true)) > -1|| ext.find(QRegExp("*[0-9]*man", false, true)) > -1 ))	return man;
	if (ext == ".so" || ext == ".o" || ext == ".a" || ext == ".la"|| ext == ".sa"|| ext.find(QRegExp(".so.[0-9]*[0-9]", false, true)) > -1 || ext.find(QRegExp(".*[0-9].so", false, true)) > -1 || ext.find(QRegExp(".[0-9]*[0-9].a", false, true)) > -1 || ext.find(QRegExp(".so*", false, true)) > -1)		return lib;
	return doc;	
}
//---------------------------------------------------------------------
void TKPackViewer::SetLedOn()
{
	if (isBusy) return;
	isBusy = true;
	lt->setPixmap( ledred );
}
//---------------------------------------------------------------------
void TKPackViewer::SetLedOff()
{
	if (!isBusy) return;
	isBusy = false;
	lt->setPixmap( ledgreen );
}
//---------------------------------------------------------------------
void TKPackViewer::ShowWait(QString amsg)
{
	if ( WaitDlg != 0 ) return;
	SetLedOn();
	WaitDlg = new TKPVStatus(amsg);
	WaitDlg->show();   KPVApp->processEvents();
	WaitDlg->update(); KPVApp->processEvents();
}
//---------------------------------------------------------------------
void TKPackViewer::WaitDone()
{
	if ( WaitDlg != 0 ) { WaitDlg->hide(); DESTROY(WaitDlg); SetLedOff(); }
}
//---------------------------------------------------------------------
void TKPackViewer::BuildMeter()
{
    ProgDlg = new QProgressDialog(STANDBY, "Abort", 100, this, "Progress", true);
	ProgDlg->setCaption("Please Wait...");
	ProgDlg->setLabelText("Scanning Package");
	ProgDlg->setProgress(0);
	ProgDlg->reset();
}
//---------------------------------------------------------------------
void TKPackViewer::StartMeter()
{
	SetLedOn();
	count = 0;
	packtree->setAutoUpdate(false);
	amsg = "   Scanning Package:  " + requested_pack + "      ";
	if (VERB_ERR) { cerr << "Starting progress meter... (" << count <<  ") in (" << flelns << ")\n"; }	
	ProgDlg->setLabelText(amsg);
	ProgDlg->setTotalSteps(flelns);
	ProgDlg->setProgress(0);
	ProgDlg->show();
	KPVApp->processEvents();
}
//---------------------------------------------------------------------
bool TKPackViewer::UpdateMeter()
{
	count++;
	ProgDlg->setProgress(count);
	if (ProgDlg->wasCancelled())
	{ 
		if (VERBOSE) { cerr << "\n*** ABORTED by user! (" << count <<  ")\n"; }	
		return false;
	}
	if (VERB_ERR) { cerr << "counting: (" << count <<  ")\n"; }	
	
	if (count == 1 || count == (int)(flelns/4) ||  count == (int)(flelns/2) || count == (int)(3*flelns/4))
	{
		packtree->setAutoUpdate(true);
		packtree->repaint();
		KPVApp->processEvents();		
		packtree->setAutoUpdate(false);
	}
	
	if (count == (int)(flelns/32) || count == (int)(flelns/16)) KPVApp->processEvents();		
	
	return true;
}
//---------------------------------------------------------------------
void TKPackViewer::StopMeter()
{
	ProgDlg->setProgress(ProgDlg->totalSteps());
	ProgDlg->reset();
	KPVApp->processEvents();
	packtree->setAutoUpdate(true);
	packtree->repaint();
	KPVApp->processEvents();
	if (VERB_ERR) { cerr << "\nProgress meter stopped...(" << count <<  ") in (" << flelns << ")\n"; }
	count = flelns;
	SetLedOff();
}
//---------------------------------------------------------------------
void TKPackViewer::SetAppStyle(GUIStyle the_style)
{
	STYLE_MOTIF = (the_style == MotifStyle);

	mnuopt->setItemChecked(201,false);
	mnuopt->setItemChecked(202,false);
	STYLE_MOTIF ? mnuopt->setItemChecked(202,true) : mnuopt->setItemChecked(201,true);
	
	KApplication::setStyle(the_style);

	packmenu->hide();
	statusBar()->hide();
	packtools->hide();
	tabbar->hide();
	lp->hide();
	packtree->hide();
	packages->hide();
	results->hide();

	packmenu->setStyle(the_style);
	statusBar()->setStyle(the_style);	
	packtools->setStyle(the_style);
	tabbar->setStyle(the_style);
	lp->setStyle(the_style);
	packtree->setStyle(the_style);
	packages->setStyle(the_style);
	results->setStyle(the_style);

	packmenu->repaint(true);
	statusBar()->repaint(true);	
	packtools->repaint(true);
	tabbar->repaint(true);
	lp->repaint(true);
	packtree->repaint(true);
	packages->repaint(true);
	results->repaint(true);

	packmenu->recreate(this,0,packmenu->pos(),true);

	packmenu->show();
	statusBar()->show();	
	packtools->show();
	tabbar->show();
	lp->show();
	packtree->show();
	packages->show();
	results->show();

	Warn(UBTSTA);
}
//---------------------------------------------------------------------
void TKPackViewer::About()
{
	QString wintxt("");
	wintxt = "
<HTML>
<HEAD>
   <META HTTP-EQUIV=Content-Type CONTENT=text/html; charset=iso-8859-1>
   <TITLE>KPV About</TITLE>
</HEAD>

<BODY TEXT=#000000 BGCOLOR=#FFFFFF LINK=#0000FF VLINK=#FF0000 ALINK=#000088>

<CENTER>
<H1>KPackViewer v." KPACK_VER " </H1></CENTER>
<P>
<CENTER>
<H3><FONT COLOR=RED><B>
About</B></FONT></H3></CENTER>
<P>

<HR WIDTH=100%><P><FONT SIZE=+1>

&copy; Eng.Ele. Paulo Castro - 1998<BR>
<B><FONT SIZE=-1>Looking for a serious position in Canada, US, UK or Australia.</FONT></B><BR>
<P>
E-Mail: <A HREF=mailto: hook@netrio.com.br>hook@netrio.com.br</A><BR>
KPV Home: <A HREF=http://www.momentus.com.br/users/hook/kpackviewer.html>http://www.momentus.com.br/users/hook/kpackviewer.html</A><BR>
<P>
This program is free software; you can redistribute it and/or modify it 
under the terms of the GNU General Public License.<BR>
<P>
Keep in mind that this is a on going work, you may find some minor bugs that 
I am still working. Please report bugs! This feedback made me reach as far as 
here, thanks in advance for your tolerance...<BR>
<P>
I hope you think this program is useful.<BR>
Be shure to visit the HomePage for the latest improvements.<P><P>
</FONT><HR WIDTH=100%>
<CENTER><FONT SIZE=-1>&copy; Eng.Ele. Paulo Castro</FONT></CENTER>
<CENTER><FONT SIZE=-2><A HREF=mailto: hook@netrio.com.br>hook@netrio.com.br</A></FONT></CENTER>
</BODY>
</HTML>
";
	DESTROY(Shell_Viewer);
	Shell_Viewer = new TInfoWindow("About KPackViewer", wintxt, true);
	Shell_Viewer->exec();
	DESTROY(Shell_Viewer);
}
//---------------------------------------------------------------------
void TKPackViewer::Help() 
{
	KPVApp->invokeHTMLHelp( "", "" );
}
//---------------------------------------------------------------------
void TKPackViewer::PrintMsg(QString msg) 
{
	statusBar()->message(msg);
	statusBar()->update();
}
//---------------------------------------------------------------------
void TKPackViewer::Quit() 
{
	SaveConfig();
	cerr << "Bye.\n\n";
	KPVApp->quit();
}
//---------------------------------------------------------------------
void TKPackViewer::SaveConfig() 
{
	KConfig *conf = KPVApp->getConfig();
	
	conf->setGroup( "Options" );
	cfgbuf = conf->writeEntry( "Style", STYLE_MOTIF );
	conf->setGroup( "Window" );
	cfgbuf = conf->writeEntry( "WinXPos", x() );
	cfgbuf = conf->writeEntry( "WinYPos", y() );
	cfgbuf = conf->writeEntry( "WinWidth", width() );
 	cfgbuf = conf->writeEntry( "WinHeight", height() );
	conf->sync();
}
//---------------------------------------------------------------------
void TKPackViewer::MenuMsg(int which)
{
	switch (which)
	{
		case 101: PrintMsg(M_SLACK); break;
		case 102: PrintMsg(M_RPM  ); break;
		case 103: PrintMsg(M_DEB  ); break;
		case 104: PrintMsg(M_ZIP  ); break;
		case 105: PrintMsg(M_TGZ  ); break;
		case 106: PrintMsg(M_TBZ  ); break;
		case 107: PrintMsg(M_LHA  ); break;
		case 108: PrintMsg(M_GZP  ); break;
		case 109: PrintMsg(M_ALL  ); break;
		case 110: PrintMsg("View last Shell output issued..."	); break;
		case 111: PrintMsg("Exit application"					); break;
		case 112: PrintMsg("Mount Slackware Distribution CDROM "); break;
		case 113: PrintMsg("View RPM installed packs database  "); break;
		case 115: PrintMsg("View DEB available database"        ); break;
		case 114: PrintMsg("Refresh current folder"             ); break;
		case 201: PrintMsg("Change GUI to Windows Style"		); break;
		case 202: PrintMsg("Change GUI Motif Style"				); break;
		case 301: PrintMsg("About the author"					); break;
		case 302: PrintMsg("Help Index"							); break;
		default : PrintMsg("Ready");
	}		
}
//---------------------------------------------------------------------
void TKPackViewer::TabSelected(int tab)
{
	info->hide();
	results->hide();
	packtree->hide();
	listview->hide();
	switch (tab) 
	{ 
		case  0: packtree->show();	break;
		case  1: results->show();	break;
		default: SetInfoView();
	}
}
//---------------------------------------------------------------------
void TKPackViewer::SetInfoView()
{
	if (tabbar->currentTab() != 2) return;
	if (pack_type == trpm || pack_type == tdeb || pack_type == tslack)
	{ 
		if (listview->isVisible()) listview->hide(); 
		info->show(); 
	}
	else 
	{ 
		if (info->isVisible()) info->hide(); 
		listview->show(); 
	} 
}
//---------------------------------------------------------------------
void TKPackViewer::ConvertPack()
{
	if (TrivialErr()) return;
	if (pack_type != trpm && pack_type != tdeb && pack_type != tgz) { Warn("Not a valid pack for conversion."); return; }
	PrintMsg("Select Alien converting options...");
	TKPVExtract *dlg= new TKPVExtract(requested_pack, true);
	int retval = dlg->exec();
	if (retval == QDialog::Accepted)
	{
		xtern_opt = dlg->GetOptions();
		DESTROY(dlg);
		timer->restart();
		SetConvertPath();
		ExternExec(xtern_opt + requested_pack);
	}
	else { DESTROY(dlg); PrintMsg("Ready"); }
}
//---------------------------------------------------------------------
bool TKPackViewer::TrivialErr()
{
	if (packages->count() == 0) return true;
	if (bf_DEBdb) { Warn("Please, refer to associated Debian pack instead..."); return true; }
	if (isRPMdb()) { Warn("Please, refer to associated RPM pack instead..."); return true; }
	if (pack_type == tslack) { Warn("Please, refer to associated TGZ pack instead..."); return true; }
	if (requested_pack == "RPM Groups Structure" || requested_pack == "Debian packages database") { Warn("Please, re-select a valid file first..."); return true; }
	return false;
}
//---------------------------------------------------------------------
void TKPackViewer::SetConvertPath()
{
	amsg = "Converting package " + requested_pack + "..."; PrintMsg(amsg);
	amsg +=  "\nTo: ";
	if (xtern_opt.find("alien -r",0,false) > -1) { amsg += "/usr/src/redhat/RPMS/i386"; }
	else
	{
		QDir Alien_path(user_path + "/Alien");
		if (!Alien_path.exists())
		{ 
			if (!Alien_path.mkdir(user_path + "/Alien")) 
			{
				Warn("Could not create user $HOME Directory to Alien, using root...");
				exec_ok = Alien_path.setCurrent("/");
				amsg +=  "/";
			}
		}
		else
		{
			exec_ok = Alien_path.setCurrent(user_path + "/Alien");
			amsg +=  user_path + "/Alien";
		}
	}
}
//---------------------------------------------------------------------
void TKPackViewer::ExtractTo()
{
	if (TrivialErr()) return; int retval;
	if (isDEBxt())
	{
		PrintMsg("Select install Debian options...");
		TKPVExtractDeb *chodeb= new TKPVExtractDeb();
		retval = chodeb->exec();
		TOption option = chodeb->GetOptions();
		DESTROY(chodeb);
		if (retval == QDialog::Rejected) return;
		if (option != Option_1)
		{
			QString aux("dpkg --install ");
			switch (option)
			{
				case Option_3: aux += "--force-depends ";   break;
				case Option_4: aux += "--force-conflicts "; break;
				default: aux += "--force-depends ";
			}
			aux += requested_pack;
			PrintMsg("Extracting Debian package " + requested_pack + "...");
			timer->restart();
			ExternExec(aux);
			return;
		}
	}
	else if (isRPMxt()) { PrintMsg("Select install RPM options..."); }
	else { PrintMsg("Select extract to directory..."); }
	
	TKPVExtract *dlg= new TKPVExtract(requested_pack);
	retval = dlg->exec();
	if (retval == QDialog::Accepted)
	{
		(isRPMxt()) ? xtern_opt = dlg->GetOptions() : xtern_opt = dlg->GetPath();
		DESTROY(dlg);
		DoExtractPack();
	}
	else DESTROY(dlg);
	PrintMsg("Ready");
}
//---------------------------------------------------------------------
void TKPackViewer::DoExtractPack()
{
	// MODE_ALL needs to detect pack_type based on file extension...
	if (pack_mode_all) pack_type = GetPackType(packages->text(packages->currentItem()));
	
	timer->restart();
	if (pack_type != trpm)
	{
		if (xtern_opt.right(1) != "/") xtern_opt += "/";
		QDir desired_path(xtern_opt);
		if (!desired_path.exists()) { Warn("Can not find path: " + xtern_opt); return; }
		desired_path.setCurrent(xtern_opt);
	}
	QString aux("");	
	amsg = "Extracting ";
	switch (pack_type)
	{
		case trpm: amsg += "RPM "  ; aux = xtern_opt     + requested_pack; break;
		case tgz : amsg += "TGZ "  ; aux = "tar xvfz "   + requested_pack; break;
		case tbz2: amsg += "BZIP2 "; aux = "bzip2 -vdc " + requested_pack + " | tar xv "; break;
		case tzip: amsg += "ZIP "  ; aux = "unzip  "     + requested_pack; break;
		case tlzh: amsg += "LHA "  ; aux = "lha -xv "    + requested_pack; break;
		case tz  : amsg += "GZIP " ; aux = "gunzip -dv " + requested_pack; break;
		case tdeb: amsg += "DEB "  ; aux = "dpkg-deb -X "+ requested_pack + " " + xtern_opt; break;
		default  : return;
	}
	amsg += "package " + requested_pack + "...";
	PrintMsg(amsg);
	ExternExec(aux); 
}
//---------------------------------------------------------------------
void TKPackViewer::ExternExec(QString AQry)
{
	exec_ok = true;
	shell_out = amsg + "\n";;
	KShellProcess *proc = new KShellProcess();	
	(*proc) << AQry;
	connect(proc,SIGNAL(receivedStderr(KProcess*,char*,int)),this,SLOT(ExternOutput(KProcess*,char*,int)));
	connect(proc,SIGNAL(receivedStdout(KProcess*,char*,int)),this,SLOT(ExternOutput(KProcess*,char*,int)));
	connect(proc,SIGNAL(processExited(KProcess*)),this,SLOT(ExternEnd(KProcess*)));
	DESTROY(Shell_Viewer);
	Shell_Viewer = new TInfoWindow("Output Viewer", shell_out, false, false);
	Shell_Viewer->show();
	proc->start(KProcess::NotifyOnExit, KProcess::AllOutput);
}
//---------------------------------------------------------------------
void TKPackViewer::ExternOutput(KProcess*, char *buffer, int buflen)
{
	QString aux(""); aux = buffer; aux = aux.mid(0,buflen);
	shell_out += aux;
	Shell_Viewer->SetText(shell_out);
}
//---------------------------------------------------------------------
void TKPackViewer::ExternEnd(KProcess *proc)
{
	DESTROY(proc);
	shell_out += "\nDone.\n";
	Shell_Viewer->SetText(shell_out);
	cerr << shell_out << "\n";
	PrintElapsed();
	QDir kpv_wd(path_to_packs); exec_ok = kpv_wd.setCurrent(path_to_packs);
}
//---------------------------------------------------------------------
void TKPackViewer::Warn(QString awarn)
{
	KMsgBox::message(this, TITLE, awarn);
}
//---------------------------------------------------------------------
void TKPackViewer::Fatal(QString aerr)
{
	QMessageBox::critical(this, "Fatal Error", aerr);
	KPVApp->quit();
}
//---------------------------------------------------------------------
bool TKPackViewer::MemAvail()
{/* The code expects to find the layout below...

        total:    used:    free:  shared: buffers:  cached:
Mem:  64737280 61042688  3694592 60186624  5324800 20656128
Swap: 123371520    65536 123305984
MemTotal:     63220 kB
MemFree:       3608 kB
MemShared:    58776 kB
Buffers:       5200 kB
Cached:       20172 kB
SwapTotal:   120480 kB
SwapFree:    120416 kB */

    FILE *mef;
    mef = fopen("/proc/meminfo", "r");
	if (mef != NULL ) 
	{
		fgets(membuf, MEMLEN, mef);
		fgets(membuf, MEMLEN, mef);
		fgets(membuf, MEMLEN, mef);
		fgets(membuf, MEMLEN, mef); memdum = membuf;
		MemTot = memdum.mid(memdum.find(":")+1,memdum.length());
		fgets(membuf, MEMLEN, mef); memdum = membuf;
		MemFree = memdum.mid(memdum.find(":")+1,memdum.length());
		fgets(membuf, MEMLEN, mef);
		fgets(membuf, MEMLEN, mef);
		fgets(membuf, MEMLEN, mef);
		fgets(membuf, MEMLEN, mef); memdum = membuf;		
		SwapTot = memdum.mid(memdum.find(":")+1,memdum.length());
		fgets(membuf, MEMLEN, mef); memdum = membuf;
		SwapFree = memdum.mid(memdum.find(":")+1,memdum.length());
		fclose(mef);

		// Strip unwanted chars...
		MemTot   = MemTot.stripWhiteSpace();
		SwapTot  = SwapTot.stripWhiteSpace();
		MemFree  = MemFree.stripWhiteSpace();
		SwapFree = SwapFree.stripWhiteSpace();
		MemTot   = MemTot.mid(0,MemTot.length()-3);
		SwapTot  = SwapTot.mid(0,SwapTot.length()-3);
		MemFree  = MemFree.mid(0,MemFree.length()-3);
		SwapFree = SwapFree.mid(0,SwapFree.length()-3);
		
		// Test again 10% of total available
		unsigned int avail = (MemTot.toUInt() - MemFree.toUInt() ) + (SwapTot.toUInt() - SwapFree.toUInt());
		if (avail > (unsigned int)(0.1)*(MemTot.toUInt() + SwapTot.toUInt())) return true;
		Warn("OOPPS! Not enough memory to complete operation.");
		return false;		
	}
	
	Fatal("Can not check available memory.\nProgram will terminate now.");
	return false;
}
//---------------------------------------------------------------------
void TKPackViewer::SortList()
{
	PrintMsg("Sorting Pack List...");
	if (VERBOSE) { cerr << "Sorting Pack List...\n"; }
	QString AQry("");
	AQry = "sort -o" + user_path + FLE_LOG + "  " + user_path + FLE_LST;
	KShellProcess *proc = new KShellProcess();
	(*proc) << AQry;
	connect(proc,SIGNAL(receivedStderr(KProcess *,char *,int)),this,SLOT(ProcessOutput(KProcess *,char *,int)));
	connect(proc,SIGNAL(receivedStdout(KProcess *,char *,int)),this,SLOT(ProcessOutput(KProcess *,char *,int)));
	connect(proc,SIGNAL(processExited(KProcess *)),this,SLOT(DoneProc(KProcess *)));
	proc->start(KProcess::Block, KProcess::AllOutput);
}
//---------------------------------------------------------------------
void TKPackViewer::DoneProc(KProcess *proc) { DESTROY(proc); }


//==<Code to show the DEB available packs>==============================

void TKPackViewer::MountDEB(QString deb_file)
{
	// Check Debian file...
	f = fopen(deb_file, "r"); if (f == NULL) { Warn("Can not find Debian Status File: /var/lib/dpkg/status !"); return; }

	// Check DebPacks Work Directory...
	QDir deb_packs_path(user_path + "/Deb_Packs"); if (!deb_packs_path.exists()) { if (!deb_packs_path.mkdir(user_path + "/Deb_Packs")) { Warn("Could not create Debian Packs Folder."); fclose(f); return; } }

	// Init operations...
	packtree->setFocus();
	packages->clear(); PrintMsg("Scanning Debian Packages...\n"); if (VERBOSE) { cerr << "*** Scanning Debian Packages...\n"; }
	FILE *df; df = fopen(user_path + FLE_LST, "w"); if (df == NULL) { Warn("Can not create Debian Packs Group List."); fclose(f); return; }

	// Read Debian status file...
	BlockFrame(true); QString aux(""), debpack(user_path + "/Deb_Packs/"); 
	do
	{	if (aux.left(8) != "Package:") { fgets(buf,BUFLEN,f); aux = buf; aux = aux.stripWhiteSpace(); }
		else
		{
			debpack = aux.mid(8,aux.length()); debpack = debpack.stripWhiteSpace(); PrintMsg("Scanning packages...." + debpack);
			nf = fopen(user_path + "/Deb_Packs/" + debpack, "w");
			if (nf != NULL)
			{
				do
				{	fputs(aux + "\n", nf);
					if (aux.left(8) == "Section:") { aux = aux.mid(8, aux.length()) + "/" + debpack; aux = aux.stripWhiteSpace()+ "\n"; fputs(aux, df); }
					fgets(buf,BUFLEN,f); aux = buf; aux = aux.stripWhiteSpace();
					KPVApp->processEvents();
				} while (aux.left(8) != "Package:" && !feof(f));
				fclose(nf); packages->inSort(debpack);
			}
			else Warn("Can not create DEB package list to: " + debpack);
		}
		if (VERBOSE) { cerr << "."; } KPVApp->processEvents();
	} while (!feof(f));
	BlockFrame(false); fclose(f); fclose(df); if (VERBOSE) { cerr << ".\nQuery Debian database DONE!\n"; }
	SortList();	Pack_Parse();
	amsg = "Debian packages database"; requested_pack = amsg; 
	lp->setText(amsg); QToolTip::add(lp,amsg);
	SetModeTo(tdeb, true); readable_pack = user_path + FLE_DIR;
	ReadPack();
	packages->setCurrentItem(0);
}
//---------------------------------------------------------------------
void TKPackViewer::ShowDEBInfo()
{
	QDir debdir(user_path + "/Deb_Packs/");
	if (!debdir.exists()) { if (VERB_ERR) { cerr << "Can not find directory " << DEB_LST << " \n"; return; } }
	if (!debdir.setCurrent(user_path + "/Deb_Packs/")) { if (VERB_ERR) { cerr << "Can not change to directory " << user_path << "/Deb_Packs/ \n"; return; } }
	QFile deb_info(packages->text(packages->currentItem()));
	if (deb_info.open( IO_ReadOnly ))
	{
		info->clear();
		QTextStream tx( &deb_info );
		while (!tx.eof()) info->insertLine( tx.readLine() );
		deb_info.close();
	}
	else { if (VERB_ERR) { cerr << "Can not open file " << packages->text(packages->currentItem()) << " \n"; } }
	exec_ok = debdir.setCurrent(path_to_packs);
}
//---------------------------------------------------------------------
void TKPackViewer::ShowDEBList()
{
	QDir debdir(DEB_LST);
	if (!debdir.exists()) { if (VERB_ERR) { cerr << "Can not find directory " << DEB_LST << " \n"; return; } }
	if (!debdir.setCurrent(DEB_LST)) { if (VERB_ERR) { cerr << "Can not change to directory " << DEB_LST << " \n"; return; } }
	QString aux(packages->text(packages->currentItem())); aux += ".list";
	QFile deb_list(aux);
	if (deb_list.open( IO_ReadOnly ))
	{
		results->clear();
		QTextStream tx( &deb_list );
		while (!tx.eof()) results->insertItem( tx.readLine() );
		deb_list.close();
	}
	else { if (VERB_ERR) { cerr << "Can not open file " << DEB_LST << aux << " \n"; } }
	exec_ok = debdir.setCurrent(path_to_packs);
}

//==<Code to View RPM installed packages database>======================

void TKPackViewer::MountRPM()
{
	QString AQry = "rpm -qa > " + user_path + FLE_RPM;
	KShellProcess *proc = new KShellProcess();	
	(*proc) << AQry;
	connect(proc,SIGNAL(receivedStderr(KProcess *,char *,int)),this,SLOT(ProcessOutput(KProcess *,char *,int)));
	connect(proc,SIGNAL(receivedStdout(KProcess *,char *,int)),this,SLOT(ProcessOutput(KProcess *,char *,int)));
	connect(proc,SIGNAL(processExited(KProcess *)),this,SLOT(DoMountRPM(KProcess *)));
	proc->start(KProcess::Block, KProcess::AllOutput);
}
//---------------------------------------------------------------------
void TKPackViewer::DoMountRPM(KProcess *proc)
{
	DESTROY(proc);
	if (VERB_PLUS) { cerr << "Query RPM database DONE!\n"; }
	amsg = "RPM installed packs";
	lp->setText(amsg);
	QToolTip::add(lp,amsg);
	SetModeTo(trpm, true);
	LoadRPMs();
	readable_pack= " ";
	path_to_packs = " ";
	packages->setFocus();
	packages->setCurrentItem(0);
}
//---------------------------------------------------------------------
void TKPackViewer::LoadRPMs()
{
	FILE *frpm;
	QString aux("");

	packtree->setFocus();	
	packages->clear();
	packages->clearSelection();
	PrintMsg("Loading RPM installed packages....."); 
	if (VERB_PLUS) { cerr << "Loading RPM installed packages...\n"; }
	BlockFrame(true);
	frpm = fopen(user_path + FLE_RPM, "r");
	if (frpm != NULL) 
	{
		do 
		{
			fgets(buf,BUFLEN,frpm); aux = buf;
			aux = aux.stripWhiteSpace();
			if (!feof(frpm)) packages->inSort(aux);
			if (VERB_PLUS) { cerr << "."; }
			KPVApp->processEvents();
		} while (!feof(frpm));
		if (VERB_PLUS) { cerr << "\n"; }
		fclose(frpm);
	}
	BlockFrame(false);
}

//==<Code to make the RPM Programs Group Structure>=====================

void TKPackViewer::ShowRPMGroups()
{
	if (VERBOSE) { cerr << "Building RPM Groups Structure...\n"; }
	PrintMsg("Building RPM Groups Structure...");
	FILE *grpf;
	grpf = fopen(user_path + FLE_LST,"w");
	if (grpf != NULL) { fputs("", grpf); fclose(grpf); }
	else { Warn("Can not create RPM Group File in: " + user_path + FLE_LST); PrintMsg("Ready"); return; }
	if (!isRPMdb() && !ExistRPMs()) { Warn("No RPM files to show groups."); PrintMsg("Ready"); return; }

	SetLedOn();
	ProgDlg->setLabelText("    Scanning RPM Groups...    ");
	ProgDlg->setTotalSteps(packages->count());
	ProgDlg->setProgress(0);
	ProgDlg->show();
	KPVApp->processEvents();
	for(unsigned int i=0; i < packages->count(); i++)
	{
		if (isRPMdb()) { GetRPMGroup(packages->text(i)); }
		else { if (GetPackType(packages->text(i)) == trpm) GetRPMGroup(packages->text(i)); }
		if (VERBOSE) { cerr << "."; }
		ProgDlg->setProgress(i);
		if (ProgDlg->wasCancelled()) goto nomore;
		KPVApp->processEvents();
	}
nomore: if (VERBOSE) { cerr << ".\n"; }
	ProgDlg->setProgress(ProgDlg->totalSteps());
	ProgDlg->reset();
	SetLedOff();
	KPVApp->processEvents();
	if (VERBOSE) { cerr << "RPM Groups Structure DONE!\n"; }
	SortList();
	pack_type = trpm;
	requested_pack = "RPM Groups Structure";
	Pack_Parse();
	PreparePackFile();
	readable_pack = user_path + FLE_PAK;
	ReadPack();
	info->clear();
	listview->clear();
}
//---------------------------------------------------------------------
bool TKPackViewer::ExistRPMs()
{
	for(unsigned int i=0; i < packages->count(); i++)
	{
		if (GetPackType(packages->text(i)) == trpm) return true;
	}
	return false;
}
//---------------------------------------------------------------------
void TKPackViewer::GetRPMGroup(QString arpm)
{
	// Performs a query to get package group...
	QString AQry("rpm");
	(isRPMdb()) ?  AQry += " -q --qf" : AQry += " -qp --qf";
	AQry += " \"%{GROUP}/" + arpm + "\n\" " + path_to_packs + arpm + " >> " + user_path + FLE_LST;
	KShellProcess *proc = new KShellProcess();	
	(*proc) << AQry;
	connect(proc,SIGNAL(receivedStderr(KProcess *,char *,int)),this,SLOT(ProcessOutput(KProcess *,char *,int)));
	connect(proc,SIGNAL(receivedStdout(KProcess *,char *,int)),this,SLOT(ProcessOutput(KProcess *,char *,int)));
	connect(proc,SIGNAL(processExited(KProcess *)),this,SLOT(DoneProc(KProcess *)));
	proc->start(KProcess::Block, KProcess::AllOutput);
}


//==<Code to make the Slackware Virtual Package Directory>==============

void TKPackViewer::MountSlack()
{
	// Checks the Virtual Slackware Distribution Folder...
	// I will not remove - rename to preserve the work in different discs...
	QDir slak_virtual_path(user_path + "/Virtual_Slack");
	if (slak_virtual_path.exists()) { Warn("Your Slackware Virtual Folder is not empty. Remove or rename it before building a new one."); return; }
	else { if (!slak_virtual_path.mkdir(user_path + "/Virtual_Slack")) { Warn("Could not create Virtual Slackware Folder."); return; } }
	virt_slak_path = slak_virtual_path.path();
	if (virt_slak_path.right(1) != "/") virt_slak_path += "/";

	QString cd_path("/");
	PrintMsg("Select Slackware CDROM root folder...");
	cd_path = KDirDialog::getDirectory(cd_path,this);
	if (cd_path.isEmpty()) { PrintMsg("Ready"); return; }
	
	QDir	packs_dir(cd_path + "contents"), scripts_dir(cd_path + "contents/scripts"),
			slak_dir(cd_path + "slakware");
	
	if (!packs_dir.exists() || !scripts_dir.exists() || !slak_dir.exists())
	{ Warn("Could not find required directories on " + cd_path); PrintMsg("Ready"); return; }
	
	// Performs a query to get all package descriptions...
	path_to_packs = cd_path;	// Includes the terminating slash
	QString AQry = "ls -R1 " + cd_path + "slakware/*/disk* > " + user_path + FLE_SLK;
	KShellProcess *proc = new KShellProcess();	
	(*proc) << AQry;
	connect(proc,SIGNAL(receivedStderr(KProcess *,char *,int)),this,SLOT(ProcessOutput(KProcess *,char *,int)));
	connect(proc,SIGNAL(receivedStdout(KProcess *,char *,int)),this,SLOT(ProcessOutput(KProcess *,char *,int)));
	connect(proc,SIGNAL(processExited(KProcess *)),this,SLOT(DoMountSlak(KProcess *)));
	proc->start(KProcess::Block, KProcess::AllOutput);
}
//---------------------------------------------------------------------
void TKPackViewer::DoMountSlak(KProcess *proc)
{
	DESTROY(proc);
	if (VERB_PLUS) { cerr << "Query Slakware desciptions DONE!\n"; }
	GenAllDescs();
	MountSlakPacks();
	SetModeTo(tslack, false);
	SetPathTo(virt_slak_path);
	packages->setFocus();
}
//---------------------------------------------------------------------
void TKPackViewer::GenAllDescs()	// Mount a huge file with all descs
{									// This is dumb - but, as usual - works
	FILE *mf;						// Most of the time is spent "finding" the desc...
	QString aux("");				// Any better idea ???
	
 	f = fopen(user_path + FLE_SLK, "r");
 	nf= fopen(user_path + FLE_DSC, "w");
	if (f != NULL && nf != NULL) 
	{
		PrintMsg("Getting Slackware Descriptions...");
		if (VERBOSE) { cerr << "*** Getting Slackware Descriptions...\n"; }
		do 
		{
			fgets(buf,BUFLEN,f); aux = buf;
			aux = aux.stripWhiteSpace();
			
			mf= fopen(aux, "r");
			if (mf != NULL)
			{
				do 
				{
					fgets(buf,BUFLEN,mf); aux = buf;
					aux = aux.stripWhiteSpace() + "\n";
					if (aux.left(9) != "CONTENTS:") fputs(aux,nf);
					if (VERBOSE) { cerr << "."; }
					KPVApp->processEvents();
				} while (!feof(mf));
				fclose(mf);
			}
			if (VERBOSE) { cerr << "."; }
			KPVApp->processEvents();
		} while (!feof(f));
		if (VERBOSE) { cerr << ".\n"; }
		if (VERBOSE) { cerr << "Slack Descriptions DONE!...\n"; }
		fclose(f);
		fclose(nf);
	}
}
//---------------------------------------------------------------------
void TKPackViewer::MountSlakPacks()
{
	DIR *dir;
	struct dirent *dirent;

	PrintMsg("Mounting Virtual Slackware Distribution in: `" + virt_slak_path + "'....."); 
	if (VERB_PLUS) { cerr << "Mounting Virtual Slackware Distribution in: " << virt_slak_path << "\n"; }
	
	dir = opendir(path_to_packs + "contents");
	if (dir != NULL)
	{
		do 
		{
			dirent = readdir(dir);
			if (dirent != NULL && strcmp(dirent->d_name,".")!= 0 && strcmp(dirent->d_name,"..")!= 0)
			{
				amsg =  dirent->d_name;
				if (amsg.find("TRANS.TBL",0,false) == -1 && amsg != "scripts" && amsg.left(2) != "00")
				{
					// for_every file in "contents" we join the description
					// with the script and the file list...
					PrintMsg("Please wait, this will take a while... Mounting `" + amsg + "'");
					GetVSlackDesc(amsg);
					GetVSlackScript(amsg);
					GetVSlackList(amsg);
				}
			}
			if (VERB_PLUS) { cerr << "."; }
			KPVApp->processEvents();
		} while (dirent != NULL);
		if (VERB_PLUS) { cerr << "\n"; }
		closedir(dir);
	}
}
//---------------------------------------------------------------------
void TKPackViewer::GetVSlackDesc(QString astr)
{
	QString aux("");
	
 	f= fopen(user_path + FLE_DSC, "r");
 	nf= fopen(virt_slak_path + astr, "w");
	if (f != NULL && nf != NULL)
	{
		if (VERBOSE) { cerr << "\nAdding Desc: " << virt_slak_path + astr << "\n"; }
		aux = "VIRTUAL PACKAGE:     " + astr + " \n";
		fputs(aux,nf);
		do 
		{	// OK this_is dumb and slow - but works... looking better ideas...
			// Scan description init...
			fgets(buf,BUFLEN,f); aux = buf;
			aux = aux.stripWhiteSpace();
			if (aux.left(astr.length()+1) == (astr + ":"))
			{   // Found, do_only the necessary...
				while ( (aux.left(astr.length()+1) == (astr+":")) && !feof(f))
				{
					fputs(aux + "\n",nf);
					if (VERBOSE) { cerr << "."; }
					KPVApp->processEvents();
					fgets(buf,BUFLEN,f); aux = buf;
					aux = aux.stripWhiteSpace();
				}
				goto stopit;
			}
			if (VERBOSE) { cerr << "."; }
			KPVApp->processEvents();
		} while (!feof(f));
stopit:	fclose(f);
		fclose(nf);
	}
}
//---------------------------------------------------------------------
void TKPackViewer::GetVSlackScript(QString astr)
{
	QDir scriptdir(path_to_packs + "contents/scripts");
	if (!scriptdir.exists()) return;
	if (!scriptdir.setCurrent(path_to_packs + "contents/scripts")) return;
	QFile slack_script(astr);
	if (slack_script.open( IO_ReadOnly ))
	{
		nf= fopen(virt_slak_path + astr, "a");
		if (nf != NULL)
		{
			if (VERBOSE) { cerr << "\nAdding Script: " << virt_slak_path + astr << "\n"; }
			fputs("          \n",nf);
			fputs("---<Script>--------------------------\n",nf);
			fputs("          \n",nf);
			QTextStream tx( &slack_script );
			QString aux("");
			while (!tx.eof()) { aux = tx.readLine() + "\n"; fputs( aux, nf ); }
			fputs("          \n",nf);
			fclose(nf);
		}
		slack_script.close();
	}
	exec_ok = scriptdir.setCurrent(virt_slak_path);
}
//---------------------------------------------------------------------
void TKPackViewer::GetVSlackList(QString astr)
{
	QString aux("");
	
 	f= fopen(path_to_packs + "contents/" + astr, "r");
 	nf= fopen(virt_slak_path + astr, "a");
	if (f != NULL && nf != NULL)
	{
		if (VERBOSE) { cerr << "\nAdding List: " << virt_slak_path + astr << "\n"; }
		fputs("FILE LIST:\n",nf);
		do
		{
			fgets(buf,BUFLEN,f); aux = buf;
			aux = aux.stripWhiteSpace();
			if (!feof(f)) fputs(aux.mid(48,aux.length()) + "\n",nf);
			if (VERBOSE) { cerr << "."; }
			KPVApp->processEvents();
			
		} while (!feof(f));
		fclose(f);
		fclose(nf);
	}
}

//==<Class TInfoWindow>=================================================

TInfoWindow::TInfoWindow(QString title, QString wintxt, bool inHTML, bool isModal, QWidget *parent, const char *name)
:QDialog(parent, name, isModal )
{
	QPixmap kpvico;
	if (kpvico.load(data_path + "/KPackViewer.xpm")) setIcon(kpvico);

	setCaption(title);
	ahtml = 0; atxt = 0;
	
	if (inHTML)
	{
		ahtml = new KHTMLView(this);
		ahtml->setMinimumSize( 550, 550 );
		ahtml->begin();
		ahtml->write(wintxt);
		ahtml->parse();		
		ahtml->end();
		ahtml->parse();
		resize( 600, 600 );
	}
	else 
	{
		atxt = new TKMultiEd(this);
		atxt->setText(wintxt);
	}

	OK_Button = new QPushButton( this );
	OK_Button->setText( "Dismiss" );
	OK_Button->setFont( QFont( "helvetica", 12, QFont::Normal ) );
	OK_Button->setFixedSize( this->width(), 25 );
	connect( OK_Button, SIGNAL( released() ), this, SLOT( accept() ) );

	WLayout = new QVBoxLayout( this, 5 ); 
	inHTML ? WLayout->addWidget(ahtml) : WLayout->addWidget(atxt);
	WLayout->addWidget(OK_Button);
	WLayout->activate();
	if (!inHTML) Restore();
}
//----------------------------------------------------------------------
void TInfoWindow::Restore()
{
	KConfig *conf = KPVApp->getConfig();

	conf->setGroup( "ShellViewer" );
	WinX = conf->readNumEntry( "WinXPos"  ,   1 );
	WinY = conf->readNumEntry( "WinYPos"  ,   1 );
	WinW = conf->readNumEntry( "WinWidth" , 500 );
	WinH = conf->readNumEntry( "WinHeight", 500 );

	setGeometry(WinX,WinY,WinW,WinH);
}
//---------------------------------------------------------------------
void TInfoWindow::SaveConfig() 
{
	KConfig *conf = KPVApp->getConfig();
	
	conf->setGroup( "ShellViewer" );
	cfgbuf = conf->writeEntry( "WinXPos"  ,      x() );
	cfgbuf = conf->writeEntry( "WinYPos"  ,      y() );
	cfgbuf = conf->writeEntry( "WinWidth" ,  width() );
 	cfgbuf = conf->writeEntry( "WinHeight", height() );
	conf->sync();
}

//==<Class TKPVExtract>=================================================

TKPVExtract::TKPVExtract(QString the_pack, bool wAlien, QWidget* parent, const char* name)
:QDialog(parent, name, true)
{
	isAlien = wAlien;
	
	GroupBox_2 = 0;
	Browse_Button = 0;
	LineEdit_1 = 0; Combo_1 = 0;
	Label_1 = 0; Label_2 = 0; Label_3 = 0;
	CheckBox_1 = 0; CheckBox_2 = 0; CheckBox_3 = 0; CheckBox_4 = 0;
	RadioButton_1 = 0; RadioButton_2 = 0; RadioButton_3 = 0; RadioButton_4 = 0;
	RadioButton_5 = 0; RadioButton_6 = 0;

	OK_Button = new QPushButton( this, "OK" );
	OK_Button->setText( "OK" );

	Cancel_Button = new QPushButton( this, "Cancel" );
	Cancel_Button->setText( "Cancel" );
	Cancel_Button->setAutoDefault( true );

	connect( OK_Button,     SIGNAL( released()  ), this, SLOT( accept() ));
	connect( Cancel_Button, SIGNAL( released()  ), this, SLOT( reject() ));

	GroupBox_1 = new QButtonGroup( this, "GroupBox_1" );
	GroupBox_1->setFrameStyle( 49 );
	GroupBox_1->setAlignment( 1 );

	QString aux(""), aux2("");
	aux  = the_pack.mid(the_pack.findRev("/")+1,the_pack.length());
	aux2 = the_pack.mid(0,the_pack.findRev("/")+1);
	ext  = aux.mid(aux.findRev("."),aux.length()); ext = ext.lower();
	if (isAlien) { BuildAlien(); }	
	else
	{
		aux = "Extracting package:  " + aux;
		(ext == ".rpm") ? BuildRPM() : BuildGeneric( aux, aux2 );
	}
}
//----------------------------------------------------------------------
void TKPVExtract::BuildRPM()
{
	QPixmap kpvico;
	if (kpvico.load(data_path + "/rpmlogo.xpm")) setIcon(kpvico);

	GroupBox_1->setGeometry( 10, 10, 200, 150 );
	GroupBox_1->setTitle( " Options " );

	CheckBox_1 = new QCheckBox( this, "CheckBox_1" );
	CheckBox_1->setGeometry( 20, 30, 170, 30 );
	CheckBox_1->setText( "Verbose" );
	CheckBox_1->setChecked( true );	

	CheckBox_2 = new QCheckBox( this, "CheckBox_2" );
	CheckBox_2->setGeometry( 20, 60, 170, 30 );
	CheckBox_2->setText( "Upgrade" );

	CheckBox_3 = new QCheckBox( this, "CheckBox_3" );
	CheckBox_3->setGeometry( 20, 90, 170, 30 );
	CheckBox_3->setText( "Force Install" );		

	CheckBox_4 = new QCheckBox( this, "CheckBox_4" );
	CheckBox_4->setGeometry( 20, 120, 170, 30 );
	CheckBox_4->setText( "No Dependancy Check" );

	OK_Button->setGeometry( 230, 20, 100, 30 );
	Cancel_Button->setGeometry( 230, 60, 100, 30 );
	
	Label_3 = new QLabel( this, "Label_3" );
	Label_3->setAlignment(AlignCenter);		
	Label_3->setGeometry( 260, 110, 40, 40 );
	QPixmap rpmpix;
	if (rpmpix.load(data_path + "/rpmlogobig.xpm")) Label_3->setPixmap(rpmpix);
		
	resize( 340, 170 );
	setMinimumSize( 340, 170 );
	setMaximumSize( 340, 170 );
	setCaption("Extract RPM pack");
}
//----------------------------------------------------------------------
void TKPVExtract::BuildGeneric(QString pack_name, QString pack_path)
{
	GroupBox_1->setGeometry( 10, 0, 400, 90 );
	GroupBox_1->setTitle( " Extract " );
	// connect( GroupBox_1,    SIGNAL( clicked(int)), this, SLOT( SetXMode() ));

	Label_1 = new QLabel( this, "Label_1" );
	Label_1->setGeometry( 20, 15, 380, 30 );		
	Label_1->setText( pack_name );
	Label_1->setAlignment( 289 );
	Label_1->setMargin( -1 );

	RadioButton_5 = new QRadioButton( GroupBox_1, "RadioButton_1" );
	RadioButton_5->setGeometry( 10, 50, 80, 30 );
	RadioButton_5->setText( "All Files" );
	RadioButton_5->setChecked( true );

	RadioButton_6 = new QRadioButton( GroupBox_1, "RadioButton_2" );
	RadioButton_6->setGeometry( 100, 50, 90, 30 );
	RadioButton_6->setText( "Selected" );
	RadioButton_6->setEnabled( false );
	
	Label_2 = new QLabel( this, "Label_2" );
	Label_2->setGeometry( 190, 50, 40, 30 );
	Label_2->setText( "Files:" );
	Label_2->setAlignment( 289 );
	Label_2->setMargin( -1 );

	LineEdit_1 = new QLineEdit( this, "LineEdit_1" );
	LineEdit_1->setGeometry( 230, 50, 170, 30 );
	LineEdit_1->setText( "*" );
	LineEdit_1->setMaxLength( 32767 );
	LineEdit_1->setEnabled( false );
	LineEdit_1->setEchoMode( QLineEdit::Normal );
	LineEdit_1->setFrame( true );

	GroupBox_2 = new QGroupBox( this, "GroupBox_2" );
	GroupBox_2->setGeometry( 10, 95, 400, 60 );
	GroupBox_2->setFrameStyle( 49 );
	GroupBox_2->setTitle( " Select Directory " );
	GroupBox_2->setAlignment( 1 );

	Combo_1 = new KCombo( true, this, "Combo_1" );
	Combo_1->setGeometry( 20, 115, 300, 30 );
	Combo_1->setInsertionPolicy(QComboBox::AtTop);
	LoadHistory();
	AddToHistory(pack_path);
	connect( Combo_1, SIGNAL(activated(const char*)), this, SLOT( AddToHistory(const char*)));

	Browse_Button = new QPushButton( this, "Browse" );
	Browse_Button->setGeometry( 330, 115, 70, 30 );
	Browse_Button->setText( "Browse" );
	connect( Browse_Button, SIGNAL( released() ), this, SLOT( ChooseDir() ));
	
	OK_Button->setGeometry( 420, 10, 80, 30 );
	Cancel_Button->setGeometry( 420, 50, 80, 30 );

	Label_3 = new QLabel( this, "Label_3" );
	Label_3->setAlignment(AlignCenter);
	Label_3->setGeometry( 435, 90, 50, 50 );
	QPixmap packpix, kpvico;

	if (ext == ".deb")
	{
		if (kpvico.load(data_path + "/debian_logo.xpm")) setIcon(kpvico);
		if (packpix.load(data_path + "/debian_big.xpm")) Label_3->setPixmap(packpix);
	}
	else if (ext == ".tgz")
	{
		if (kpvico.load(data_path + "/slack.xpm")) setIcon(kpvico);
		if (packpix.load(data_path + "/pinguim_big.xpm")) Label_3->setPixmap(packpix);		
	}
	else
	{
		if (kpvico.load(data_path + "/ziplogo.xpm")) setIcon(kpvico);
		if (packpix.load(data_path + "/ziplogobig.xpm")) Label_3->setPixmap(packpix);		
	}

	resize( 510,165 );
	setMinimumSize( 510, 165 );
	setMaximumSize( 510, 165 );
	setCaption("Extract To");
}
//----------------------------------------------------------------------
void TKPVExtract::BuildAlien()
{
	QPixmap kpvico;
	if (kpvico.load(data_path + "/alien.xpm")) setIcon(kpvico);

	GroupBox_1->setGeometry( 10, 10, 200, 150 );
	GroupBox_1->setTitle( " Options " );

	RadioButton_1 = new TDoubleClick_RB( GroupBox_1, "RadioButton_1" );
	RadioButton_1->setGeometry( 20, 20, 170, 30 );
	RadioButton_1->setText( "To Debian" );
	RadioButton_1->setChecked( true );	

	RadioButton_2 = new TDoubleClick_RB( GroupBox_1, "RadioButton_2" );
	RadioButton_2->setGeometry( 20, 50, 170, 30 );
	RadioButton_2->setText( "To RPM" );

	RadioButton_3 = new TDoubleClick_RB( GroupBox_1, "RadioButton_3" );
	RadioButton_3->setGeometry( 20, 80, 170, 30 );
	RadioButton_3->setText( "To Slackware" );

	RadioButton_4 = new TDoubleClick_RB( GroupBox_1, "RadioButton_4" );
	RadioButton_4->setGeometry( 20, 110, 170, 30 );
	RadioButton_4->setText( "Unpack-Don't Convert" );

	OK_Button->setGeometry( 230, 20, 100, 30 );
	Cancel_Button->setGeometry( 230, 60, 100, 30 );
	
	Label_3 = new QLabel( this, "Label_3" );
	Label_3->setAlignment(AlignCenter);		
	Label_3->setGeometry( 260, 105, 40, 50 );
	QPixmap rpmpix;
	if (rpmpix.load(data_path + "/alienbig.xpm")) Label_3->setPixmap(rpmpix);
		
	resize( 340, 170 );
	setMinimumSize( 340, 170 );
	setMaximumSize( 340, 170 );
	setCaption("Convert package with Alien");

	connect( RadioButton_1, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_2, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_3, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_4, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
}
//----------------------------------------------------------------------
void TKPVExtract::LoadHistory()
{
	if (Combo_1 == 0) return;
	QString aux(""), pkey("");
	KConfig *conf = KPVApp->getConfig();
	conf->setGroup( "ExtractHistory" );
	for(int i=0; i < 10; i++)
	{
		aux = conf->readEntry(pkey.setNum(i), "");
		if ( !aux.isNull() && !aux.isEmpty() )
		{
			if (NotInHistory(aux)) Combo_1->insertItem(aux);
		}
	}
}
//---------------------------------------------------------------------
void TKPVExtract::SaveHistory() 
{
	if (Combo_1 == 0) return;
	QString aux(""), pkey("");
	KConfig *conf = KPVApp->getConfig();
	conf->setGroup( "ExtractHistory" );
	for(int i=0; i < Combo_1->count() && i < 10; i++)
	{
		aux = Combo_1->text(i);
		if ( !aux.isNull() && !aux.isEmpty()) conf->writeEntry(pkey.setNum(i), aux);
	}
	conf->sync();
}
//---------------------------------------------------------------------
bool TKPVExtract::NotInHistory(QString anitem)
{
	if (anitem.isEmpty() || anitem.isNull()) return false;
	if (Combo_1->count() == 0) return true;
	
	for(int i=0; i < Combo_1->count()-1; i++)
	{
		if (anitem == Combo_1->text(i)) return false;
	}
	return true;
}

//==<Class TKPVChoSlak>=================================================

TKPVChoSlak::TKPVChoSlak(QWidget* parent, const char* name)
:QDialog(parent, name, true)
{
	QDir slackdir(SLA_PAK); 
	QDir virtual_slak(user_path + "/Virtual_Slack");

	GroupBox_1 = new QButtonGroup( this, "GroupBox_1" );
	GroupBox_1->setGeometry( 10,  5, 200, 145 );
	GroupBox_1->setFrameStyle( 49 );
	GroupBox_1->setTitle( " Options " );
	GroupBox_1->setAlignment( 1 );

	RadioButton_1 = new TDoubleClick_RB( GroupBox_1, "RadioButton_1" );
	RadioButton_1->setGeometry( 20, 18, 160, 30 );
	RadioButton_1->setText( SLA_PAK );
	RadioButton_1->setEnabled(slackdir.exists());
	RadioButton_1->setChecked(slackdir.exists()); 

	RadioButton_2 = new TDoubleClick_RB( GroupBox_1, "RadioButton_2" );
	RadioButton_2->setGeometry( 20, 48, 160, 30 );
	RadioButton_2->setText( "Virtual_Slack" );
	RadioButton_2->setEnabled(virtual_slak.exists());

	RadioButton_3 = new TDoubleClick_RB( GroupBox_1, "RadioButton_3" );
	RadioButton_3->setGeometry( 20, 78, 160, 30 );
	RadioButton_3->setText( "Free Browsing" );

	CheckBox_1 = new QCheckBox(  this, "CheckBox_1" );
	CheckBox_1->setGeometry( 30, 113, 160, 30 );
	CheckBox_1->setText( "Auto Load Directory" );
	CheckBox_1->setChecked( true );
	CheckBox_1->setEnabled(slackdir.exists() || virtual_slak.exists());
	
	PushButton_1 = new QPushButton( this, "PushButton_1" );
	PushButton_1->setGeometry( 225, 10, 100, 30 );
	PushButton_1->setText( "OK" );

	PushButton_2 = new QPushButton( this, "PushButton_2" );
	PushButton_2->setGeometry( 225, 50, 100, 30 );
	PushButton_2->setText( "Cancel" );
	PushButton_2->setAutoDefault( TRUE );

	QPixmap kpvico;
	if (kpvico.load(data_path + "/slack.xpm")) setIcon(kpvico);
	Label_1 = new QLabel( this, "Label_1" );
	Label_1->setAlignment(AlignCenter);		
	Label_1->setGeometry( 260, 95, 40, 50 );
	QPixmap slkpix;
	if (slkpix.load(data_path + "/pinguim_big.xpm")) Label_1->setPixmap(slkpix);

	resize( 340,133 );
	setMinimumSize( 340, 163 );
	setMaximumSize( 340, 163 );
	setCaption("Slackware Initial Folder");

	connect( PushButton_1, SIGNAL( released() ), this, SLOT( accept() ));
	connect( PushButton_2, SIGNAL( released() ), this, SLOT( reject() ));

	connect( RadioButton_1, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_2, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_3, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
}

//==<Class TKPVChoSlak>=================================================

TKPVExtractDeb::TKPVExtractDeb(QWidget* parent, const char* name)
:QDialog(parent, name, true)
{
	OK_Button = new QPushButton( this, "OK" );
	OK_Button->setGeometry( 230, 20, 100, 30 );
	OK_Button->setText( "OK" );

	Cancel_Button = new QPushButton( this, "Cancel" );
	Cancel_Button->setGeometry( 230, 60, 100, 30 );
	Cancel_Button->setText( "Cancel" );
	Cancel_Button->setAutoDefault( true );

	connect( OK_Button,     SIGNAL( released()  ), this, SLOT( accept() ));
	connect( Cancel_Button, SIGNAL( released()  ), this, SLOT( reject() ));

	GroupBox_1 = new QButtonGroup( this, "GroupBox_1" );
	GroupBox_1->setFrameStyle( 49 );
	GroupBox_1->setAlignment( 1 );
	GroupBox_1->setGeometry( 10, 10, 200, 150 );
	GroupBox_1->setTitle( " Options " );

	QPixmap kpvico;
	if (kpvico.load(data_path + "/debian_logo.xpm")) setIcon(kpvico);

	RadioButton_1 = new TDoubleClick_RB( GroupBox_1, "RadioButton_1" );
	RadioButton_1->setGeometry( 20, 20, 170, 30 );
	RadioButton_1->setText( "ExtractTo..." );
	RadioButton_1->setChecked( true );	

	RadioButton_2 = new TDoubleClick_RB( GroupBox_1, "RadioButton_2" );
	RadioButton_2->setGeometry( 20, 50, 170, 30 );
	RadioButton_2->setText( "Install-NoForce" );

	RadioButton_3 = new TDoubleClick_RB( GroupBox_1, "RadioButton_3" );
	RadioButton_3->setGeometry( 20, 80, 170, 30 );
	RadioButton_3->setText( "Install-ForceDepends" );

	RadioButton_4 = new TDoubleClick_RB( GroupBox_1, "RadioButton_4" );
	RadioButton_4->setGeometry( 20, 110, 170, 30 );
	RadioButton_4->setText( "Install-ForceConflicts" );

	connect( RadioButton_1, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_2, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_3, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_4, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	
	Label_1 = new QLabel( this, "Label_3" );
	Label_1->setAlignment(AlignCenter);		
	Label_1->setGeometry( 260, 105, 40, 50 );
	QPixmap debpix;
	if (debpix.load(data_path + "/debian_big.xpm")) Label_1->setPixmap(debpix);
		
	resize( 340, 170 );
	setMinimumSize( 340, 170 );
	setMaximumSize( 340, 170 );
	setCaption("Extract Debian pack");
}

//=====================================================================
//	END.
//=====================================================================
