//////////////////////////////////////////////////////////////         
//      $Id: utils.cpp,v 1.2 1998/12/13 15:44:58 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#include "../config.h"
#include "utils.h"
#include <kmsgbox.h>
#include <kpackage.h>

void KpMsgE( const char *format, const char *str, bool stop)
{
 KpMsg( "Error", format, str,  stop);
}

void KpMsg(const char *lab, const char *format, const char *str, bool stop)
{
  QString qtmp; 
  int flag ;
  char buf[81];

  if (stop)
    flag = KMsgBox::STOP;
  else
    flag = KMsgBox::EXCLAMATION;

  strncpy(buf,str,80);
  buf[80] = 0;
  qtmp.sprintf(format,buf);
  KMsgBox::message(kpkg, lab, qtmp.data(), flag);
}

char *getGroup(char **gs)
{
  char *gsc = strdup(*gs);
  char *p=gsc;
  while(*p && *p != '/')
    {
      p++;
      (*gs)++;
    }
  *p='\0';
  if(**gs)
    (*gs)++;
  return gsc;
}


QListViewItem *findGroup(char *name, QListViewItem *search)
{
  if(!search)
    return NULL;

  do
    {
      if(strcmp(name, search->text(0)) == 0)
	return search;
    } while( (search=search->nextSibling()) != NULL);
  return NULL;
}



