//////////////////////////////////////////////////////////////         
//      $Id: updateLoc.cpp,v 1.2 1998/12/13 15:44:55 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#include "../config.h"

#include "kpackage.h"
#include "updateLoc.h"
#include "pkgInterface.h"
#include "options.h"
#include "cache.h"

extern Params *params;
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
dpanel::dpanel(updateLoc *upd,  char *Pfilter, QWidget *parent,
	       bool buse, const char *name ) 
  : QWidget( parent, name )   
{
  filter = Pfilter;
  puse = 0;

  if (buse && upd->haveBase) {
    base = upd->base;
  } else {
    base = 0;
  }
    
  pack = new QHBoxLayout(this);
  {
    if (buse) {
      puse = new QCheckBox(i18n("Use"),this);
      puse->setFixedSize(puse->sizeHint());
      pack->addWidget(puse,0);
    }

    pent = new QLineEdit(this);
    pent->setFixedHeight(pent->sizeHint().height());
    pack->addWidget(pent,0);

    pbut = new QPushButton("...",this);
    pbut->setFixedWidth(pbut->sizeHint().width());
    pack->addWidget(pbut,0);

    this->setFixedHeight(pent->sizeHint().height());
    if (upd->haveBase && buse)
      connect(pbut, SIGNAL(clicked()), this, SLOT(fileOpen()));
    else
      connect(pbut, SIGNAL(clicked()), this, SLOT(dirOpen()));

  }
}

dpanel::~dpanel()
{
  if (puse)
    delete puse;
  delete pent;
  delete pack;
  delete pbut;
}

QString dpanel::getText()
{
  QString s = pent->text();
  return s;
}

void dpanel::setText(const char *s)
{
 pent->setText(s);
}

bool dpanel::getUse()
{
  if (puse)
    return puse->isChecked();
  else
    return FALSE;
}

void dpanel::setUse(int n)
{
  if (n)
    puse->setChecked(TRUE);
  else
    puse->setChecked(FALSE);
}

KFileDialog* dpanel::getFileDialog(const char* captiontext, bool dir)
{
  QString st;

  if (base && getText() == "") {
    st = base->getText();
  } else {
    st = getText();
  }
  if (!dir) {
    if (st.right(8) == "Packages") {
      st.truncate(st.length() - 8);
    }
  }

  KFileDialog *indexDialog = new KFileDialog(st, filter,
				  this,"indexDialog",TRUE);

  indexDialog->setCaption(captiontext);
  indexDialog->rereadDir();

  return indexDialog;
}

void dpanel::fileOpen()
{
    QString fname;
    KFileDialog *box;

    box = getFileDialog(i18n("Package file"),FALSE);
    
    box->show();
    
    if (!box->result())   /* cancelled */
      return;
    if(box->selectedFile().isEmpty()) {  /* no selection */
      return;
    }
    
    fname =  box->selectedFileURL();
    if (fname.left(5) == "file:") {
      fname.remove(0,5);
    }

    delete box;

    pent->setText(fname.data());
}

void dpanel::dirOpen()
{
    QString fname;
    KFileDialog *box;

    box = getFileDialog(i18n("Package archive"),TRUE);
    
    box->show();
    
    if (!box->result())   /* cancelled */
      return;
    if(box->selectedFile().isEmpty()) {  /* no selection */
      return;
    }
    
    fname =  box->selectedFileURL();
    if (fname.left(5) == "file:") {
      fname.remove(0,5);
    }

    pent->setText(fname.data());
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
updateLoc::updateLoc(QWidget *p, int panelNumber, int numberLines,
		     pkgInterface *inter, const char *msg,
		     char *iname, char *filter, const char *lmsg, const char *bmsg)
    : QDialog(p,"updateLoc",FALSE)
{

  interName = iname;
  interface = inter;
  panNumber = panelNumber;
  if (bmsg)
    haveBase = TRUE;
  else
    haveBase = FALSE;
  if (numberLines > PNUM)
    numLines = PNUM;
  else
    numLines = numberLines;

  QString pn;
  pn.setNum(panNumber);
  pn += "_";

  packL = "Package_L_";
  packL += pn;
  packU = "Package_U_";
  packU += pn;
  availB = "Available_Base";
  availB += pn;

  vtop = new QVBoxLayout( this, 10, 10, "vtop");
  {
    {
      frame1 = new QGroupBox(msg, this, "frame1");
      vtop->addWidget(frame1,1);
      vf = new QVBoxLayout( frame1, 15, 10, "vf");
      {
	hloc = new QHBoxLayout(frame1);

	if (haveBase) {
	  fbase = new QGroupBox(bmsg, frame1);
	  vbase = new QVBoxLayout(fbase, 15, 10, "vbase");
	  vf->addWidget(fbase,1);
	  base = new dpanel(this, filter,  fbase, FALSE);
	  vbase->addWidget(base,0);
	  vbase->activate();
	}
	floc = new QGroupBox(lmsg, frame1);
	vf->addWidget(floc,1);
	vloc = new QVBoxLayout(floc, 15, 10, "vloc");
	for (int i = 0; i < numLines; i++) {
	  dp[i] = new dpanel(this, filter,  floc);
	  vloc->addWidget(dp[i],0);
	}
      }
      vloc->activate();
    }
    vf->activate();
    vtop->activate();
  }
  readSettings();
  resize(wdth,minimumSize().height());
}

updateLoc::~updateLoc()
{
  for (int i = 0; i < numLines; i++) {
    delete dp[i];
  }
}

void updateLoc::restore() 
{
  readSettings();
  show();
}

void updateLoc::applyS(LcacheObj *slist) 
{
  QString t,pn,cn,pv,prev;
  QString nul("");
  cacheObj *CObj;

  KConfig *config = app->getConfig();
  config->setGroup(interName);

  cn = interface->head.data();
  cn += "_";
  cn += pn.setNum(panNumber);
  cn += "_";

  for (int i = 0; i < numLines; i++) {
    // delete chached dir if text changed
    pv = packL + pn.setNum(i); 
    prev = config->readEntry(pv.data(),"");
    if (prev != dp[i]->getText())
      cacheObj::rmDCache(QString(cn + pn.setNum(i)));

    // create cache object corresponding to this entry
    if (dp[i]->getUse()) {
      t = dp[i]->getText();
      if (t != "") {
	if (t.left(5) == "file:") {
	  t.remove(0,5);
	}
	CObj = new cacheObj(haveBase ? base->getText() : (QString)"-",
			    t, cn + pn.setNum(i));
	slist->append(CObj);
	//	printf("T=%s\n",t.data());
      }
    } 
  }
  writeSettings();
}

void updateLoc::readSettings()
{
  QString pv, pn;
  
  KConfig *config = app->getConfig();

  config->setGroup(interName);

  if (haveBase)
    base->setText(config->readEntry(availB));

  for (int i = 0; i < numLines; i++) {
    pv = packL + pn.setNum(i);
    dp[i]->setText(config->readEntry(pv.data(),"").data());
    pv = packU + pn.setNum(i);
    dp[i]->setUse(config->readNumEntry(pv.data()));

  }
  wdth = config->readNumEntry("Width",500);
}

void updateLoc::writeSettings()
{
  QString pv, pn;

  KConfig *config = app->getConfig();

  config->setGroup(interName);
  if (haveBase) {
    config->writeEntry(availB,base->getText());
  }

  for (int i = 0; i < numLines; i++) {
    pv = packL + pn.setNum(i);
    config->writeEntry(pv,dp[i]->getText());
    pv = packU + pn.setNum(i);
    config->writeEntry(pv,(int)dp[i]->getUse());
  }
  config->writeEntry("Width",width());
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
Locations::Locations(int numberDirs, int numberPackages, int numberLines,
		     pkgInterface *inter, const char *msg, char *iname,
		     char *filter, const char *dirMsg,
		     const char *packMsg, const char *baseMsg)
    : QDialog(0,"updateLoc",FALSE)
{
  QString nm, mp;

  numPanels = numberDirs + numberPackages;
  if (numPanels >= PANNUM)
    numPanels =  PANNUM;

  tab = new QTabDialog(0,"Locations");
  tab->setCaption(msg);
  
  for (int i = 0; i <  numberDirs; i++) {
    pn[i] = new updateLoc(tab,i,numberLines,inter, "", iname,
		      filter, dirMsg);
    mp = "D";
    nm.setNum(i+1);
    mp += nm;
    tab->addTab(pn[i],mp.data());
  }

  for (int i = numberDirs; i <  numberPackages + numberDirs; i++) {
    pn[i] = new updateLoc(tab,i,numberLines,inter, "", iname,
		      filter, packMsg, baseMsg);
    mp = "P";
    nm.setNum(i+1-numberDirs);
    mp += nm;
    tab->addTab(pn[i],mp.data());
  }

  tab->setCancelButton( i18n("Cancel") );
  tab->setApplyButton( i18n("Apply") );
  tab->setOkButton( i18n("OK") );

  connect( tab, SIGNAL(applyButtonPressed()), SLOT(apply_slot()) );
}

Locations::~Locations() {
  for (int i = 0; i <  numPanels; i++) {
    delete pn[i];
  }
}

void Locations::restore() 
{
  tab->show();
}

void Locations::apply_slot() 
{
   LcacheObj *slist = new LcacheObj();

  for (int i = 0; i <  numPanels; i++) {
    pn[i]->applyS(slist);
  }
  emit returnVal(slist);
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
