//////////////////////////////////////////////////////////////         
// 	$Id: rpmMessages.cpp,v 1.2 1998/12/13 15:44:48 toivo Exp $	
#include "../config.h"
#ifdef HAVE_RPM
#include <stdarg.h>
#include <stdio.h>

#include "kpackage.h"

extern "C"
{
#include <rpm/rpmlib.h>
#include "rpmMessages.h"
}

static int minLevel = RPMMESS_NORMAL;

void rpmIncreaseVerbosity(void) 
{
  minLevel--;
}

void rpmSetVerbosity(int level) 
{
  minLevel = level;
}

int rpmGetVerbosity(void)
{
  return minLevel;
}

int rpmIsDebug(void)
{
  return (minLevel <= RPMMESS_DEBUG);
}

int rpmIsVerbose(void)
{
  return (minLevel <= RPMMESS_VERBOSE);
}

void rpmMessage(int level, const char * format, ...) 
{
  char buffer[200];
  char f[400];
  va_list args;

  strcpy(f,format);
  // remove newlines from format
  char *p = f;
  while(*p)
    {
      if(*p == '\n')
	*p = ' ';
      p++;
    }


  va_start(args, format);

  if (level >= minLevel) 
    {
      switch (level) 
	{
	case RPMMESS_VERBOSE:
	case RPMMESS_NORMAL:
	  vsprintf(buffer, f, args);
	  break;
	  
	case RPMMESS_DEBUG:
	  vsprintf(buffer, f, args);
	  break;
	  
	case RPMMESS_WARNING:
	  vsprintf(buffer, f, args);
	  //	  printf("%s\n",buffer);
	  break;
	  
	case RPMMESS_ERROR:
	  vsprintf(buffer, f, args);
	  //	  printf("%s\n",buffer);
	  break;
	  
	case RPMMESS_FATALERROR:
	  vsprintf(buffer, f, args);
	  //	  exit(1);
	  break;
	}
      kpkg->kp->setStatus(buffer);
    }
}
#endif
