//////////////////////////////////////////////////////////////         
//      $Id: procbuf.cpp,v 1.2 1998/12/13 15:44:43 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#include "../config.h"
#include "procbuf.h"
#include <kprocess.h>
#include <kmsgbox.h>
#include "kpackage.h"

Modal::Modal( QWidget *parent, const char *name )
  : QDialog( parent, name, TRUE )
{
  QLabel *line1 = new QLabel(i18n("KPACKAGE: Waiting on DPKG"),this);
  line1->setAlignment(AlignCenter);
  line1->setAutoResize(true);

 }

void Modal::terminate()
{
  done(0);
}

procbuf::procbuf()
{
  m = NULL;
}

procbuf::~procbuf()
{
}

void procbuf::setup(char *cmd)
{
  buf.truncate(0);
  proc = new KProcess();
  connect(proc, SIGNAL( receivedStdout(KProcess *, char *, int)), 
			this, SLOT(slotReadInfo(KProcess *, char *, int)));
  connect(proc, SIGNAL( receivedStderr(KProcess *, char *, int)), 
			this, SLOT(slotReadInfo(KProcess *, char *, int)));
  connect(proc, SIGNAL( processExited(KProcess *)), 
			this, SLOT(slotExited(KProcess *)));
  proc->clearArguments();
  proc->setExecutable(cmd);
}

void procbuf::slotReadInfo(KProcess *, char *buffer, int buflen)
{
   char last;

   last = buffer[buflen - 1];
   buffer[buflen - 1] = 0;
   buf += buffer;
   buf += last;
}

void procbuf::slotExited(KProcess *)
{
  delete proc;
  if (m)
    m->terminate();
}

int procbuf::start (int nb)
{

  if (!proc->start(nb ? KProcess::NotifyOnExit : KProcess::Block ,KProcess::AllOutput)) {
    KpMsgE(
	  i18n("Kprocess Failure"),"",TRUE);
    return 0;
  };

  if (nb) {
    m = new Modal(kpkg,i18n("Wait"));
    m->exec();
    delete m;
    m = NULL;
  }

  //  if (proc->exitStatus()) {
  //    KpMsg("Error","Kprocess error:%s",
  //	  buf.length() ? buf.data() : "Cann't start kvt",
  //	  TRUE);
  //    return 0;
  //  }

  return 1;
}











