//////////////////////////////////////////////////////////////
//      $Id: pkgInterface.h,v 1.4 1998/12/13 15:44:37 toivo Exp $ 
//
// Author: Toivo Pedaste
//

#ifndef PKG_IFACE_H
#define PKG_IFACE_H

#include "../config.h"
#include <qlist.h>
#include <qstring.h>

#include <kiconloader.h> 
#include <kdir.h>

#include "packageInfo.h"

class packageInfo;
class installationWidget;
class  pkginstallDialogMult;
class pkguninstallDialog;
class pkguninstallDialogMult;
class Locations;
class LcacheObj;
class cacheObj;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
typedef struct param {
  const char *name;
  bool init;
  bool invert;
} param;
// Structure for flags to install and uninstall
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class pkgInterface: public QObject 
{
  Q_OBJECT
 
public:
  pkgInterface();
  virtual ~pkgInterface();
  
  virtual bool isType(char *buf);
  // looks at start of file to check that package is correct type

  virtual void listPackages(QList<packageInfo> *pki);
  // list the packages (installed and/or uninstalled)

  virtual param *initinstallOptions();
  virtual param *inituninstallOptions();
  // return appropriate param blocks

  virtual packageInfo *getPackageInfo(char mode, const char *name);
  // get info on installed or uninstalled package

  virtual QList<char> *getFileList(packageInfo *p);
  // get list of files in the package

  virtual QList<char> *depends(const char *name, int src);
  // check dependencies for package

  virtual QList<char> *verify(packageInfo *p, QList<char> *files);
  // check the installed files in a package

  virtual int uninstall(int uninstallFlags, QList<packageInfo> *p);
  virtual int uninstall(int uninstallFlags, packageInfo *p);
  // uninstall package or packages

  virtual int install(int installFlags, QList<packageInfo> *p);
  virtual int install(int installFlags, packageInfo *p);
  // install package or packages

  virtual QString FindFile(const char *name);
  // search for packages containg a file

  virtual bool parseName(QString name, QString *n, QString *v);
  // breakup file name into package name and version

  void listDir(QList<packageInfo> *pki, QString fname, QString dir);
  // list the packages in a directory

  QString getDir(cacheObj *cp);
  // list directory local or remote

  void filesDir(KFileInfoList *lst);
  // process the directory entries
  
  packageInfo *collectDir(QString name, QString size, QString dir);
  // build packageInfo object from directory entry

  ///////////// DATA ///////////////////////
  installationWidget *installation;
  pkginstallDialogMult *installationMult;
  pkguninstallDialog *uninstallation;
  pkguninstallDialogMult *uninstallationMult;
  // install and uninstall widgets for this package type

  QString icon;
  // name icon file
  QString head;
  // capitalized name of package type
  QPixmap *pict, *bad_pict, *new_pict, *updated_pict;
  // icons for package states
  QPixmap *folder;
  // icon for package group

  Locations *locatedialog;
  // dialog for setting the locations of  uninstalled packages
  LcacheObj *packageLoc;
  // List of locations of uninstalled pacckages
  
  FILE *tmpFile;
  QString tmpDir;
  KDir *kdir;
  bool dirOK;
  // variables related to reading packages from directories

  char *packagePattern;
  QString queryMsg;
  char  *typeID;
  // Parameters for reading packages from directories

public slots:
  virtual void setLocation();
  virtual void setAvail(LcacheObj *);
  void fileDir(KFileInfo *);
  void finishedDir();
  void errorDir(int, const char *);
};

extern KIconLoader  *globalKIL;
#endif





