//////////////////////////////////////////////////////////////         
//      $Id: pkgInterface.cpp,v 1.4 1998/12/13 15:44:36 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#include "kpackage.h"
#include "pkgInterface.h"
#include "options.h"
#include "cache.h"
#include "updateLoc.h"

extern Params *params;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
pkgInterface::pkgInterface() : QObject() 
{
  packageLoc = 0;
  bad_pict = 0;
  new_pict = 0;
  updated_pict = 0;
  kdir = NULL;
  tmpFile = 0;
  packageLoc = 0;

  folder = new QPixmap();
  *folder = globalKIL->loadIcon("mini/folder.xpm");
}

//////////////////////////////////////////////////////////////////////////////
pkgInterface::~pkgInterface()
{
  delete locatedialog;
  if (packageLoc)
    delete packageLoc;
  delete pict;
  if (bad_pict)
    delete bad_pict;
  if (updated_pict)
    delete updated_pict;
  if (new_pict)
    delete new_pict;
}

////////////////////////////////////////////////////////////////////////////
bool pkgInterface::isType(char *buf){return 0;}
void pkgInterface::listPackages(QList<packageInfo> *pki){}
param *pkgInterface::initinstallOptions(){return 0;}
param *pkgInterface::inituninstallOptions(){return 0;}
packageInfo *pkgInterface::getPackageInfo(char mode, const char *name){return 0;}
QList<char> *pkgInterface::getFileList(packageInfo *p){return 0;}
QList<char> *pkgInterface::depends(const char *name, int src){return 0;}
QList<char> *pkgInterface::verify(packageInfo *p, QList<char> *files){return 0;}

int pkgInterface::uninstall(int uninstallFlags, QList<packageInfo> *p){return 0;}
int pkgInterface::uninstall(int uninstallFlags, packageInfo *p){return 0;}

int pkgInterface::install(int installFlags, QList<packageInfo> *p){return 0;}
int pkgInterface::install(int installFlags, packageInfo *p){return 0;}

QString pkgInterface::FindFile(const char *name){return 0;}

void pkgInterface::setLocation(){}
void pkgInterface::setAvail(LcacheObj *slist) {}
  
bool pkgInterface::parseName(QString name, QString *n, QString *v) {return 0;}

////////////////////////////////////////////////////////////////////////////
void pkgInterface::listDir(QList<packageInfo> *pki, QString fname, QString dir) 
{
  QString name, size, rfile;
  packageInfo *p;

  QString sline = queryMsg.data();
  sline += fname;
  kpkg->kp->setStatus(sline.data());

  QDir d(fname.data(),packagePattern);
  if (d.exists()) {
    QString pn;
    const QFileInfoList *list = d.entryInfoList();
    QFileInfoListIterator it( *list );      // create list iterator
    QFileInfo *fi;                          // pointer for traversing

    while ( (fi=it.current()) ) {           // for each file...
      if (params->PkgRead) {
	rfile = dir + "/";
	rfile += fi->fileName();
	p = getPackageInfo('u',rfile.data());
	if (p) {
	  p->info->insert("filename", new QString(fi->fileName()));
	  p->info->insert("base", new QString(dir));
 	}
      } else {
	p = collectDir(fi->fileName(),pn.setNum(fi->size()).data(),dir);
      }
      if (p) {
	if (!p->update(pki, typeID, FALSE))
	  delete p;
      }
      ++it;                               // goto next list element
    }
  } else {
    FILE *f = fopen(fname.data(),"r");
    char buf[201];
    if (f) {
      while (fgets(buf,200,f)) {
	name = buf;
	name.truncate(name.length() - 1);
	if (fgets(buf,200,f)) {
	  size = buf;
	  size.truncate(size.length() - 1);
	} else
	  size = "";
	packageInfo *p = collectDir(name,size,dir);
	if (p) {
	  if (!p->update(pki, typeID, FALSE))
	    delete p;
	}
      }
      fclose(f);
    }
  }
}

packageInfo *pkgInterface::collectDir(QString name, QString size, QString dir) 
{
  QString n,v;

  if (parseName(name, &n, &v)) {
    QDict<QString> *a = new QDict<QString>;
    a->setAutoDelete(TRUE);

    a->insert("group", new QString("NEW"));
    a->insert("name", new QString(n));
    a->insert("version", new QString(v));
    a->insert("file-size", new QString(size));
    a->insert("filename", new QString(name));
    a->insert("base", new QString(dir));

    packageInfo *i = new packageInfo(a,this);
    i->packageState = packageInfo::AVAILABLE;
    //    i->packageState = packageInfo::NEW;
    return i;
    } 
  return 0;
}

QString pkgInterface::getDir(cacheObj *cp) {
  QString string = "";
  int res;

  QString url = cp->location;

  if ((res = cacheObj::newDCache(url, cp->cacheFile, &tmpDir))) {
    if (res < 0)
      return string;

    if (!kdir) {
      kdir = new KDir();
      connect(kdir,SIGNAL(dirEntry(KFileInfo *)),
	      SLOT(fileDir(KFileInfo *)));
      connect(kdir,SIGNAL(finished()),SLOT(finishedDir()));
      connect(kdir,SIGNAL(error(int, const char *)),
	      SLOT(errorDir(int, const char *)));
    }

    //    printf("getPackage=%s\n",url.data());

    unlink(tmpDir.data());
    tmpFile = fopen(tmpDir.data(),"w");
    if (!tmpFile) {
      KpMsgE(i18n("Cann't write to file %s\n"),
	     tmpDir.data(),FALSE);
      return string;
    }
    kdir->setURL(url);

    dirOK = TRUE;
    const KFileInfoList *lst = kdir->entryInfoList();
    filesDir((KFileInfoList *)lst);

    //    printf("enter_loop\n");
    app->enter_loop(); 
    if (dirOK)
      return tmpDir;
    else {
      delete kdir;
      kdir = 0;
      KpMsgE(i18n("Cann't read directory %s"),url.data(),FALSE);
      unlink(tmpDir.data());
      return string;
    }
  } else {
    return tmpDir;
  }
}

void pkgInterface::finishedDir()
{
  if (tmpFile) {
    //    printf("exit_loop\n");
    app->exit_loop();
    fclose(tmpFile);
    dirOK = TRUE;
  }
}

void pkgInterface::errorDir(int n, const char *err)
{
  if (tmpFile) {
    printf("E=%d %s\n",n,err);
    //    printf("exit_loop\n");
    app->exit_loop();
    fclose(tmpFile);
    dirOK = FALSE;
  }
}

void pkgInterface::filesDir(KFileInfoList *lst)
{
  KFileInfo *inf;

  for (inf = lst->first(); inf != 0; inf = lst->next()) {
    fileDir(inf);
  }	
}

void pkgInterface::fileDir(KFileInfo *inf)
{
  if (KDir::match(packagePattern,inf->fileName())) {
    fprintf(tmpFile,"%s\n%d\n",inf->fileName(),inf->size());
  }
}
