/////////////////////////////////////////////////////////////////////////////
//      $Id: packageProperties.h,v 1.2 1998/12/13 15:44:34 toivo Exp $ 
// File  : packageProperties.h
// Author: Damyan Pepper
// Author: Toivo Pedaste
//
// This widget is used to provide a list of all the properties that are
// found in the package's property dictionary
//
/////////////////////////////////////////////////////////////////////////////

#ifndef PACKAGEPROPERTIES_H
#define PACKAGEPROPERTIES_H
#include "../config.h"

// Standard Headers

// Qt Headers
#include <qtablevw.h>
#include <qpainter.h>

// KDE Headers

// kpackage Headers
#include "packageInfo.h"

class packageInfo;

class packagePropertiesWidget : public QTableView
{
  Q_OBJECT;
  ///////////// METHODS ------------------------------------------------------
public:

  packagePropertiesWidget(QWidget *parent=0, const char *name=0);
  // constructor

  ~packagePropertiesWidget();
  // destructor

  void changePackage(packageInfo *p);

protected:

  int cellHeight( int row);
  int cellWidth(int col);

  void paintCell(QPainter *p, int row, int col);

  ///////////// SLOTS --------------------------------------------------------

  ///////////// SIGNALS ------------------------------------------------------

  ///////////// DATA ---------------------------------------------------------
private:
  packageInfo *package;
 
  void initTranslate();
  void iList(char *txt, const char *itxt);

  QDict<char> *tr;
  // allow for translation of labels

  QStrList *pList;
  // list specifying order of property distplay

  QStrList *cList;
  // list giving order of currently displayed properties


};


#endif
