//////////////////////////////////////////////////////////////         
//      $Id: options.cpp,v 1.2 1998/12/13 15:44:26 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#include "../config.h"

#include "kpackage.h"
#include "managementWidget.h"
#include "pkgInterface.h"
#include "options.h"
#include "cache.h"

extern Params *params;
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
Options::Options(QWidget *parent, const char *name)
    : QDialog(parent, name,FALSE){

    readSettings();
    if (DCache >= Params::SESSION) {
      cacheObj::clearDCache(); // clear dir caches if needed
    }
    if (PCache >= Params::SESSION) {
      cacheObj::clearPCache(); // clear package caches if needed
    }

    tab = new QTabDialog(0,"Options");
    tab->setCaption("Options");

    {
      bg = new QButtonGroup(tab);
      bg->setTitle(i18n("Packages to display"));
      connect( bg, SIGNAL(clicked(int)), SLOT(PDisplay(int)) );
      QVBoxLayout* vb = new QVBoxLayout( bg, 15, 10, "vb");
      vb->addSpacing( bg->fontMetrics().height() );

      disp[0] = new QRadioButton(i18n("Installed Packages"),bg);
      vb->addWidget(disp[0]);
      disp[0]->setMinimumSize( disp[0]->sizeHint() );

      disp[1] = new QRadioButton(i18n("Updated Packages"),bg);
      vb->addWidget(disp[1]);
      disp[1]->setMinimumSize( disp[1]->sizeHint() );

      disp[2] = new QRadioButton(i18n("New and Updated  Packages"),bg);
      vb->addWidget(disp[2]);
      disp[2]->setMinimumSize( disp[2]->sizeHint() );

      disp[3] = new QRadioButton(i18n("All Packages"),bg);
      vb->addWidget(disp[3]);
      disp[3]->setMinimumSize( disp[3]->sizeHint() );

      disp[displayP]->setChecked(TRUE);
      bg->setMinimumSize( bg->childrenRect().size() );
      vb->activate();
    }
    tab->addTab(bg,i18n("Package Display"));

    {
      bc = new QButtonGroup(tab);
      bc->setTitle(i18n("Cache remote package directories"));
      connect( bc, SIGNAL(clicked(int)), SLOT(PDCache(int)) );

      QVBoxLayout* vc = new QVBoxLayout( bc, 15, 10, "vc");
      vc->addSpacing( bc->fontMetrics().height() );

      dcache[0] = new QRadioButton(i18n("Always"),bc);
      vc->addWidget(dcache[0]);
      dcache[0]->setMinimumSize( dcache[0]->sizeHint() );

      dcache[1] = new QRadioButton(i18n("During as session"),bc);
      vc->addWidget(dcache[1]);
      dcache[1]->setMinimumSize( dcache[1]->sizeHint() );

      dcache[2] = new QRadioButton(i18n("Never"),bc);
      vc->addWidget(dcache[2]);
      dcache[2]->setMinimumSize( dcache[2]->sizeHint() );

      if (DCache > 2)
	DCache = 2;
      dcache[DCache]->setChecked(TRUE);
      bc->setMinimumSize( bc->childrenRect().size() );
      vc->activate();
    }
    tab->addTab(bc,i18n("Directory Cache"));

    {
      bp = new QButtonGroup(tab);
      bp->setTitle(i18n("Cache remote package files"));
      connect( bp, SIGNAL(clicked(int)), SLOT(PPCache(int)) );

      QVBoxLayout* vp = new QVBoxLayout( bp, 15, 10, "vp");
      vp->addSpacing( bp->fontMetrics().height() );

      pcache[0] = new QRadioButton(i18n("Always"),bp);
      vp->addWidget(pcache[0]);
      pcache[0]->setMinimumSize( pcache[0]->sizeHint() );

      pcache[1] = new QRadioButton(i18n("During as session"),bp);
      vp->addWidget(pcache[1]);
      pcache[1]->setMinimumSize( pcache[1]->sizeHint() );

      pcache[2] = new QRadioButton(i18n("Never"),bp);
      vp->addWidget(pcache[2]);
      pcache[2]->setMinimumSize( pcache[2]->sizeHint() );

      if (PCache > 2)
	PCache = 2;
      pcache[PCache]->setChecked(TRUE);
      bp->setMinimumSize( bp->childrenRect().size() );
      vp->activate();
    }
    tab->addTab(bp,i18n("Package Cache"));

    {
      framem = new QGroupBox("", tab);
      QVBoxLayout* vf = new QVBoxLayout(framem,20,20);
      valid = new QCheckBox(i18n("Verify file list"), framem, "valid");
      vf->addWidget(valid,0,AlignLeft);
      valid->setFixedSize(valid->sizeHint());
      valid->setChecked(verifyFL);
      pkgRead = new QCheckBox(i18n("Read information from all local package files"), framem, "pkgr");
      vf->addWidget(pkgRead,0,AlignLeft);
      pkgRead->setFixedSize(pkgRead->sizeHint());
      pkgRead->setChecked(PkgRead);
    }
    tab->addTab(framem,i18n("misc"));

    tab->setCancelButton( i18n("Cancel") );
    tab->setApplyButton( i18n("Apply") );
    tab->setOkButton( i18n("OK") );
    tab->resize(minimumSize());

    connect( tab, SIGNAL(applyButtonPressed()), SLOT(apply_slot()) );
}

Options::~Options()
{
}

void Options::restore() 
{
  readSettings();
  tab->show();
}

void Options::apply_slot() 
{
  params->VerifyFL = valid->isChecked();
  params->PkgRead = pkgRead->isChecked();

  params->DisplayP = dp;
  if (dp != displayP)
    kpkg->kp->reload();
  displayP =dp;

  params->DCache = dc;
  params->PCache = pc;

  writeSettings();
}

void Options::PDisplay(int r)
{
  dp = r;
}

void Options::PDCache(int r)
{
  dc = r;
}

void Options::PPCache(int r)
{
  pc = r;
}

void Options::readSettings()
{
  
  KConfig *config = app->getConfig();

  config->setGroup("Kpackage");

  displayP = config->readNumEntry("Package_Display",3);
  params->DisplayP = displayP;
  dp = displayP;

  DCache = config->readNumEntry("Dir_Cache",1);
  params->DCache = DCache;
  dc = DCache;

  PCache = config->readNumEntry("Package_Cache",0);
  params->PCache = PCache;
  pc = PCache;

  verifyFL = config->readNumEntry("Verify_File_List",1);
  params->VerifyFL = verifyFL;

  PkgRead = config->readNumEntry("Read_Package_files",0);
  params->PkgRead = PkgRead;

}

void Options::writeSettings()
{
  
  KConfig *config = app->getConfig();

  config->setGroup("Kpackage");

  config->writeEntry("Package_Display", dp);
  config->writeEntry("Dir_Cache", dc);
  config->writeEntry("Package_Cache", pc);
  config->writeEntry("Verify_File_List", valid->isChecked());

  config->writeEntry("Read_Package_files", pkgRead->isChecked());
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

Params::Params()
{
}

Params::~Params()
{
}
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
