//////////////////////////////////////////////////////////////         
//      $Id: findf.cpp,v 1.2 1998/12/13 15:44:13 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#include "../config.h"

#include "kpackage.h"
#include "pkgInterface.h"
#include "managementWidget.h"
#include "pkgInterface.h"
#include "findf.h"

extern pkgInterface *kpinterface[];

FindF::FindF(QWidget *parent, const char *name)
    : QDialog(parent, name,FALSE){

    this->setFocusPolicy(QWidget::StrongFocus);

    QVBoxLayout* vtop = new QVBoxLayout( this, 20, 10, "vtop");

    frame1 = new QGroupBox(i18n("Find File"), this, "frame1");
    vtop->addWidget(frame1,4);
    QVBoxLayout* vf = new QVBoxLayout( frame1, 12, 10, "vf");

    value = new QLineEdit( frame1, "value");
    vf->addWidget(value,1);
    value->setFocus();
    value->setFixedHeight(value->sizeHint().height());
    connect(value, SIGNAL(returnPressed()), this, SLOT(ok_slot()));

    tab = new KTabListBox(frame1,"tab",3);
    connect(tab, SIGNAL(highlighted(int, int )), this, SLOT(search(int, int )));
    tab->setSeparator('\t');
    tab->setColumn(0,i18n("Type"),40);
    tab->setColumn(1,i18n("Package"),120);
    tab->setColumn(2,i18n("File Name"),300);
    vf->addWidget(tab,4);

    QHBoxLayout* hb = new QHBoxLayout( );
    vtop->addLayout(hb,0);

    ok = new QPushButton(i18n("Find"), this, "find");
    hb->addWidget(ok,1,AlignLeft);
    ok->setFixedSize(ok->sizeHint());
    connect(ok, SIGNAL(clicked()), this, SLOT(ok_slot()));
    
    hb->addStretch();

    cancel = new QPushButton(i18n("Done"), this, "cancel");
    hb->addWidget(cancel,1,AlignRight);
    cancel->setFixedSize(cancel->sizeHint());
    connect(cancel, SIGNAL(clicked()), this, SLOT(done_slot()));
 
    vtop->activate();
    setMinimumSize(minimumSize());
    setMaximumHeight(height());
    show();

    setupDropzone();
}

FindF::~FindF()
{
}

// Set up the drop zone
void FindF::setupDropzone()
{
  dropzone = new KDNDDropZone(this, DndURL);
  connect(dropzone,SIGNAL(dropAction(KDNDDropZone*)),
	  SLOT(dropAction(KDNDDropZone*)));
}

void FindF::ok_slot() 
{
  doFind(this->value->text());
}

void FindF::doFind(const char *str) 
{
  QString s, tmp;
  QString t;
  int i, cnt = 0;;

  tab->clear();

  for (i = 0; i < kpinterfaceN; i++) {
    s = kpinterface[i]->FindFile(str);

    if (s.length() > 0) {
      cnt++;
      int p = 0, pp = 0;
      while ((p = s.find('\n',p)) >= 0) {
	t = kpinterface[i]->head.data();
	tmp = s.mid(pp,p - pp);
	if (tmp.find("diversion by") < 0) {
	  t += "\t" + tmp;
	  tab->insertItem(t.data());
	}
	p++;
	pp = p;
      }
    }
  }

  if (!cnt) {
    tab->insertItem(" \t \t ");
    tab->changeItemPart(i18n("--Nothing found--"),0,2);
  }
}

void FindF::done_slot()
{
  this->hide();
}

void FindF::resizeEvent(QResizeEvent *){
}

void FindF::search(int index, int column)
{
  int p;
  QString s = tab->text(index,1).data();
    

  p = s.find(',');
  if (p > 0) {
    s.truncate(p);
  }
  kpkg->kp->management->search(s.data(),tab->text(index,0).data());
}

void FindF::dropAction(KDNDDropZone *dz) // something has been dropped
{
  char *s;
  QStrList &list = dz->getURLList();
  QString url;

  s = list.first();
  KURL *u = new KURL( s );

  if (!u->isMalformed() && (strcmp( u->protocol(), "file" ) == 0 )) {
    url = u->path();
    if (url.right(1) == "/")
      url.truncate(url.length()-1);
    value->setText(url.data());
    doFind(url.data());
  } else {
    KpMsgE(i18n("Incorrect URL type"),"",FALSE);
  }
}
