//////////////////////////////////////////////////////////////
//      $Id: debInterface.h,v 1.3 1998/12/13 15:44:12 toivo Exp $ 
//
// Author: Toivo Pedaste
//
//////////////////////////////////////////////////////////////

#ifndef DEB_IFACE_H
#define DEB_IFACE_H

#include "../config.h"

#include <qlist.h>
#include <kprocess.h>
#include <kfm.h>

#include "pkgInterface.h"

class packageInfo;
class updateLoc;
class cacheObj;

class DEB: public pkgInterface
{
  Q_OBJECT

public:
  DEB();
  ~DEB();
  
  bool isType(char *buf);
  void listPackages(QList<packageInfo> *pki);
  param *initinstallOptions();
  param *inituninstallOptions();
  packageInfo *getPackageInfo(char mode, const char *name);
  QList<char> *getFileList(packageInfo *p);
  QList<char> *depends(const char *name, int src);
  QList<char> *verify(packageInfo *p, QList<char> *files);

  int uninstall(int uninstallFlags, QList<packageInfo> *p);
  int uninstall(int uninstallFlags, packageInfo *p);

  int install(int installFlags, QList<packageInfo> *p);
  int install(int installFlags, packageInfo *p);

  QString FindFile(const char *name);
  bool parseName(QString name, QString *n, QString *v);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);
  void slotKFMFinished();
  void slotKFMError(int , const char*);

private:
  QDict<int> *enames;

  packageInfo* collectInfo(char *inp);
  QString getPackList(cacheObj *cp);
  void listPackList(QList<packageInfo> *pki, char *fname, cacheObj *cp);
  int dpkgChange(int del);

  int DEB::doUninstall(int installFlags, QString packs);
  int DEB::doInstall(int installFlags, QString packs);

  QString fetchCache;
  // cache file for Packages file being fetched
  KFM * kfm;
  // object for net fetchin

};

#endif



