/////////////////////////////////////////////////////////////////////////////////
// $Id: aboutDialog.cpp,v 1.3 1998/12/15 14:21:02 toivo Exp $	
// File  : aboutDialog.cpp
// Author: Damyan Pepper
// Author: Toivo Pedaste
//
// This is the implementation of about dialog.  See aboutDialog.h for more
// information
////////////////////////////////////////////////////////////////////////////////

#include "../config.h"
// Qt headers
#include <qlabel.h>
#include <qlayout.h>

// ksetup headers
#include "aboutDialog.h"
//#include "aboutDialog.moc"


// Constructor
aboutDialog::aboutDialog(QWidget *parent, const char *name)
  : QDialog(parent,name,TRUE)
{
  // Make the dialog a nice size
  resize(250,250);

  // Create the Ok button
  okButton = new QPushButton("OK", this);

  // Create the labels
  QLabel *line1 = new QLabel("kpackage",this);
  QLabel *line2 = new QLabel("Version 1.1.1",this);
  QLabel *line3 = new QLabel("By Toivo Pedaste",this);
  QLabel *line3a = new QLabel("Originally: Damyan Pepper",this);

  // Setup the labels
  line1->setAlignment(AlignCenter);
  line1->setFont(QFont("Helvetica",18, QFont::Bold));
  line1->setAutoResize(TRUE);

  line2->setAlignment(AlignCenter);
  line3->setAlignment(AlignCenter);
  line3a->setAlignment(AlignCenter);

  // Create the layout manager
  QBoxLayout *layout = new QBoxLayout(this,QBoxLayout::TopToBottom);

  layout->addStretch(1);
  layout->addWidget(line1, 1);
  layout->addWidget(line2, 1);
  layout->addWidget(line3, 1);
  layout->addWidget(line3a,1);
  layout->addStretch(2);
  layout->addWidget(okButton, 1);
  layout->activate();

  // Connect the ok button
  connect(okButton,SIGNAL(clicked()), SLOT(okClicked()));
}

// Destructor -- does nothing for now
aboutDialog::~aboutDialog()
{
}

// The ok button has been clicked
void aboutDialog::okClicked()
{
  // Exit the dialog
  accept();
}

