#include <stdlib.h>
#include <stdio.h>
#include "wv_extract.h"
#include "newexe.h"
#include "resfmt.h"

int main(int argc,char **argv)
	{
	FILE *fd,*out,*in;
	DialogBoxHeader dlg;
	ControlData *ctl=NULL;
	int c;
	U16 i;

	if (argc != 2)
		{
		printf("Usage dlgtogtk filename.dlg\n");
		return(1);
		}
	fd = fopen(argv[1],"rb");
	if (fd == NULL)
		{
		printf("Couldn't open %s\n",argv[1]);
		return(1);
		}
	wvGetDialogBoxHeader(&dlg,fd);
	ctl = (ControlData *)malloc(sizeof(ControlData)*dlg.NumberOfItems);
	for(i=0;i<dlg.NumberOfItems;i++)
		wvGetControlData(&ctl[i],fd);

	printf("dialog box %d by %d\n",dlg.cx,dlg.cy);
	for(i=0;i<dlg.NumberOfItems;i++)
		printf("control at %d %d, %d by %d\n",ctl[i].x,ctl[i].y,ctl[i].cx,ctl[i].cy);

	out = fopen("dialog.c","wb");
	if (out == NULL)
		{
		printf("Couldn't open %s\n","dialog.gtk");
		return(1);
		}

	in = fopen("gtksection1","rb");
	while (EOF != (c = getc(in)))
		fputc(c,out);
	fclose(in);

	wvDialogBoxHeaderGtk(&dlg,out);

	in = fopen("gtksection2","rb");
	while (EOF != (c = getc(in)))
		fputc(c,out);
	fclose(in);

	for(i=0;i<dlg.NumberOfItems;i++)
		wvControlDataGtk(&ctl[i],out);

	in = fopen("gtksection3","rb");
	while (EOF != (c = getc(in)))
		fputc(c,out);
	fclose(in);

	fclose(out);

	for(i=0;i<dlg.NumberOfItems;i++)
		wvFreeControlData(&ctl[i]);
	wvFree(ctl);
	wvFreeDialogBoxHeader(&dlg);

	fclose(fd);
	}

void wvGetDialogBoxHeader(DialogBoxHeader *dlg,FILE *fd)
	{
	U16 temp;
	int pos=0,len=0;
	dlg->lStyle = read_32ubit(fd);
    dlg->lExtendedStyle = read_32ubit(fd);  /* new for NT */
    dlg->NumberOfItems = read_16ubit(fd);
    dlg->x = read_16ubit(fd);
    dlg->y = read_16ubit(fd);
    dlg->cx = read_16ubit(fd);
    dlg->cy = read_16ubit(fd);
	temp = read_16ubit(fd);
	if (temp == 0xffff)
		{
		dlg->MenuName=NULL;
		do 
			{
			extendU16(&dlg->MenuName,&pos,&len,temp);
			temp = read_16ubit(fd);
			} while (temp != 0);
		extendU16(&dlg->MenuName,&pos,&len,0);
		}
	else
		{
		dlg->MenuName = (U16 *)malloc(1);
		dlg->MenuName[0] = temp;
		}
	temp = read_16ubit(fd);
	len=0,pos=0;
	if (temp == 0xffff)
		{
		dlg->ClassName=NULL;
		do 
			{
			extendU16(&dlg->ClassName,&pos,&len,temp);
			temp = read_16ubit(fd);
			} while (temp != 0);
		extendU16(&dlg->ClassName,&pos,&len,0);
		}
	else
		{
		dlg->ClassName = (U16 *)malloc(1);
		dlg->ClassName[0] = temp;
		}

	dlg->szCaption=NULL;
	len=0,pos=0;
	do 
		{
		temp = read_16ubit(fd);
		extendU16(&dlg->szCaption,&pos,&len,temp);
		}
	while (temp != 0);

   	dlg->wPointSize=0;
    dlg->szFontName=NULL;

	if (dlg->lStyle & DS_SETFONT)
		{
		dlg->wPointSize = read_16ubit(fd);       /* Only here if FONT set for dialog */
		len=0,pos=0;
		do 
			{
			temp = read_16ubit(fd);
			extendU16(&dlg->szFontName,&pos,&len,temp);
			}
		while (temp != 0);
		}
	}


void wvGetControlData(ControlData *ctl,FILE *fd)
	{
	long tpos;
	U16 i,temp;
	int len=0,pos=0;

	/* byte alignment chomping */
	tpos = ftell(fd);
	tpos = tpos%4;
	if (tpos) fseek(fd,4-tpos,SEEK_CUR); 

	ctl->lStyle = read_32ubit(fd);
  	ctl->lExtendedStyle = read_32ubit(fd);
	ctl->x = read_16ubit(fd);
  	ctl->y = read_16ubit(fd);
  	ctl->cx = read_16ubit(fd);
	ctl->cy = read_16ubit(fd);
	ctl->wId = read_16ubit(fd);

	temp = read_16ubit(fd);
	len=0,pos=0;
	if (temp == 0xffff)
		{
		ctl->ClassId=NULL;
		temp = read_16ubit(fd);
		do 
			{
			extendU16(&ctl->ClassId,&pos,&len,temp);
			temp = read_16ubit(fd);
			} while (temp != 0);
		extendU16(&ctl->ClassId,&pos,&len,0);
		}
	else
		{
		ctl->ClassId = (U16 *)malloc(1);
		ctl->ClassId[0] = temp;
		}

	temp = read_16ubit(fd);
	len=0,pos=0;
	if (temp == 0xffff)
		{
		ctl->Text=NULL;
		do 
			{
			extendU16(&ctl->Text,&pos,&len,temp);
			temp = read_16ubit(fd);
			} while (temp != 0);
		extendU16(&ctl->Text,&pos,&len,0);
		}
	else
		{
		ctl->Text = (U16 *)malloc(1);
		ctl->Text[0] = temp;
		}

	/* ???? */
	if (ctl->Text[0] == 0) return;

	ctl->nExtraStuff = read_16ubit(fd);
	}


void wvFreeControlData(ControlData *ctl)
	{
	wvFree(ctl->ClassId);
	wvFree(ctl->Text);
	}

void wvFreeDialogBoxHeader(DialogBoxHeader *dlg)
	{
	wvFree(dlg->MenuName);
	wvFree(dlg->ClassName);
	wvFree(dlg->szCaption);
	wvFree(dlg->szFontName);
	}


void wvDialogBoxHeaderGtk(DialogBoxHeader *dlg, FILE *out)
	{
	int c;
	char *str=NULL;
	int pos=0,len=0;
	U16 *p;

	p = dlg->szCaption;
	if (p == NULL)
		str = "Untitled";
	else
		{
		while (*p)
			extendstr(&str,&pos,&len,*p++);
		}

	fprintf(out,"gtk_window_set_title(GTK_WINDOW(window), \"%s\");\n",str);
	}

void wvControlDataGtk(ControlData *ctl,FILE *out)
	{
	char *str;
	U16 *p;
	int pos=0,len=0;
	FILE *in;
	int c;

	p = ctl->Text;
	if (p == NULL)
		str = "Untitled";
	else
		{
		while (*p)
			extendstr(&str,&pos,&len,*p++);
		}
	/*
	fprintf(out,"button = gtk_button_new_with_label (\"a\");\n");
	*/
	fprintf(out,"button = gtk_label_new(\"a\");\n");
	fprintf(out,"gtk_fixed_put (GTK_FIXED (fixed), button, %d, %d);\n",ctl->x,ctl->y);
	fprintf(out,"gtk_widget_set_usize(button,%d,%d);\n",ctl->cx,ctl->cy);
	fprintf(out,"gtk_widget_show (button);\n");
	}

