/* webCpp
 * Copyright (C) 2002 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <iostream>
#include <fstream>
#include <string>
#include <cctype>
#include "colour.h"
using namespace std;


// constructors ---------------------------------------------------------------
// default constructor sets the default colours -------------------------------
Colour::Colour() {create(); def_sc();}
// overloaded constructor takes a filename to scheme --------------------------
Colour::Colour(string scsfile) {create(); schemeIt(scsfile);}
// create the elements --------------------------------------------------------
void Colour::create() {for(int i=0; i < 7; i++) Colours.push_back("");}
// sets to default ------------------------------------------------------------
void Colour::def_sc()    // sets default colours
{
 setColour("#ffffff",0); // background
 setColour("#00b800",1); // preprocessor
 setColour("#000000",2); // normal text
 setColour("#0000ff",3); // keywords
 setColour("#a900a9",4); // numbers
 setColour("#ff0000",5); // strings
 setColour("#666666",6); // comments
}
// ----------------------------------------------------------------------------
// enforces proper colour format ----------------------------------------------
bool Colour::verifyData(string hexData) {


 // make sure string is the right length
 if (hexData.size() != 7) {

  cerr << hexData << "\a is an invalid colour.\n";
  return false;
 }

 // string must start with '#'
 if (hexData[0] != '#') {

  cerr << hexData << "\a is an invalid colour.\n";
  return false;
 }

 // change string to uppercase
 for (int i=1; i < 7; i++) {hexData[i] = toupper(hexData[i]);}

 // enforce range from #000000 to #FFFFFF
 for (int j=1; j < 7; j++) {

  if (hexData[j] < '0' || hexData[j] > 'F') {
   cerr << hexData << "\a is an invalid colour.\n";
   return false;
  }
  if (ispunct(hexData[j]) || isspace(hexData[j])) {
   cerr << hexData << "\a is an invalid colour.\n";
   return false;
  }
 }

 return true;
}
// ----------------------------------------------------------------------------
// set methods ----------------------------------------------------------------
void Colour::setColour(string colour, int num) {Colours[num] = colour;}
// ----------------------------------------------------------------------------
// asks the user to input each colour -----------------------------------------
void Colour::setAllColours()
{
  string colour;

  cerr << "\nEnter the colours in Hex format (#000000 - #FFFFFF)\n";

  for(int i=0; i < Colours.size(); i++) {
   do {
    switch (i) {
     case (0): cerr << "\nbackground:   "; break;
     case (1): cerr << "\npreprocessor: "; break;
     case (2): cerr << "\nnormal text:  "; break;
     case (3): cerr << "\nkeywords:     "; break;
     case (4): cerr << "\nnumbers:      "; break;
     case (5): cerr << "\nstrings:      "; break;
     case (6): cerr << "\ncomments:     "; break;
    }
    cin  >> colour;
   }while (!verifyData(colour));
   setColour(colour,i);
  }
  ofstream save;
  save.open("newscheme.scs");
  for(int j=0; j < Colours.size(); j++) {
   save << Colours[j] << "\n";
  }
  save.close();
  cerr << "\nscheme saved to newscheme.scs\n";
}
// ----------------------------------------------------------------------------
// sets the colour scheme using a .scs config file ----------------------------
void Colour::schemeIt(string scheme)
{
 string colour;

 if (scheme.substr(scheme.find(".",scheme.size()-5)+1, 3) != "scs") {
  cerr << scheme << "\a has to end with .scs, using default scheme.\n";
  return;
 }


 string path;
 path = "/usr/local/webcpp/schemes/" + scheme;

 // if file isn't found, try current directory
 if (!SCS.openR(path)) {

//  cerr << "looking for " << path << "...\n";
  //SCS.close();
  if (!SCS.openR(scheme)) {

   cerr << "\asearch for " << scheme
        << " failed, falling back to default scheme.\n";
   SCS.close();
   return;
  }
 }
 //if(SCS.ifile)

 for(int i=0; i < Colours.size(); i++) {

  SCS.ifile >> colour;
  if (!verifyData(colour)) {
   def_sc();
   SCS.ifile.close();
   return;
  }
  setColour(colour,i);
 }

 SCS.ifile.close();
}
//-----------------------------------------------------------------------------

