
/* Cfour (C++ Common Console Classes) v1.1
 * Copyright (C) 2001 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cffile.h"

// constructors ----------------------------------------------------------------
CFfile::CFfile() {}
CFfile::CFfile(string filename, char io) {open(filename,io);}
// -----------------------------------------------------------------------------
CFfile::CFfile(string in, string out) {

 openR(in);
 openW(out);
}
// destructor ------------------------------------------------------------------
CFfile::~CFfile() {close();}
// -----------------------------------------------------------------------------
// open methods ----------------------------------------------------------------
bool CFfile::open(string &filename, char io)  {

 switch (io) {
  case 'i': return openR(filename);
  case 'o': return openW(filename);
  default: cerr << "\nInvalid I/O mode.\n"; return false;
 }

 return true;
} // ---------------------------------------------------------------------------
bool CFfile::openR(string &INfile)  {

 if (exists(INfile)) {
  ifile.open(INfile.data());
  return true;
 } else {
  cerr << "\n\a" << INfile << " cannot be opened.\n";
  return false;
 }
} // ---------------------------------------------------------------------------
bool CFfile::openW(string &OUTfile) {

 if (exists(OUTfile)) {
  char write;
  do {
   cerr << "\n" << OUTfile << " already exists. Overwrite? (Y/N) ";
   cin  >> write;
   if (write == 'N' || write == 'n') {return false;}
  } while (!(write == 'Y' || write == 'y'));
 }
 ofile.open(OUTfile.data());
 return true;
}
// -----------------------------------------------------------------------------
// backup a file ---------------------------------------------------------------
void CFfile::backup(string fname, string bname) {

 ifstream bin;
 ofstream bout;
 string linebuf;

 bin.open(fname.data());
 bout.open(bname.data());

 getline(bin,linebuf);
 while (bin) {
  bout << linebuf;
  getline(bin,linebuf);
  if (bin) bout << endl;
 }
 bin.close();
 bout.close();
}
// -----------------------------------------------------------------------------
// checks if a file exists -----------------------------------------------------
bool CFfile::exists(string fname) {

 ifstream chk;
 chk.open(fname.data());

 if(!chk) {
  chk.close();
  return false;
 }

 chk.close();
 return true;
}
// -----------------------------------------------------------------------------
// close methods ---------------------------------------------------------------
void CFfile::closeR() {if(ifile) ifile.close();}
void CFfile::closeW() {if(ofile) ofile.close();}
void CFfile::close()  {closeR(); closeW();}
// -----------------------------------------------------------------------------
