/* webCpp
 * Copyright (C) 2002 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "lang.h"
#include "ctype.h"
#include <iostream>
using namespace std;
//-----------------------------------------------------------------------------
void Lang::keyCheck(string &buffer, string colour, bool css) {

 if(buffer[0] == '#') {return;}

 int index, offset;

 string fntag;
 string cltag;

 offset = 23;

 fntag = "<b><font COLOR=" + colour + ">";
 cltag = "</font></b>";


 if(css) {
  fntag = "<font CLASS=keyword>";
  cltag = "</font>";
  offset = 20;
 }


 for(int i=0; i < (int)keys.size(); i++) {

  index = buffer.find(keys[i], 0);

  while(index < string::npos) {

   if(index != -1) {
    if(iskey(buffer, index-1, (index) + keys[i].size())) {
     buffer.insert(index, fntag);
     buffer.insert(index+keys[i].size()+offset, cltag);
    }
    index = buffer.find(keys[i], (index + keys[i].size() + offset));
   }
  }
 }
}

bool Lang::iskey(string &buffer, int before, int after) const {

 if(buffer[before] == '_')   {return false;}
 if(buffer[after]  == '_')   {return false;}
 if(isalnum(buffer[before])) {return false;}
 if(isalnum(buffer[after]))  {return false;}

 if(ispunct(buffer[before]) || isspace(buffer[before])) {
  if(ispunct(buffer[after]) || isspace(buffer[after]))  {return true;}
 }

 return true;
}

