/* webCpp
 * Copyright (C) 2002 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "headbanger.h"
#include "hypersystem.h"

//-----------------------------------------------------------------------------
HeadBanger::HeadBanger() {

 buffer   = "";
 picture  = "";
 lncnt    =  1;
 filetype =  8;

 incomment = false;
 instring  = false;

 margin  = false;
 redir_I = false;
 redir_O = false;
 made  = false;
 hyper = false;
 csson = false;
 cssfile = "";
}
//-----------------------------------------------------------------------------
void HeadBanger::Colourizer() {

 if(redir_I) {getline(cin,buffer);}
 else getline(fIO.ifile,buffer);
 Angle_Brackets();

 if(filetype == 8) {
  HyperSystem::tagMe(buffer);
  HyperSystem::nameMe(buffer);
  HyperSystem::linkMe(buffer);
 }

 if(filetype <= 3) {

  if(margin) {
   mkMargin();
  }
  numCheck();   // check and colour numbers, if any;
  keysCheck();  // and keywords
  strCheck();   // and strings
  preCheck();   // and preprocessor statements

// fIO.ofile << "\nin Colourizer() 6\n";
// fIO.ofile << buffer << endl;
  if(!instring) {
   HyperSystem::tagMe(buffer);
   HyperSystem::nameMe(buffer);
   HyperSystem::linkMe(buffer);
  }

  if(filetype != 1) {cmntCheck();} // do C++/Java comments
  colour_CCMNT();                 // and do C-Style comments
 }

 if(redir_O) {cout << buffer << endl;}
 else   {fIO.ofile << buffer << endl;}

 buffer = "";
 lncnt++;
}
//-----------------------------------------------------------------------------
// check for comments ---------------------------------------------------------
void HeadBanger::cmntCheck() {

 int index = buffer.find("//",0);
 if(index != -1) {
  if(!isInsideIt(index,"\"","\"")) {colour_CMNT(index);}
 }

 if(filetype == 3) {
  index = buffer.find("#",0);
  if(index != -1 && buffer[index -1] != '\\') {

   if(index != 0) {

    while(buffer[index -1] == '=' && index < string::npos) {
     index = buffer.find("#",index+1);
    }
   }
   if(index == -1) {return;}
   if(buffer[index -1] == '$')      {return;}
   if(buffer[index -1] == '\\')     {return;}
   if(!isInsideIt(index,"\"","\"")) {colour_CMNT(index);}
  }
 }

}
//-----------------------------------------------------------------------------
// check for preprocessor statements ------------------------------------------
void HeadBanger::preCheck()
{
 if (buffer[0] == '#') {colour_PRE();}
}
//-----------------------------------------------------------------------------
// colour the preprocessor statements -----------------------------------------
void HeadBanger::colour_PRE() {

 if(hyper) {
  HyperSystem::includeMe(buffer);
 }

 string fntag = "<font COLOR=" + ColourOf.PreProcessor() + ">";
 string cltag = "</font>";

 if(cssfile != "") {
  fntag = "<font CLASS=preproc>";
 }

 buffer += " ";
 buffer.insert(0, fntag);
 buffer.insert(buffer.find(" ", buffer.find(" ",0)+1), cltag);
}

//-----------------------------------------------------------------------------
// colour the C-style comment -------------------------------------------------
void HeadBanger::colour_CCMNT() {

 string fntag = "<font COLOR=" + ColourOf.Comments() + ">";
 string cltag = "</font>";

 if(cssfile != "") {
  fntag = "<font CLASS=comment>";
 }

 int ccmnt_s;
// int erase1, erase2;

 ccmnt_s = buffer.find("/*",0);

 if(ccmnt_s != -1 && !isInsideIt(ccmnt_s,"\"","\"")) {

  // un-colour
  eraseTags(ccmnt_s,0);

  int ccmnt_f;

  buffer.insert(ccmnt_s, fntag);

  ccmnt_f = buffer.find("*/",ccmnt_s +1);
  if(ccmnt_f != -1) buffer.insert(ccmnt_f +2,cltag);

  else {
   lncnt++;
   if(redir_O) {cout << buffer << endl;}
   else fIO.ofile << buffer << endl;
   while(buffer.find("*/",0) == -1) {

    if(margin) {mkMargin();}
    if(redir_I) {getline(cin, buffer);}
    else getline(fIO.ifile, buffer);
    Angle_Brackets();
    ccmnt_f = buffer.find("*/",0);
    if(ccmnt_f != -1) {buffer.insert(ccmnt_f +2,cltag);}
    else if (redir_O) {cout << buffer << endl;}
    else fIO.ofile << buffer << endl;
    lncnt++;
   }
  }
 }

}
//-----------------------------------------------------------------------------

