#!/bin/bash

# Webcpp ncurses installation script v1.3
# by Jeffrey Bakker, 2001
# last modified September 2nd, 2001

# check if dialog is installed -------------------------------
DIALOG_PRESENT=`dialog`

if [ "DIALOG_PRESENT" = "" ]; then
 echo "dialog is not present, exiting..."
 echo "run install_cli.sh instead"
 exit 1
fi
# continue with the script if so -----------------------------

# version number and default installation directory ----------
VER="0.6.5"
DEF_DIR="/usr/local/webcpp"
INSTALL_DIR="$DEF_DIR"


# loop the menu ----------------------------------------------
while [ output != "4" ]; do

dialog --backtitle "WebCpp-$VER INSTALLATION" \
       --title "Main Menu" \
       --menu "choose" 16 60 10 \
         1 "WebCpp?" \
         2 "Choose directory ($INSTALL_DIR)" \
         3 "Install" \
         4 "WebCpp Webpage" \
         5 "Exit" 2> .tempfile
         output=`cat .tempfile`
         rm -f .tempfile


# if Number 1 was chosen, show info ---------------------------
if [ "$output" = "1" ]; then
 dialog --textbox ./webcpp.lsm 15 74
fi


# if Number 2 was chosen, ask for the directory ---------------
if [ "$output" = "2" ]; then
  dialog --inputbox "WebC++ Installation Directory" 10 40 $DEF_DIR 2> .tempfile2
  INSTALL_DIR=`cat .tempfile2`
  rm -f .tempfile2
fi


# if 3 was chosen, install ------------------------------------
if [ "$output" = "3" ]; then

dialog --msgbox "Installing webcpp to $INSTALL_DIR" 10 65

# create install dir ------------------------------------------
#rm -rf $INSTALL_DIR
mkdir $INSTALL_DIR
mkdir $INSTALL_DIR/docs
mkdir $INSTALL_DIR/schemes

# copy the files ----------------------------------------------
cp ./v$VER/webcpp $INSTALL_DIR/webcpp
cp ./v$VER/helpless.txt $INSTALL_DIR/helpless.txt
cp ./v$VER/wwwcpp.sh $INSTALL_DIR/wwwcpp.sh
cp ./v$VER/scs2css.pl $INSTALL_DIR/scs2css.pl
cp ./v$VER/sample.cpp $INSTALL_DIR/sample.cpp
cp ./v$VER/data/*.scs $INSTALL_DIR/schemes/
cp ./v$VER/data/*.css $INSTALL_DIR/schemes/
cp ./v$VER/docs/en/* $INSTALL_DIR/docs

# generate information html files standard GPL stuff ----------
mkdir $INSTALL_DIR/html
$INSTALL_DIR/webcpp ./AUTHORS $INSTALL_DIR/html/authors.html
#$INSTALL_DIR/webcpp ./Bugs $INSTALL_DIR/html/bugs.html
$INSTALL_DIR/webcpp ./COPYING $INSTALL_DIR/html/copying.html
$INSTALL_DIR/webcpp ./ChangeLog $INSTALL_DIR/html/changes.html
#$INSTALL_DIR/webcpp ./DOCUMENTATION $INSTALL_DIR/html/documentation.html
#$INSTALL_DIR/webcpp ./News $INSTALL_DIR/html/news.html
#$INSTALL_DIR/webcpp ./README.txt $INSTALL_DIR/html/readme.html
$INSTALL_DIR/webcpp ./TODO $INSTALL_DIR/html/todo.html
cp docs.html $INSTALL_DIR/

#echo $INSTALL_DIR > $INSTALL_DIR/.pathrc
#echo $INSTALL_DIR > $HOME/.webcpprc

if [ "$INSTALL_DIR" != "$DEF_DIR" ]; then
rm -rf $DEF_DIR
ln -sf $INSTALL_DIR $DEF_DIR
fi

# create symbolic link in /usr/bin/ ---------------------------
ln -sf $INSTALL_DIR/webcpp /usr/bin/webcpp

chmod 755 $INSTALL_DIR/wwwcpp.sh
ln -sf $INSTALL_DIR/wwwcpp.sh /usr/bin/wwwcpp

chmod 755 $INSTALL_DIR/scs2css.pl
ln -sf $INSTALL_DIR/scs2css.pl /usr/bin/scs2css

make distclean

dialog --msgbox "Enjoy WebC++." 5 30
dialog --textbox $INSTALL_DIR/helpless.txt 15 74

exit 0
fi

# if 4 was chosen ---------------------------------------------
if [ "$output" = "4" ]; then
netscape http://webcpp.sourceforge.net &
lynx http://webcpp.sourceforge.net
fi

# exit if "Exit" was chosen -----------------------------------
if [ "$output" = "5" ]; then
exit 0
fi

done