#!/bin/bash

# Webcpp command-line installation script v1.3
# by Jeffrey Bakker, 2001
# last modified September 2nd, 2001

# version number and default installation directory ----------
VER="0.6.5"
DEF_DIR="/usr/local/webcpp"
INSTALL_DIR="$DEF_DIR"

# introduction ------------------------------------------------
clear
date
echo ""
echo "           *** WebCpp-$VER installation script ***"
echo ""

# ask user for install dir ------------------------------------
echo "Enter the directory to install to: [default = $DEF_DIR]"
echo ""
read INSTALL_DIR

if [ "$INSTALL_DIR" = "" ]; then
INSTALL_DIR="$DEF_DIR"
fi

# create install dir ------------------------------------------
#rm -rf $INSTALL_DIR
mkdir $INSTALL_DIR
mkdir $INSTALL_DIR/docs
mkdir $INSTALL_DIR/schemes

# copy the files ----------------------------------------------
cp ./v$VER/webcpp $INSTALL_DIR/webcpp
cp ./v$VER/helpless.txt $INSTALL_DIR/helpless.txt
cp ./v$VER/wwwcpp.sh $INSTALL_DIR/wwwcpp.sh
cp ./v$VER/scs2css.pl $INSTALL_DIR/scs2css.pl
cp ./v$VER/sample.cpp $INSTALL_DIR/sample.cpp
cp ./v$VER/data/*.scs $INSTALL_DIR/schemes
cp ./v$VER/data/*.css $INSTALL_DIR/schemes
cp ./v$VER/docs/en/* $INSTALL_DIR/docs

# generate information html files standard GPL stuff ----------
mkdir $INSTALL_DIR/html
$INSTALL_DIR/webcpp ./AUTHORS $INSTALL_DIR/html/authors.html
#$INSTALL_DIR/webcpp ./Bugs $INSTALL_DIR/html/bugs.html
$INSTALL_DIR/webcpp ./COPYING $INSTALL_DIR/html/copying.html
$INSTALL_DIR/webcpp ./ChangeLog $INSTALL_DIR/html/changes.html
$INSTALL_DIR/webcpp ./docs.txt $INSTALL_DIR/html/documentation.html
#$INSTALL_DIR/webcpp ./News $INSTALL_DIR/html/news.html
#$INSTALL_DIR/webcpp ./README.txt $INSTALL_DIR/html/readme.html
$INSTALL_DIR/webcpp ./TODO $INSTALL_DIR/html/todo.html
cp docs.html $INSTALL_DIR/

#echo $INSTALL_DIR > $INSTALL_DIR/.pathrc
#echo $INSTALL_DIR > $HOME/.webcpprc

if [ "$INSTALL_DIR" != "$DEF_DIR" ]; then
rm -rf $DEF_DIR
ln -sf $INSTALL_DIR $DEF_DIR
fi

# environment variables ---------------------------------------
#echo "SCS=$INSTALL_DIR/schemes" >>$HOME/.bashrc
#echo "webcpp=$INSTALL_DIR/webcpp" >>$HOME/.bashrc


# create symbolic link in /usr/bin/ ---------------------------
ln -sf $INSTALL_DIR/webcpp /usr/bin/webcpp

#echo "$INSTALL_DIR/webcpp \$1 \$2 \$3" > /usr/bin/webcpp
#chmod 755 /usr/bin/webcpp

chmod 755 $INSTALL_DIR/wwwcpp.sh
ln -sf $INSTALL_DIR/wwwcpp.sh /usr/bin/wwwcpp

chmod 755 $INSTALL_DIR/scs2css.pl
ln -sf $INSTALL_DIR/scs2css.pl /usr/bin/scs2css

# change into directory and execute program -------------------
cd $INSTALL_DIR
./webcpp
