#include "tcb.h"
#include <errno.h>
#include <fcntl.h>
#include <termios.h>
#include <termcap.h>
#include <signal.h>
#include <stdarg.h>
#include <sys/ioctl.h>
#include <sys/time.h>

static VT *vt;

void vt_printf(char *fmt, ...)/*tcb*/
{
  va_list ap;

  if (!vt_mode('D')) return;
  va_start(ap, fmt);
  vt->printf(fmt, ap);
  va_end(ap);
}

int vt_putchar(int c)/*tcb*/
{
  return vt->put_char(c);
}

void vt_flush(void)/*tcb*/
{
  vt->flush();
}

void vt_endstand(void)/*tcb*/
{
  vt->endstand();
}

void vt_stand(void)/*tcb*/
{
  vt->stand();
}

void vt_move(int row, int col)/*tcb*/
{
  vt->move(row, col);
}

int vt_row(int row)/*tcb*/
{
  return vt->row(row);
}

int vt_col(int col)/*tcb*/
{
  return vt->col(col);
}

void vt_clear(void)/*tcb*/
{
  vt->clear();
}

void vt_eeol(void)/*tcb*/
{
  vt->eeol();
}

void vt_left(void)/*tcb*/
{
  vt->left();
}

void vt_sf(void)/*tcb*/
{
  vt->sf();
}

void vt_sr(void)/*tcb*/
{
  vt->sr();
}

void vt_rc(void)/*tcb*/
{
  vt->rc();
}

void vt_sc(void)/*tcb*/
{
  vt->sc();
}

void vt_cs(int m, int n)/*tcb*/
{
  vt->cs(m, n);
}

void vt_seta(int attr)/*tcb*/
{
  vt->seta(attr);
}

char *vt_geta(int attr)/*tcb*/
{
  return vt->geta(attr);
}

void vt_ks(char *ks[])/*tcb*/
{
  vt->ks(ks);
}

int vt_mode(int mode)/*tcb*/
{
  return vt->mode(mode);
}

int vt_cursor(int f_cursor)/*tcb*/
{
  return vt->cursor(f_cursor);
}

int vt_select(int ntty)/*tcb*/
{
  return vt->select(ntty);
}

int vt_set(int f_tcb0)/*tcb*/
{
  static int f_tcb;

  if (f_tcb0) {
    f_tcb = f_tcb0;
    vt = tc_load();
  }
  return f_tcb;
}

int get_winsize(int *rowp, int *colp)/*tcb*/
{
  struct winsize winsize;
  int fd;

  winsize.ws_row = 0;
  fd = open("/dev/tty", O_RDWR);
  if (ioctl(fd, TIOCGWINSZ, &winsize) < 0)
    fprintf(stderr, "%s: get_winsize(): %s\n", s_S(S_tcb), strerror(errno));
  else {
    if (!winsize.ws_row) {
      *rowp = 80;
      *colp = 30;
    } else {
      *rowp = winsize.ws_row;
      *colp = winsize.ws_col;
    }
  }
  close(fd);
  return 0;
}

int set_winsize(int row, int col)/*tcb*/
{
  struct winsize winsize;

  winsize.ws_row = row;
  winsize.ws_col = col;
  if (ioctl(1, TIOCSWINSZ, &winsize) < 0)
    save_error("%s: set_winsize(): %s.\n", s_S(S_tcb), strerror(errno));
  return 0;
}

int vt_getch(int f_skip)/*tcb*/
{
  int i;
  u_char c;

  if (f_skip <= 0 && vt_select(f_skip) != 2) return 0;
  if (!(i = read(vt_tfd(0), &c, 1)) || i < 0) return 0;
  return (c) ? c : K_at; /* Ctrl+Space */
}

int vt_charset(int i)/*tcb*/
{
  static int charset;

  if (i) charset = i;
  return charset;
}

void vt_winsize(void)/*tcb*/
{
  int row, col;

  get_winsize(&row, &col);
  vt_row(row);
  vt_col(col);
  setenv("LINES", utoa(row), 1);
  setenv("COLUMNS", utoa(col), 1);
  if (!vt_mode('S') && !vt_mode('H')) vt_cs(vt_row(0) - 2, 0);
}

void vt_setwin(int row, int col)/*tcb*/
{
  vt_row(row);
  vt_col(col);
  if (!vt_mode('S') && !vt_mode('H')) vt_cs(vt_row(0) - 2, 0);
}

int vt_tfd(int i)/*tcb*/
{
  static int tfd;

  if (i < 0) close(tfd);
  else if (i > 0) tfd = i;
  return tfd;
}

int vt_init(int init)/*tcb*/
{
  static struct termios tty_termio, vt_termio;
  static int tfd; 
  int row, col;
  char *cp = getenv("TCBCHARSET");

  do {
    switch(init) {
    case 0:
      continue;
    case -7:
    case -1:
    case 1:
      tcsetattr(tfd, TCSANOW, &vt_termio);	
      vt_mode(init);
      break;
    case 10:
      vt_termio.c_cc[VMIN] = 0;
      vt_termio.c_cc[VTIME] = 1;
      tcsetattr(tfd, TCSANOW, &vt_termio);	
      vt_mode(init);
      break;
    case 20:
      vt_termio.c_cc[VMIN] = 0;
      vt_termio.c_cc[VTIME] = 0;
      tcsetattr(tfd, TCSANOW, &vt_termio);	
      vt_mode(init);
      break;
    case -9:
      tcsetattr(tfd, TCSANOW, &vt_termio);	
      break;
    case 30:
      vt_mode(init);
      break;
    case -3:
    case -8:
    case -5:
    case -2:
    case 2:
      vt_mode(init);
      tcsetattr(tfd, TCSANOW, &tty_termio);
      if (init == -3) {
	close(tfd);
	tfd = 0;
      }
      break;
    default:
      vt_mode(init);
      break;
    } 
    return 0;
  } while (0);
  get_winsize(&row, &col);
  vt_row(row);
  vt_col(col);
  tfd = open(s_S(S_tty), O_RDWR);
  if (!isatty(tfd)) {
    fprintf(stderr, "%s: %s\n", s_S(S_tcb), s_S(S_erru));
    return -1;
  }
  vt_tfd(tfd);
  tcgetattr(tfd, &tty_termio);
  vt_termio = tty_termio;
  cfmakeraw(&vt_termio);
  vt_termio.c_iflag &= ~(INLCR|ICRNL|ISTRIP|IGNBRK|IGNCR);
  vt_termio.c_lflag &= ~(ICANON|ECHO|NOFLSH);
  vt_termio.c_oflag &= OPOST;
  vt_termio.c_oflag &= ~ONLCR;
  vt_termio.c_cc[VMIN] = 0;
  vt_termio.c_cc[VTIME] = 1;
  tcsetattr(tfd, TCSANOW, &vt_termio);
  vt_mode('d');
  if (vt_mode(0) < 0) {
    tcsetattr(tfd, TCSANOW, &tty_termio);
    close(tfd);
    return -1;
  }
  if (cp) vt_charset((!strcasecmp(cp, "ascii")) ? C_ascii : C_none);
  return 0;
}

