#include "tcb.h"
#include <signal.h>
#include <sys/wait.h>
int is_man(char *man)/*tcb*/
{ /*
   * \012.\" 
   * \012.B 
   * \012.I
   * \012.aa \012.ab ... \012.zy \012.zz
   * \012.Aa \012.Ab ... \012.Zy \012.Zz 
   * \012.AA \012.AB ... \012.ZY \012.ZZ
   */
  int i, c1, c2;

  if (man[0] == '.') {
    c1 = man[1];
    c2 = man[2];
    if (c1 == '\\' && c2 == '\042') return 1;
    if ((c1 == 'B' || c1 == 'I') && c2 == ' ') return 1;
    if ((i = c1 >= 'A' && c1 <= 'Z') || (c1 >= 'a' && c1 <= 'z'))
      if ((c2 >= 'a' && c2 <= 'z') || (i && c2 >= 'A' && c2 <= 'Z'))
	if (man[3] == ' ' || man[3] == '\n') return 1;
  }
  return 0;
}

char *type_pipe(char *buff, int size, int code)/*tcb*/
{ /* print file-type (from pipe) */
  CHILD *chp;
  int pv[4];
  char *cp, type[N_line];
  FILE *fp;
  
  if ((chp = check_chp(S_file))) {
    if (!(chp = get_child(NULL, "...", s_S(S_file), "-"))) return NULL;
    pipe(pv);
    if (!fork()) {
      pipe(&pv[2]);
      if (!fork()) {
	close(pv[2]);
	/* check N_pipe bytes */
	fp = fdopen(pv[3], "w");
	fwrite(buff, 1, (size > N_pipe) ? N_pipe : size, fp);
	fclose(fp);
	exit(0);
      }
      dup_error();
      close(0);
      dup2(pv[2], 0);
      close(pv[2]);
      close(pv[3]);
      close(1);
      dup2(pv[1], 1);
      close(pv[1]);
      close(pv[0]);
      execvp(*chp->argv, chp->argv);
    }
    close(pv[1]);
    sprintf(type, "(^%c) ", '@'-code-1);
    fp = fdopen(pv[0], "r");
    cp = &type[5];
    fgets(cp, N_pipe, fp);
    fclose(fp);
    if ((cp = strchr(cp, '\n'))) *cp = '\0';
    for (cp = &(strchr(type,':'))[1]; *cp == ' ' || *cp == '\t'; cp++);
    strcpy(&type[5], cp);
  } else sprintf(type, "%s `%s\047", s_S(S_errc), s_S(S_file));
  cp = type;
  free(buff);
  buff = strdup((chp) ? tobo(cp, 1) : toul(cp, 1));
  return buff;
}

char *type_file(char *buff, char name[], int code)/*tcb*/
{ /* print file-type (from file) */
  CHILD *chp;
  int pv[2];
  char *cp, type[N_line];
  FILE *fp;

  if ((chp = check_chp(S_file))) {
    if (!(chp = get_child(NULL, "...", s_S(S_file), name))) return NULL;
    pipe(pv);
    if (!fork()) {
      dup_error();
      close(1);
      dup2(pv[1], 1);
      close(pv[1]);
      close(pv[0]);
      execvp(*chp->argv, chp->argv);
      exit(0);
    }
    close(pv[1]);
    sprintf(type, "(^%c) ", '@'-code-1);
    fp = fdopen(pv[0], "r");
    cp = &type[5];
    fgets(cp, N_pipe, fp);
    fclose(fp);
    if ((cp = strchr(cp, '\n'))) *cp = '\0';
    for (cp = &(strchr(type,':'))[1]; *cp == ' ' || *cp == '\t'; cp++);
    strcpy(&type[5], cp);
  } else sprintf(type, "%s `%s\047", s_S(S_errc), s_S(S_file));
  cp = type;
  if (buff) free(buff);
  save_error("%s: %s: %s.\n", s_S(S_file), name, cp);
  buff = strdup((chp) ? tobo(cp, 1) : toul(cp, 1));
  return buff;
}

u_char *check_type(u_char *buff, int *sizep, char *name, int *f_Mp, int f_cr, int *codep)/*tcb*/
{
  int size, oldsize, code;
  
  if (!f_cr) {
    *codep = C_bin;
    return buff;
  }
  oldsize = size = *sizep;
  if ((code = init_code(size, buff, f_cr)) < 0) {
    buff = (name) ? type_file(buff, name, code) : type_pipe(buff, size, code);
    if (buff) size = strlen(buff);
    *f_Mp = T_type;
  }
  *codep = code;
  *sizep = size;
  return buff;
}

int init_code(int size, u_char *buff, int f_cr)/*tcb*/
{
  int c;
  u_char *end;

  for (end = buff + size; buff < end; buff++) {
    if ((c = buff[0]) == '\n') continue;
    if (*s_S(S_code) && (f_cr == 1 || f_cr == 3)
	&& (!c || (c < ' ' && !strchr(s_S(S_code), c)))) return -(c+1);
  }
  return C_ascii;
}

