#! /usr/bin/perl
# eg. cd ../src; /bin/ls *|xargs -i -t ../perl/fix.pl {} /tmp/src

$Alloc = 'alloc';
$Src = $ARGV[0];
$Dst = $ARGV[1];
if (!$Src || !$Dst) {
    print STDERR "fix.pl [file.c] [destination-directory]" . "\n"; 
    exit 1;
}
if (!(-d $Dst)) {
    print STDERR "$Dst: Not a directory" . "\n";
    exit 1;
}
if (!(-f $Src) || $Src =~ /\//) {
    print STDERR "$Src: No such file in current directory" . "\n";
    exit 1;
}
exit 0 if ($Src eq $Alloc . '.h');
$Dst .= '/' if (!($Dst =~ /\/$/));
$Dst .= $Src;
open(SRC, $Src);
open(DST, '>' . $Dst);
while (<SRC>) {
    s/tcb_calloc\(\042.*\042\, /calloc\(/;
    s/tcb_malloc\(\042.*\042\, /malloc\(/;
    s/tcb_strdup\(\042.*\042\, /strdup\(/;
    s/tcb_free\(\042.*\042\, /free\(/;
    print DST;
}
close(SRC);
close(DST);
exit 0 if ($Src ne $Alloc . '.c');

$Dst =~ s/\.c/\.h/; 
open(DST, '>' . $Dst);
print DST <<EOF;
#ifndef _ALLOC_H

int printALLOC(char *name);
void initALLOC(void);

#define _ALLOC_H
#else

int printALLOC(char *name)
{
  return 0;
}

void initALLOC(void)
{
}

#endif  _ALLOC_H
EOF
close(DST);


