#! /bin/sh

# working directory
TMP=/tmp/.tcb

# groff options
GROFF="groff -Tlatin1 -mandoc"

# GNU fileutiles
GLS="ls -labF"
GDU="du -ab"
GCP="cp -rvf"
GMV="mv -vf"
GRM="rm -rvf"
# for regular-flie
#GRM="rm -vf"

# not GNU
LS="ls -laF"
DU="du -a"
CP="cp -Rf"
MV="mv -f"
RM="rm -rf"
#RM="rm -f"

# options for ARC
TAR="xvf"
LHA="e"
UNZIP=""

# home (~/.$TCB), lib (/usr/local/lib/$TCB), binary (/usr/local/bin/$TCB)
TCB="tcb"
#TCB="tcbe"	# debugged with Japanese environment

if [ `uname` = Linux ]; then	# Linux
    if [ "$1" = "" ]; then
        USR_DIR=/usr/local
    else
        USR_DIR=$1
    fi
    TCB_1=tcb.1
    PERM='-m 644'
    echo '# Makefile for Linux version' > .config
    echo 'LIBS=	-lncurses'>> .config
else
    if [ `uname` = FreeBSD ]; then	# FreeBSD
        USR_DIR=/usr/local
	TCB_1=tcb.1.gz
	COPY=-c
	PERM='-m 444 -o bin -g bin'
	echo '# Makefile for FreeBSD version' > .config
	echo 'LIBS=	-ltermcap' >> .config
    else
    	echo 'Not supported yet "'`uname`'".'
	exit 1
    fi
fi

LIB=$USR_DIR/lib/$TCB
BIN=$USR_DIR/bin
MAN=$USR_DIR/man/man1

cat >> .config <<EOF
CC=	gcc
#CFLAGS= -Wall -O2 -g
CFLAGS= -Wall -O2
#LDFLAGS=
LDFLAGS= -s
OBJS=	alloc.o child.o code.o disp.o fork.o init.o key.o menu.o \\
	mode.o scroll.o shell.o str.o sub.o tc.o tcb.o vt.o
EOF
if which grep >/dev/null && make -v 2>&1|grep 'GNU Make' >/dev/null 2>&1 && which sed >/dev/null; then
    cat >> .config <<EOF
PROT=	mode.P tc.P tcb.P

.SUFFIXES: .P
.c.P:
	@grep '\/\*\$*\*\/' \$< -h|sed -e 's/\/\*\$*\*\//;/' >\$@
.c.o:
	\$(CC) -c \$(CFLAGS) \$<

default: tcb

tcb.P:	\${subst .o,.c,\$(OBJS)}
	@grep '\/\*tcb\*\/' \${subst .o,.c,\$(OBJS)} -h|\\
	sed -e 's/\/\*tcb\*\//;/' >\$@
EOF
else
	cat >> .config <<EOF

.c.o:
	\$(CC) -c \$(CFLAGS) \$<

default: tcb

EOF
fi
cat >> .config <<EOF

tcb:	\$(PROT) config.h \$(OBJS)
	\$(CC) \$(LDFLAGS) -o \$@  \$(OBJS) \$(LIBS)

menu.o mode.o: menu.h

tcb.o:	version.h

str.o: mode.h config.h

clean:
	rm -f tcb \$(OBJS) *~
EOF
mv .config src/Makefile

cat > install.sh <<EOF
#! /bin/sh
cd src; make; cd ..	
echo 'Installing tcb:'
mkdir -p \$1$BIN
mkdir -p \$1$LIB
mkdir -p \$1$MAN
echo "install $COPY -m 755 src/tcb \$1$BIN/$TCB"
install $COPY -m 755 src/tcb \$1$BIN/$TCB
echo "install $COPY -m 644 tcbrc \$1$LIB"
install $COPY -m 644 tcbrc \$1$LIB
echo "install $COPY -m 644 doc/HELP \$1$LIB"
install $COPY -m 644 doc/HELP \$1$LIB
echo "install $COPY $PERM doc/$TCB_1 \$1$MAN"
install $COPY $PERM doc/$TCB_1 \$1$MAN
EOF
chmod 755 install.sh

echo 'Creating src/config.h:'

cat > .config <<EOF
#ifndef _CONFIG_H
static char TCB[] = "$TCB";
static char LIB[] = "$LIB";
static char TMP[] = "$TMP";
static char GROFF[] = "$GROFF";
static char GLS[] ="$GLS";
static char GDU[] ="$GDU";
static char GCP[] ="$GCP";
static char GMV[] ="$GMV";
static char GRM[] ="$GRM";
static char LS[] = "$LS";
static char DU[] = "$DU";
static char CP[] = "$CP";
static char MV[] = "$MV";
static char RM[] = "$RM";
static char TAR[] = "$TAR";
static char LHA[] = "$LHA";
static char UNZIP[] = "$UNZIP";
#endif _CONFIG_H
#define _CONFIG_H
EOF

if [ -f src/config.h ]; then
    cmp -s .config src/config.h
    if [ ! $? = 0 ]; then
	mv .config src/config.h
    else
	rm .config
	touch src/config.h
    fi
else
    mv .config src/config.h
fi 

