/* file swapendian.c: source to swap binary grid data from IBM RS600 to
 *                    IBM pc and vice versa
 */


#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>

void usage( void );
void swapendian( char*, char* );

static char appname[] = "swapendian";

int main( int argc, char *argv[] )
{
 FILE *input_fid, *output_fid;
 char *buf, *ptr;
 struct stat *statbuf;
 int wrote, check;
 register int i;

 if( argc != 3  ) {
	usage();
	exit(0);
 }

 if( NULL == (input_fid = fopen( argv[1], "r" )) ) {
	fprintf( stderr, "\n");
	perror(appname);
	exit(1);
 }
 statbuf = (struct stat *) malloc( sizeof(struct stat) );
 stat( argv[1], statbuf );
 if( NULL == ( buf = malloc( (size_t)( statbuf->st_size ) ) ) ) {
	fprintf( stderr, "\n");
 	perror(appname);
	exit(1);
 }

 ptr = buf;
#ifdef DEBUG
 printf("%s %d %s\n", "allocated", statbuf->st_size, "bytes of mem" ); 
#endif
 fread( buf, 1, (size_t)( statbuf->st_size ), input_fid );
 fclose( input_fid );

 if( ( check = (statbuf->st_size)%4  ) != 0 ) { /*sorry, but I dunno it */
#ifdef DEBUG
	 printf("%d", check );
#endif
	 fprintf( stderr,"%s%s%s", "\nswapendian: infile \"",
			 argv[1],"\" wasn't multiple of 4 bytes long\n");
	 exit(1);
 }

 for( i=0; i<(statbuf->st_size)/4; i++)  {
	swapendian( ptr, ptr );
	ptr+=4;
 }

 output_fid = fopen( argv[2], "w" );
 wrote = fwrite( buf, 1, (size_t)( statbuf->st_size ), output_fid );
 free(statbuf);
#ifdef DEBUG
 printf("%s %d %s\n", "succesfully wrote", wrote, "bytes");
#endif
 free(buf);
 fclose( output_fid );
 return 0;
}


void usage( void )
{
 fprintf( stderr,"%s %s %s","usage:", appname,
	 "in_file out_file\n");
}

void swapendian( char *ptr, char *cpy_site)
{
char tmp[4];

 tmp[3] =  *ptr;
 tmp[2] =  *(ptr+1);
 tmp[1] =  *(ptr+2);
 tmp[0] =  *(ptr+3);
 memcpy( cpy_site, tmp, 4 );
}
