/*
 * bltInt.h --
 *
 * Copyright 1993-1997 Bell Labs Innovations for Lucent Technologies.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that the
 * copyright notice and warranty disclaimer appear in supporting documentation,
 * and that the names of Lucent Technologies any of their entities not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Lucent Technologies disclaims all warranties with regard to this software,
 * including all implied warranties of merchantability and fitness.  In no event
 * shall Lucent Technologies be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of use,
 * data or profits, whether in an action of contract, negligence or other
 * tortuous action, arising out of or in connection with the use or performance
 * of this software.  
 */

#ifndef _BLT_INT_H
#define _BLT_INT_H

#include <tcl.h>
#include <tk.h>
#include <stdio.h>
#include <assert.h>
#include <math.h>
#include <blt.h>

#include "bltConfig.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */

#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif /* HAVE_ERRNO_H */

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif /* HAVE_MEMORY_H */

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif /* HAVE_MALLOC_H */

#ifdef HAVE_FLOAT_H
#include <float.h>
#endif

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

/* #include "bltList.h" */

#ifndef M_PI
#define M_PI    	3.14159265358979323846
#endif /* M_PI */

#ifndef M_PI_2
#define M_PI_2		1.57079632679489661923
#endif

#ifndef M_SQRT2
#define M_SQRT2		1.41421356237309504880
#endif /* M_SQRT2 */

#ifndef M_SQRT1_2
#define M_SQRT1_2	0.70710678118654752440
#endif /* M_SQRT1_2 */

#ifndef SHRT_MAX
#define SHRT_MAX	0x7FFF
#endif /* SHRT_MAX */

#ifndef SHRT_MIN
#define SHRT_MIN	-(SHRT_MAX)
#endif /* SHRT_MAX */

#ifndef USHRT_MAX
#define	USHRT_MAX	0xFFFF
#endif /* USHRT_MAX */

#ifndef HAVE_FLOAT_H
/*
 * ----------------------------------------------------------------------
 *
 * DBL_MIN, DBL_MAX --
 *
 * 	DBL_MAX and DBL_MIN are the largest and smaller double
 * 	precision numbers that can be represented by the floating
 * 	point hardware. If the compiler is ANSI, they can be found in
 * 	float.h.  Otherwise, we use HUGE_VAL or HUGE to determine
 * 	them.
 *
 * ----------------------------------------------------------------------
 */
/*
 * Don't want to include __infinity (definition of HUGE_VAL (SC1.x))
 */
#ifdef sun
#define DBL_MAX		1.7976931348623157E+308
#define DBL_MIN		2.2250738585072014E-308
#define DBL_EPSILON	2.2204460492503131e-16
#else
#ifndef DBL_EPSILON
#define DBL_EPSILON	BLT_DBL_EPSILON
#endif
#ifdef HUGE_VAL
#define DBL_MAX		HUGE_VAL
#define DBL_MIN		(1/HUGE_VAL)
#else
#ifdef HUGE
#define DBL_MAX		HUGE
#define DBL_MIN		(1/HUGE)
#else
/*
 * Punt: Assume values simple and relatively small
 */
#define DBL_MAX		3.40282347E+38
#define DBL_MIN		1.17549435E-38
#endif /*HUGE*/
#endif /*HUGE_VAL*/
#endif /*sun*/
#endif /*!HAVE_FLOAT_H*/

#ifdef __GNUC__
#define INLINE inline
#else
#define INLINE
#endif

#undef MIN
#define MIN(a,b)	(((a)<(b))?(a):(b))

#undef MAX
#define MAX(a,b)	(((a)>(b))?(a):(b))

/*
 * ----------------------------------------------------------------------
 *
 *  	The following are macros replacing math library functions:
 *  	"fabs", "fmod", "abs", "rint", and "exp10".
 *
 *  	Although many of these routines may be in your math library,
 *  	they aren't used in libtcl.a or libtk.a.  This makes it
 *  	difficult to dynamically load the BLT library as a shared
 *  	object unless the math library is also shared (which isn't
 *  	true on several systems).  We can avoid the problem by
 *  	replacing the "exotic" math routines with macros.
 *
 * ----------------------------------------------------------------------
 */
#undef ABS
#define ABS(x)		(((x)<0)?(-(x)):(x))

#undef EXP10
#define EXP10(x)	(pow(10.0,(x)))

#undef FABS
#define FABS(x) 	(((x)<0.0)?(-(x)):(x))

#undef FMOD
#define FMOD(x,y) 	((x)-(((int)((x)/(y)))*y))

#undef ROUND
#define ROUND(x) 	((int)((x) + (((x)<0.0) ? -0.5 : 0.5)))

#undef SIGN
#define SIGN(x)		(((x) < 0.0) ? -1 : 1)

#define TRUE 	1
#define FALSE 	0

#ifdef hpux
#define BLACK		"black"
#define WHITE		"white"
#define BISQUE1		"bisque1"
#define BISQUE2		"bisque2"
#define BISQUE3     	"bisque3"
#define ANTIQUEWHITE1   "antiquewhite1"
#define GRAY		"grey"
#define LIGHTBLUE2	"lightblue2"
#define RED		"red"
#define PINK		"pink"
#define BLUE		"blue"
#define NAVYBLUE	"navyblue"
#define GRAY85		"gray85"
#define GRAY92		"gray92"
#define GRAY77		"gray92"
#define GRAY64		"gray64"
#define MAROON		"maroon"
#else
#define BLACK		"#000000"
#define WHITE		"#ffffff"
#define BISQUE1		"#ffe4c4"
#define BISQUE2		"#eed5b7"
#define BISQUE3     	"#cdb79e"
#define ANTIQUEWHITE1	"#ffefdb"
#define GRAY		"#b0b0b0"
#define LIGHTBLUE2	"#b2dfee"
#define GRAY85		"#d9d9d9"
#define GRAY92		"#ececec"
#define GRAY77		"#c3c3c3"
#define GRAY64		"#a3a3a3"
#define MAROON		"#b03060"
#define PINK		"#ffc0cb"
#define RED		"#ff0000"
#define BLUE		"#0000ff"
#define GREEN		"#00ff00"
#endif

#ifdef OLD_TK_COLORS
#define STD_NORMAL_BG_COLOR	BISQUE1
#define STD_ACTIVE_BG_COLOR	BISQUE2
#define STD_SELECT_BG_COLOR	LIGHTBLUE2
#define STD_DISABLE_FG_COLOR	GRAY64
#else
#define STD_NORMAL_BG_COLOR	GRAY85
#define STD_ACTIVE_BG_COLOR	GRAY92
#define STD_SELECT_BG_COLOR	GRAY77
#define STD_DISABLE_FG_COLOR	GRAY64
#endif

#define STD_INDICATOR_COLOR	MAROON

#define STD_NORMAL_FG_COLOR	BLACK
#define STD_NORMAL_BG_MONO	WHITE
#define STD_NORMAL_FG_MONO	BLACK
#define STD_ACTIVE_BG_MONO	BLACK
#define STD_ACTIVE_FG_COLOR	BLACK
#define STD_ACTIVE_FG_MONO	WHITE
#define STD_SELECT_FG_COLOR	BLACK
#define STD_SELECT_FG_MONO	WHITE
#define STD_SELECT_BG_MONO	BLACK
#define STD_SELECT_BORDERWIDTH	"2"
#define STD_BORDERWIDTH 	"2"

#define STD_FONT_HUGE		"*-Helvetica-Bold-R-Normal-*-18-180-*"
#define STD_FONT_LARGE		"*-Helvetica-Bold-R-Normal-*-14-140-*"
#define STD_FONT		"*-Helvetica-Bold-R-Normal-*-12-120-*"
#define STD_FONT_SMALL		"*-Helvetica-Bold-R-Normal-*-10-100-*"

#define LineWidth(w)	(((w) > 1) ? (w) : 0)

#define NO_TED			1

#undef VARARGS
#ifdef __cplusplus
#define ANYARGS (...)
#define VARARGS(first)  (first, ...)
#define VARARGS2(first, second)  (first, second, ...)
#else
#define ANYARGS ()
#define VARARGS(first) ()
#define VARARGS2(first, second) ()
#endif

typedef int (QSortCompareProc) _ANSI_ARGS_((const void *, const void *));


/*
 * Tcl/Tk Backward compatibility section.
 */

#if defined(ITCL_NAMESPACES) || (TCL_MAJOR_VERSION >= 8)
#define HAVE_NAMESPACES 1
#else
#define HAVE_NAMESPACES 0
#endif 

#if (TK_MAJOR_VERSION == 4) && (TK_MINOR_VERSION == 0)
typedef ClientData DestroyData;
#define Tk_Cursor Cursor
#else
typedef char *DestroyData;
#endif

#if (TK_MAJOR_VERSION < 8) 

/*
 * The following structure is used by Tk_GetFontMetrics() to return
 * information about the properties of a Tk_Font.  
 */

typedef struct Tk_FontMetrics {
    int ascent;			/* The amount in pixels that the tallest
				 * letter sticks up above the baseline, plus
				 * any extra blank space added by the designer
				 * of the font. */
    int descent;		/* The largest amount in pixels that any
				 * letter sticks below the baseline, plus any
				 * extra blank space added by the designer of
				 * the font. */
    int linespace;		/* The sum of the ascent and descent.  How
				 * far apart two lines of text in the same
				 * font should be placed so that none of the
				 * characters in one line overlap any of the
				 * characters in the other line. */
} Tk_FontMetrics;

typedef XFontStruct *Tk_Font;

#define Tk_FontId(font)			((font)->fid)
#define Tk_TextWidth(font, str, len)	(XTextWidth((font),(str),(len)))
#define Tk_GetFontMetrics(font, fmPtr)  \
	((fmPtr)->ascent = (font)->ascent, (fmPtr)->descent = (font)->descent, \
	 (fmPtr)->linespace = (font)->ascent + (font)->descent)

#define Tk_NameOfFont(font)		(Tk_NameOfFontStruct(font))
#define Tk_DrawChars(dpy, draw, gc, font, str, len, x, y) \
    TkDisplayChars((dpy),(draw),(gc),(font),(str),(len),(x),(y), 0, DEF_TEXT_FLAGS)

#define Tk_MeasureChars(font, text, len, maxPixels, flags, lenPtr) \
    TkMeasureChars((font),(text), (len), 0, maxPixels, 0,(flags), (lenPtr))

extern int TkMeasureChars _ANSI_ARGS_((Tk_Font font, char *source, int maxChars, 
	int startX, int maxX, int tabOrigin, int flags, int *nextXPtr));
extern void TkDisplayChars _ANSI_ARGS_((Display *display, Drawable drawable,
	GC gc, Tk_Font font, char *string, int numChars, int x, int y, 
	int tabOrigin, int flags));

#define Blt_ExprLong			Tcl_ExprLong
#define Blt_ExprDouble			Tcl_ExprDouble

/*
 * FLAGS passed to TkMeasureChars:
 */
#define TK_WHOLE_WORDS			1
#define TK_AT_LEAST_ONE			2
#define TK_PARTIAL_OK			4
#define TK_IGNORE_NEWLINES		8
#define TK_IGNORE_TABS			16

#define NO_FLAGS			0
#else

#define NO_FLAGS			0

extern int Blt_ExprLong _ANSI_ARGS_((Tcl_Interp *interp, char *string, 
	long *valuePtr));
extern int Blt_ExprDouble _ANSI_ARGS_((Tcl_Interp *interp, char *string, 
	double *valuePtr));


#endif

#define DEF_TEXT_FLAGS			(TK_PARTIAL_OK | TK_IGNORE_NEWLINES)

/*
 * Since the Tcl/Tk distribution doesn't perform any asserts, dynamic loading
 * can fail to find the __assert function.  As a workaround, we'll include
 * our own.
 */

#undef	assert

#ifdef	NDEBUG

#define	assert(EX) ((void)0)

#else

extern void Blt_Assert _ANSI_ARGS_((char *testExpr, char *fileName, int lineNum));

#if defined(__STDC__)
#define	assert(EX) (void)((EX) || (Blt_Assert(#EX, __FILE__, __LINE__), 0))
#else
#define	assert(EX) (void)((EX) || (Blt_Assert("EX", __FILE__, __LINE__), 0))
#endif	/* __STDC__ */

#endif	/* NDEBUG */


#define Panic(mesg)	panic("%s:%d %s", __FILE__, __LINE__, (mesg))

typedef int *Blt_Tile;		/* Opaque type for tiles */

/*
 * ----------------------------------------------------------------------
 *
 * Blt_CmdSpec --
 *
 * ----------------------------------------------------------------------
 */
typedef struct {
    char *name;			/* Name of command */
    Tcl_CmdProc *cmdProc;
    Tcl_CmdDeleteProc *cmdDeleteProc;
    ClientData clientData;
} Blt_CmdSpec;

/*
 * ----------------------------------------------------------------------
 *
 * Blt_Operation --
 *
 * 	Generic function prototype of CmdOptions.
 *
 * ----------------------------------------------------------------------
 */
typedef int (*Blt_Operation) _ANSI_ARGS_(ANYARGS);

/*
 * ----------------------------------------------------------------------
 *
 * Blt_OpSpec --
 *
 * 	Structure to specify a set of operations for a Tcl command.
 *      This is passed to the Blt_LookupOperation procedure to look
 *      for a function pointer associated with the operation name.
 *
 * ----------------------------------------------------------------------
 */
typedef struct {
    char *name;			/* Name of operation */
    int minChars;		/* Minimum # characters to disambiguate */
    Blt_Operation proc;
    int minArgs;		/* Minimum # args required */
    int maxArgs;		/* Maximum # args required */
    char *usage;		/* Usage message */

} Blt_OpSpec;

typedef enum {
    BLT_OPER_ARG0,		/* Op name is the first argument */
    BLT_OPER_ARG1,		/* Op name is the second argument */
    BLT_OPER_ARG2,		/* Op name is the third argument */
    BLT_OPER_ARG3,		/* Op name is the fourth argument */
    BLT_OPER_ARG4		/* Op name is the fifth argument */

} Blt_OpIndex;

extern Blt_Operation Blt_LookupOperation _ANSI_ARGS_((Tcl_Interp *interp,
	int numSpecs, Blt_OpSpec * specArr, Blt_OpIndex argIndex,
	int numArgs, char **argArr));

/*
 * ----------------------------------------------------------------------
 *
 * Pad --
 *
 * 	Structure to specify vertical and horizontal padding.
 *
 *	This allows padding to be specified on a per side basis.
 *	Vertically, side1 and side2 refer to the top and bottom sides.
 *	Horizontally, they refer to the left and right sides.
 *
 * ----------------------------------------------------------------------
 */
typedef struct {
    int side1, side2;
} Pad;

#define padLeft  	padX.side1
#define padRight  	padX.side2
#define padTop		padY.side1
#define padBottom	padY.side2
#define PADDING(x)	((x).side1 + (x).side2)

/*
 * ----------------------------------------------------------------------
 *
 * The following enumerated values are used as bit flags.
 *
 *
 * ----------------------------------------------------------------------
 */
typedef enum {
    FILL_NONE,			/* Neither coordinate plane is specified */
    FILL_X,			/* Horizontal plane */
    FILL_Y,			/* Vertical plane */
    FILL_BOTH			/* Both vertical and horizontal planes */
} Fill;

/*
 * ----------------------------------------------------------------------
 *
 * Dashes --
 *
 * 	List of dash values (maximum 11 based upon PostScript limit).
 *
 * ----------------------------------------------------------------------
 */
typedef struct {
    char valueArr[12];
    int numValues;
} Dashes;

/*
 * ----------------------------------------------------------------------
 *
 * TextLineInfo --
 *
 * ----------------------------------------------------------------------
 */
typedef struct {
    int x, y;			/* Coordinates of the baseline */
    char *text;			/* Text to be displayed */
    int numChars;		/* Number of characters in text */
    int width;			/* Width of line in pixels. This information
				 * is used to draw PostScript strings the
				 * same width as X */
} TextSegment;

/*
 * ----------------------------------------------------------------------
 *
 * TextExtents --
 *
 * ----------------------------------------------------------------------
 */
typedef struct {
    int numSegments;		/* # segments of text */
    int width;			/* Width of text bounding box */
    int height;			/* Height of text bounding box */
    TextSegment textSegArr[1];	/* Information about each segment of text */
} TextExtents;

/*
 * ----------------------------------------------------------------------
 *
 * TextAttributes --
 *
 * 	Represents a convenient structure to hold text attributes
 *	which determine how a text string is to be displayed on the
 *	window, or drawn with PostScript commands.  The alternative
 *	is to pass lots of parameters to the drawing and printing
 *	routines. This seems like a more efficient and less cumbersome
 *	way of passing parameters.
 *
 * ----------------------------------------------------------------------
 */
typedef struct {
    XColor *bgColorPtr;		/* Text background color */
    XColor *fgColorPtr;		/* Text foreground color */
    double theta;		/* Rotation of text in degrees. */
    Tk_Font font;		/* Font to use to draw text */
    Tk_Justify justify;		/* Justification of the text string. This
				 * only matters if the text is composed
				 * of multiple lines. */
    Tk_Anchor anchor;		/* Indicates how the text is anchored around
				 * its x and y coordinates. */
    GC textGC;			/* GC used to draw the text */
    GC fillGC;			/* GC used to fill the background of the
				 * text. bgColorPtr must be set too. */
    Pad padX, padY;		/* # pixels padding of around text region */
    int leader;			/* # pixels spacing between lines of text */
} TextAttributes;

/*
 * -------------------------------------------------------------------
 *
 * Point2D --
 *
 *	Represents a single coordinate in 2D space.
 *
 * -------------------------------------------------------------------
 */
typedef struct {
    double x, y;
} Point2D;

/*
 * -------------------------------------------------------------------
 *
 * Point3D --
 *
 *	Represents a single coordinate in 3D space.
 *
 * -------------------------------------------------------------------
 */
typedef struct {
    double x, y, z;
} Point3D;

/*
 * -------------------------------------------------------------------
 *
 * Dimension --
 *
 *	Represents the size of a rectangle.
 *
 * -------------------------------------------------------------------
 */
typedef struct {
    int width, height;
} Dimension;

/*
 * -------------------------------------------------------------------
 *
 * ColorPair --
 *
 *	Holds a pair of foreground, background colors.
 *
 * -------------------------------------------------------------------
 */
typedef struct {
    XColor *fgColor, *bgColor;
} ColorPair;


#define COLOR_DEFAULT	(XColor *)1
#define COLOR_NONE	(XColor *)2
#define COLOR_ALLOW_DEFAULTS	1

typedef struct Rgb {
    unsigned char red, green, blue;
} RGB;

typedef union PixelColor {
    unsigned int pixel;
    RGB rgb;
} PixelColor;

#define Red  rgb.red
#define Blue  rgb.blue
#define Green  rgb.green

extern int Blt_GetColorPair _ANSI_ARGS_((Tcl_Interp *interp, Tk_Window tkwin,
	char *fgColor, char *bgColor, ColorPair * pairPtr, int colorFlag));
extern void Blt_FreeColorPair _ANSI_ARGS_((ColorPair * pairPtr));



/*
 * ----------------------------------------------------------------------
 *
 * 	X11/Xosdefs.h requires XNOSTDHDRS be set for some systems.
 *	This is a guess.  If I can't find STDC headers or unistd.h,
 *	assume that this is non-POSIX and non-STDC environment.
 *	(needed for Encore Umax 3.4 ?)
 *
 * ----------------------------------------------------------------------
 */
#if !defined(STDC_HEADERS) && !defined(HAVE_UNISTD_H)
#define XNOSTDHDRS 	1
#endif

/*
 * ----------------------------------------------------------------------
 *
 *	Assume we need to declare free if there's no stdlib.h or malloc.h
 *
 * ----------------------------------------------------------------------
 */
#if !defined(HAVE_STDLIB_H) && !defined(HAVE_MALLOC_H)
extern void free _ANSI_ARGS_((void *));
#endif

/*
 * ----------------------------------------------------------------------
 *
 *	On some systems "strdup" and "strcasecmp" are in the C library,
 *      but have no declarations in the C header files. Make sure we
 *      supply them here.
 *
 * ----------------------------------------------------------------------
 */
#ifdef NO_DECL_STRDUP
extern char *strdup _ANSI_ARGS_((CONST char *s));
#endif

#ifdef NO_DECL_STRCASECMP
extern int strcasecmp _ANSI_ARGS_((CONST char *s1, CONST char *s2));
#endif

extern GC Blt_GetPrivateGC _ANSI_ARGS_((Tk_Window tkwin, unsigned long gcMask, 
	XGCValues *valuePtr));

extern GC Blt_GetPrivateGCFromDrawable _ANSI_ARGS_((Tk_Window tkwin, 
	Drawable drawable, unsigned long gcMask, XGCValues *valuePtr));

extern void Blt_FreePrivateGC _ANSI_ARGS_((Display *display, GC gc));

extern Tk_Window Blt_FindChild _ANSI_ARGS_((Tk_Window parent, char *childName));

extern Tk_Window Blt_Toplevel _ANSI_ARGS_((Tk_Window tkwin));

extern int Blt_GetLength _ANSI_ARGS_((Tcl_Interp *interp, Tk_Window tkwin,
	char *string, int *valuePtr));

extern char *Blt_NameOfFill _ANSI_ARGS_((Fill fill));

extern int Blt_GetXYPosition _ANSI_ARGS_((Tcl_Interp *interp, Tk_Window tkwin,
	char *string, XPoint *pointPtr));

extern void Blt_AppendDoubleElement _ANSI_ARGS_((Tcl_Interp *interp, double value));

extern void Blt_AppendIntElement _ANSI_ARGS_((Tcl_Interp *interp, int value));

extern int Blt_InitCmd _ANSI_ARGS_((Tcl_Interp *interp, char *nameSpace, 
	Blt_CmdSpec *specPtr));

extern int Blt_InitCmds _ANSI_ARGS_((Tcl_Interp *interp, char *nameSpace,
	Blt_CmdSpec *specPtr, int numCmds));

extern int Blt_ConfigModified _ANSI_ARGS_(TCL_VARARGS(Tk_ConfigSpec *, specs));

extern void Blt_MakeInputOnlyWindowExist _ANSI_ARGS_((Tk_Window tkwin));

extern void Blt_GetBoundingBox _ANSI_ARGS_((int width, int height,
	double theta, int *widthPtr, int *heightPtr, XPoint *pointArr));

extern TextExtents *Blt_GetCompoundTextExtents _ANSI_ARGS_((Tk_Font font, 
	char *string, int leader, Tk_Justify justify));

extern Dimension Blt_GetTextExtents _ANSI_ARGS_((Tk_Font font, char *text, 
	int leader));

extern void Blt_SetTextAttributes _ANSI_ARGS_((TextAttributes *attrPtr,
	XColor *colorPtr, Tk_Font font, double theta, Tk_Anchor anchor,
	Tk_Justify justify));

extern void Blt_DrawText _ANSI_ARGS_((Tk_Window tkwin, Drawable draw,
	char *text, TextAttributes *attrPtr, int x, int y));

extern void Blt_DrawText2 _ANSI_ARGS_((Tk_Window tkwin, Drawable draw,
	char *text, TextAttributes *attrPtr, int x, int y, Dimension *dimPtr));

extern Pixmap Blt_CreateTextBitmap _ANSI_ARGS_((Tk_Window tkwin, char *textStr,
	TextAttributes *attrPtr, int *widthPtr, int *heightPtr, int *bmWidthPtr,
	int *bmHeightPtr));

extern void Blt_InitBitmapGC _ANSI_ARGS_((Tk_Window tkwin));

extern Pixmap Blt_RotateBitmap _ANSI_ARGS_((Display *display, Drawable draw,
	Pixmap bitmap, int width, int height, double theta, int *widthPtr, 
	int *heightPtr));

extern Pixmap Blt_ScaleBitmap _ANSI_ARGS_((Display *display, Drawable draw,
	Pixmap srcBitmap, int srcWidth, int srcHeight, int scaledWidth, 
	int scaledHeight));

extern Pixmap Blt_ScaleBitmapRegion _ANSI_ARGS_((Display *display, 
	Drawable draw, Pixmap srcBitmap, int srcWidth, int srcHeight, 
	int scaledWidth, int scaledHeight, int regionX, int regionY, 
	int regionWidth, int regionHeight));

extern Point2D Blt_TranslateBoxCoords _ANSI_ARGS_((int x, int y, int width, 
	int height, Tk_Anchor anchor));

typedef void (Blt_TileChangedProc) _ANSI_ARGS_((ClientData clientData,
	Blt_Tile tile));

extern Blt_Tile Blt_GetTile _ANSI_ARGS_((Tcl_Interp *interp, Tk_Window tkwin,
	char *imageName));

extern void Blt_FreeTile _ANSI_ARGS_((Blt_Tile tile));

extern char *Blt_NameOfTile _ANSI_ARGS_((Blt_Tile tile));

extern void Blt_SetTileChangedProc _ANSI_ARGS_((Blt_Tile tile,
	Blt_TileChangedProc * changeProc, ClientData clientData));

extern Pixmap Blt_PixmapOfTile _ANSI_ARGS_((Blt_Tile tile));

extern void Blt_SizeOfTile _ANSI_ARGS_((Blt_Tile tile, int *widthPtr,
	int *heightPtr));

extern void Blt_SetTileOrigin _ANSI_ARGS_((Tk_Window tkwin, GC gc, int x,
	int y));

extern int Blt_SnapPhoto _ANSI_ARGS_((Tcl_Interp *interp, Tk_Window tkwin,
	Drawable drawable, int width, int height, char *imageName));

extern int Blt_ConfigureWidgetComponent _ANSI_ARGS_((Tcl_Interp *interp, 
	Tk_Window tkwin, char *name, char *class, Tk_ConfigSpec *specs, 
	int argc, char **argv, char *widgRec, int flags));

extern int Blt_ImageDeleted _ANSI_ARGS_((Tk_Image image));
extern Tk_ImageMaster Blt_ImageMaster _ANSI_ARGS_((Tk_Image image));

extern int Blt_GetSnapshot _ANSI_ARGS_((Tk_Window tkwin, Drawable drawable, 
	int width, int height, Tcl_HashTable *colorTablePtr, 
	XColor **colorPtrPtr, unsigned long **dataPtrPtr));

extern void Blt_HSV _ANSI_ARGS_((XColor *colorPtr, double *huePtr, double *valPtr, 
	double *satPtr));

extern void Blt_RGB _ANSI_ARGS_((double hue, double sat, double val, 
	XColor *colorPtr));

extern int Blt_NaturalSpline _ANSI_ARGS_((double *xCntl, double *yCtrl, 
	int numCtrls, double *X, double *Y, int numPoints));

extern int Blt_QuadraticSpline _ANSI_ARGS_((double *xCntl, double *yCtrl, 
	int numCtrls, double *X, double *Y, int numPoints, double epsilon));

extern int Blt_FlagParse _ANSI_ARGS_((ClientData, Tcl_Interp *, Tk_Window,
	char *, char *, int));
extern char *Blt_FlagPrint _ANSI_ARGS_((ClientData, Tk_Window, char *, int,
	Tcl_FreeProc **));

extern int Blt_SnapPhoto _ANSI_ARGS_((Tcl_Interp *interp, Tk_Window tkwin, 
	Drawable drawable, int width, int height, char *photoName));

extern Window Blt_XWindowId _ANSI_ARGS_((Tk_Window tkwin));

extern void panic _ANSI_ARGS_(VARARGS(char *fmt));

/* 
 * Define this if you want to be able to tile to the main window "."
 * This will cause a conflict with Tk if you try to compile and link
 * with both libraries statically.  
 */
#undef TILE_MAINWINDOW	

extern Tcl_AppInitProc Blt_HtextInit;
extern Tcl_AppInitProc Blt_GraphInit;
extern Tcl_AppInitProc Blt_TableInit;
extern Tcl_AppInitProc Blt_BusyInit;
extern Tcl_AppInitProc Blt_WinOpInit;
extern Tcl_AppInitProc Blt_BitmapInit;
extern Tcl_AppInitProc Blt_BgExecInit;
extern Tcl_AppInitProc Blt_DragDropInit;
extern Tcl_AppInitProc Blt_DebugInit;
extern Tcl_AppInitProc Blt_WatchInit;
extern Tcl_AppInitProc Blt_VectorInit;
extern Tcl_AppInitProc Blt_SplineInit;
extern Tcl_AppInitProc Blt_BellInit;
extern Tcl_AppInitProc Blt_CutbufferInit;
extern Tcl_AppInitProc Blt_FrameInit;
extern Tcl_AppInitProc Blt_ButtonInit;
extern Tcl_AppInitProc Blt_ScrollbarInit;
#ifndef NO_TED
extern Tcl_AppInitProc Blt_TedInit;
#endif

/* Disable features all features except for the busy command */
#define NO_HTEXT
#define NO_GRAPH
#define NO_TABLE
#define NO_WINOP
#define NO_BITMAP
#define NO_BGEXEC
#define NO_DRAGDROP
#define NO_DEBUG
#define NO_WATCH
#define NO_VECTOR
#define NO_SPLINE
#define NO_BELL
#define NO_CUTBUFFER
#define NO_TILEFRAME
#define NO_TILEBUTTON
#define NO_TILESCROLLBAR

#endif /*_BLT_INT_H*/
