# stview.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.

proc stView {w} {
    browser $w
    brSetupOutlineLevel $w 0 stOpenFile stHelp 10
}

proc stExpandHdr {w cur file} {
    global pattern content options
    if {!$options(case)} {
	set switches -nocase
    }
    if {$options(regexp)} {
	lappend switches -regexp
    }
    lappend switches --
    regsub -all {\.|\*|\?|\[|\\} "$file" {\\&} file
    set index [eval glob -nocomplain {$file}]
    regsub -all {\{|\}} "$index" {} index
    if {$index != ""} {
	brExpandHeading $w 0 $cur $content($index) $file    
	eval brHighlightText $w $file \{$pattern\} $switches
    } else {
	xtk_dialog .warning {Warning...} \
	    "The file \"$file\" cannot be located. \
             Either the file has been deleted or the \
             working directory has changed since \
             the last search request. This entry will \
             now be purged from the browser." \
	    warning 0 Ok
	brDeleteHeading $w 0 $cur
    }
}

proc stContractHdr {w cur file} {
    brContractHeading $w $cur $file
}

proc stOpenFile {w filename line} {
    global cwd options
    set line [split $line :]
    set lineno [lindex $line 0]
    if {$options(editor) == "emacs"} {
	if [gnuExec "(progn (find-file-other-window \"$cwd/$filename\") \
                            (goto-line $lineno))"] {
	    printStatus .status "Gnu server not active"
	    return
	}
    } else {
	regsub -all {\.|\*|\?|\[|\\} "$filename" {\\&} filename
	set filename [eval glob {$filename}]
	regsub -all {\{|\}} "$filename" {} filename
	set cmdcode [exec xterm -e vi +[string trim $lineno] $filename &]
    }
    printStatus .status "File $filename loaded"
}

proc stHelp {w} {
    printStatus .status "Press Button-2 to view selected text"
}
