# sttags.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

set ffeed    \014
set delim    \177
set ident    "\[A-Za-z0-9_]"
set wspace   "\[ ();,\t]"
set digit    "\[0-9]"
set match    "($ident*$wspace)*($ident+)$wspace*\\(?$delim\($digit+),($digit+)"

proc createTags {} {
    global cwd path 

    set ctrlEnt [ctGetEntries .control]
    set path    [lindex $ctrlEnt 1]
    set inlist  [split $path :]
    foreach p $inlist {
	set apath [string trim $p]
        if ![file isdirectory $apath] {
	    set apath [eval file dirname {$cwd/$apath}]
	}
	append apath "/*.\[ch]"
	if [catch {set glpath [eval glob {$apath}] }] {
	    continue
	}
	append pathlist $glpath " "
    }
    if [info exists pathlist] {
	disableInputs
	eval exec etags $pathlist
	set fd [open header w]
	puts $fd $path
	close $fd
	exec cat header TAGS > .stxrf
	exec rm -f header TAGS
	parseTags .stxrf
	ctUpdateHistory .control
	enableInputs
    } else {
	printStatus .status "No C files selected for path: $path"
    }
}

proc openTags {} {
    fileDialog . open filename
    if [info exists filename] {
	disableInputs
	parseTags $filename
	enableInputs
    }
}

proc setupTagsTable {} {
    if [file exists .stxrf] {
	disableInputs
	parseTags .stxrf 0
	umSetMenuState .menu 1 6 normal
	enableInputs
    } else {
        umSetMenuState .menu 1 6 disabled
        umSetMenuState .menu 1 7 disabled
    }
}

proc showFiles {} {
    global symbol
    
    disableInputs
    brClear .browser
    brSetupOutlineLevel .browser 0 stOpenFile stHelp 10
    update
    foreach file [lsort [array names symbol]] {
	global homePath cwd
	regsub $homePath $file ~ file
	regsub "$cwd/" $file "" file
	brAddHeading .browser 0 $file stgFileExpandHdr stContractHdr \
		-foreground slateblue -activeforeground cadetblue
    }
    umClearHistoryIndicator .menu 2
    umSetMenuState .menu 1 6 disabled
    umSetMenuState .menu 1 7 normal
    enableInputs
}

proc showFuncs {} {
    global function 

    disableInputs
    brClear .browser
    brSetupOutlineLevel .browser 0 stgOpenFile stHelp 10
    update
    foreach func [lsort [array names function]] {
	brAddHeading .browser 0 $func stgFuncExpandHdr stContractHdr \
		-foreground slateblue -activeforeground cadetblue
    }
    umClearHistoryIndicator .menu 2
    umSetMenuState .menu 1 6 normal
    umSetMenuState .menu 1 7 disabled
    enableInputs
}

proc parseTags {{tagFile TAGS} {show 1}} {
    global symbol function digit ffeed match cwd homePath cwd
    set filename ""

    catch {unset symbol}
    catch {unset function}
    brClear .browser
    printStatus .status "Reading crossref file..."
    set fd [open $tagFile r]
    while {[gets $fd line] >= 0} {
	if {$filename!="" || ![regexp "(.*),$digit+" $line dummy filename]} {
	    regsub $homePath $filename ~ filename
	    regsub "$cwd/" $filename "" filename
	    if [regexp $match $line dummy type func linenum offset] {
		append symbol($filename) [format "%8d: %s\n" $linenum $func]
		append function($func) [format "%8d: %s\n" $linenum $filename]
	    }
	    if [regexp "$ffeed" $line] {
		set filename ""
	    }
	}
    }
    if {$show} {
	showFiles
    }
    if [array size function] {
	umSetMenuState .menu 1 6 disabled
	umSetMenuState .menu 1 7 normal
	printStatus .status "Done."
    } else {
	umSetMenuState $ctMenu 1 6 disabled
	umSetMenuState $ctMenu 1 7 disabled
	printStatus .status "Invalid Tag file."
    }
}

proc fileDialog {w op ent} {
    upvar $ent fileEnt
    set types {
	{"All files"		*}
	{"C Source Files"	{.c .h}}
    }
    if {$op == "open"} {
	set file [tk_getOpenFile -filetypes $types -parent $w]
    } else {
	set file [tk_getSaveFile -filetypes $types -parent $w \
	    -initialfile Untitled -defaultextension .txt]
    }
    if [string compare $file ""] {
	set fileEnt $file
    }
}

proc stgFileExpandHdr {w cur file} {
    global symbol cwd
    brExpandHeading $w 0 $cur $symbol($file) $file
    brHighlightText $w $file {[^0-9:]+} -regexp
}

proc stgFuncExpandHdr {w cur func} {
    global function
    brExpandHeading $w 0 $cur $function($func) $func
    brHighlightText $w $func {[^0-9:]+} -regexp
}

proc stgOpenFile {w function line} {
    global cwd options
    set line [split $line :]
    set lineno [lindex $line 0]
    set filename [string trim [lindex $line 1]]
    if {$options(editor) == "emacs"} {
	if [gnuExec "(progn (find-file-other-window \"$cwd/$filename\") \
                            (goto-line $lineno))"] {
	    printStatus .status "Gnu server not active"
	    return
	}
    } else {
	set cmdcode [exec xterm -e vi +[string trim $lineno] $filename &]
    }
    printStatus .status "File $filename loaded"    
}
