# stchange.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc replace {} {
    global replace pattern options content
    if {[udialog .replace "Replace" \
	     setupReplaceDialog procReplaceDialog {} 0 Ok Cancel] != 0} {
	return
    }	
    if {$replace == ""} {
	if [xtk_dialog .msg {Warning} \
		"Do you want to delete all references of $pattern?" \
		warning 0 Ok Cancel] {
	    return
	}
    }

    disableInputs
    set pathlist [array names content]
    if {$pathlist != ""} {
	printStatus .status "Replacing $pattern with $replace ..."
	regsub -all {\\|\&} "$pattern" {\\&} rpattern
	if {$options(editor) == "emacs" && $options(query)} {
	    set retc [queryReplace $rpattern $pathlist $replace]
	} else {
	    set retc [sedReplace $rpattern $pathlist $replace]
	}
        if {$retc == 0} {
	    printStatus .status "Done."
        }
    }
    enableInputs
}

proc setupReplaceOptions {w} {
    global options
    set mstate normal
    if {!$options(regexp)} {
	set options(metac) 0
	set mstate disabled
    }
    $w.optgrp.metac configure -variable options(metac) -state $mstate
}

proc setupReplaceDialog {w fscpt} {
    upvar $fscpt s
    global options savOptions replaceHistory query
    foreach i [array names options] {
	set savOptions($i) $options($i)
    }
    frame $w.replace 
    comboBox $w.pattern -labelOpt {-text "Replace pattern: "}
    cbConfigLabel $w.pattern -width 13
    if [info exists replaceHistory] {
	cbSetHistoryList $w.pattern $replaceHistory
    }
    cbSetEntry $w.pattern ""
    groupbox $w.optgrp "Options"
    checkbutton $w.optgrp.newfiles -text "Write changes to new files" \
	-variable options(newfiles)
    checkbutton $w.optgrp.words -text "Replace words only" \
	-variable options(words)
    checkbutton $w.optgrp.query -text "Interactive"
    checkbutton $w.optgrp.metac -text "Use replace metacharacters"
    if {$options(editor) == "emacs"} {
	$w.optgrp.query configure -variable options(query)
    } else {
	$w.optgrp.query configure -variable null -state disabled
    }
    setupReplaceOptions $w
    grid $w.optgrp.newfiles -row 0 -column 0 -sticky sw
    grid $w.optgrp.words -row 0 -column 1 -sticky sw
    grid $w.optgrp.query -row 1 -column 0 -sticky sw
    grid $w.optgrp.metac -row 1 -column 1 -sticky sw
    grid columnconfigure $w.optgrp 0 -weight 1 
    grid columnconfigure $w.optgrp 1 -weight 1
    grid rowconfigure $w.optgrp 0 -pad 4
    pack $w.pattern $w.optgrp -in $w.replace -fill both -expand true \
	-padx 2m -pady 3m
    set s "cbSetFocus $w.pattern"
    return $w.replace
}

proc procReplaceDialog {w retval} {
    global replace replaceHistory
    set replace ""
    if {$retval == 0} {
	global replaceHistory
	cbAddEntry $w.pattern
	set replaceHistory [cbGetHistoryList $w.pattern]
	set replace [cbGetEntry $w.pattern]
    } elseif {$retval == 1} {
	global options savOptions
	foreach i [array names savOptions] {
	    set options($i) $savOptions($i) 
	}
    } 
    return 0
}

proc createCheckDirectory {name} {
    set base $name
    set dir  $base
    set i 1
    while {[file exists $dir] && ![file isdirectory $dir]} {
	set dir "$base.$i"
	incr i
    }
    catch {exec mkdir $dir}
    return $dir
}

proc getUniqFile {dir name} {
    set i 1
    set ufile [file tail $name]
    while [file exists $dir/$ufile] {
	set ufile "$ufile.$i"
	incr i
    }
    return $ufile
}

proc queryReplace {pattern pathlist replace} {
    global options cwd
    set newlist ""
    set w "nil"
    set s "(save-buffer)"
    set q "query-replace"
    if {$options(words)} {
	set w "t"
    }
    if {$options(newfiles)} {
	set dirname [createCheckDirectory "replace.new"]
    }
    if {$options(regexp)} {
	set q "query-replace-regexp"
    }
    if {$options(metac)} {
	regsub -all {\\|\&} "$replace" {\\\\&} replace
    }
    if {$options(newfiles)} {
	set s "(write-file (car y))"
    }
    foreach file $pathlist {
	append filelist "\"$cwd/$file\"" " "
	if {$options(newfiles)} {
	    set newfile [getUniqFile $dirname $file]
	    append newlist "\"$cwd/$dirname/$newfile\"" " "
	}
    }
    if [gnuExec \
	    "(progn \
                 (setq x '($filelist)) \
		 (setq y '($newlist)) \
		 (while (not (null x)) \
		        (find-file-other-window (car x)) \
                             (if (equal \
                                 ($q \"$pattern\" \"$replace\" $w) \
                                 \"Done\") \
                                 $s)
                        (setq x (cdr x)) \
                        (setq y (cdr y))))"] {
	printStatus .status "Gnu server not active"
        return -1
    }
    wm iconify .
    update idletasks
    return 0
}

proc sedReplace {pattern pathlist replace} {
    global options
    if {!$options(regexp)} {
	regsub -all {\*|\+|\?|\||\(|\)|\.|\^|\$|\[|\]|\{|\}|\\} \
			"$pattern" {\\&} pattern
    }
    if {!$options(metac)} {
	regsub -all {\\|\&} "$replace" {\\&} replace
    }
    if {$options(words)} {
	set pattern "\\<$pattern\\>"
    }
    set dirname [createCheckDirectory "replace.new"]
    foreach file $pathlist {
	set file [eval glob {$file}]
	set newfile [getUniqFile $dirname $file]
	exec sed -e s/$pattern/$replace/g $file > $dirname/$newfile
	if {!$options(newfiles)} {
	    exec cp -p $file $file~
	    exec mv -f $dirname/$newfile $file
	}
    }
    catch {exec rmdir $dirname}
    return 0
}
