# stpref.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.

proc setupPrefDialog {w fscpt} {
    global options savOptions cwd cwdHistory
    foreach i [array names options] {
	set savOptions($i) $options($i)
    }
    frame $w.options
    comboBox $w.path -labelOpt {-text "Current Directory: "} \
	             -browse prefBrowseDirectory
    cbConfigLabel $w.path -width 14
    cbSetEntry $w.path $cwd
    if [info exists cwdHistory] {
	cbSetHistoryList $w.path $cwdHistory
    } else {
	cbAddEntry $w.path
    }
    groupbox $w.edtgrp "Editor"
    radiobutton $w.edtgrp.vi -text "Vi" \
	-variable options(editor) -value "vi"
    radiobutton $w.edtgrp.emacs -text "Emacs/Gnu server" \
	-variable options(editor) -value "emacs"
    pack $w.edtgrp.emacs $w.edtgrp.vi -side bottom -anchor w
    groupbox $w.optgrp "Search Options"
    checkbutton $w.optgrp.case -text "Case sensitive" -variable options(case)
    checkbutton $w.optgrp.regexp -text "Regexp" -variable options(regexp)
    checkbutton $w.optgrp.backup -text "Exclude backup files" \
	-variable options(nobackup)
    pack $w.optgrp.backup $w.optgrp.regexp $w.optgrp.case \
	-side bottom -anchor w
    pack $w.path $w.edtgrp $w.optgrp -in $w.options -fill both \
	-expand true -padx 2m -pady 3m
    return $w.options
}

proc savPrefOptions {} {
    global options rcFile
    set rcfd [open $rcFile w+]
    foreach i [array name options] {
	puts $rcfd "set options($i) $options($i)"	
    }
    ctWriteData .control $rcfd
    close $rcfd
}

proc procPrefDialog {w retval} {
    if {$retval == 0} {
	set newPath [string trim [cbGetEntry $w.path]]
	if [file isdirectory $newPath] {
	    global homePath cwd cwdHistory prefChg
            if {$cwd != $newPath} {
	        set cwd $newPath
	        cbAddEntry $w.path
	        set cwdHistory [cbGetHistoryList $w.path]
                cd $cwd
                setCwd
	        ctUpdateOptionBox .control
            }
	} else {
	    xtk_dialog $w.msg {Error} \
		"Searchtool can not access the path $newPath.\
                 Please check typing before continuing." error 0 OK
	    return -1
	}
	savPrefOptions
    } elseif {$retval == 1} {
	global options savOptions
	foreach i [array names savOptions] {
	    set options($i) $savOptions($i) 
	}
    }
    return 0
}


proc prefBrowseDirectory {entry} {
    set types {
        {"All files"            *}
        {"Text files"           {.txt .doc}     }
        {"C Source Files"       {.c .h}         }
        {"Tcl Scripts"          {.tcl}          TEXT}
    }
    set file [tk_getOpenFile -filetypes $types -parent $entry -title Browse]
    $entry delete 0 end

    global homePath
    regsub $homePath $file ~ file
    $entry insert end $file
    $entry xview end
    ctUpdateWidgetState .control
}
