# stinit.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.

#
# Procedure
#
proc setCwd {} {
    global homePath cwd
    regsub $homePath [pwd] ~ cwd
    wm title . "searchtool - $cwd"
}

#
# Deafult global values
#
set rev_string            "Version 1.1 \[Unregistered\]"
set homePath              $env(HOME)
set rcFile                "$homePath/.searchtool"
set pattern               ""
set path                  ""
set subdir                -1
set curdir                ""
set toolbar               1
set statusbar             1
set options(case)         1
set options(regexp)       0
set options(nobackup)     1
set options(subdir)       0
set options(editor)       "emacs"
set options(metac)        0
set options(newfiles)     1
set options(words)        0
set options(query)        0
set options(toolbar)      1
set options(statusbar)    1
set TRANSPARENT_GIF_COLOR [. cget -background]
setCwd

#
# Source values from last session
#
catch { source $rcFile }

#
# Persistent options
# 
set options(rescan)   1

#
# Setup Window manager option
#
wm minsize    . 60 5
wm protocol   . WM_DELETE_WINDOW {exitApp}
wm iconbitmap . @$imgPath/searchtool.xbm

#
# Application options
#
option add *Checkbutton.selectColor yellow
option add *Checkbutton.Font        $stFont
option add *Radiobutton.selectColor yellow
option add *Radiobutton.Font        $stFont
