# sthelp.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc setupHelp {w fscpt} {
    global st_library
    frame $w.help -relief raised -bd 1
    scrollbar $w.help.sb -orient vertical -width 12 -takefocus 0 \
	-command "$w.help.text yview"
    text $w.help.text -wrap word -setgrid 1 -cursor {}  \
	-spacing1 1 -spacing2 1 -yscrollcommand "$w.help.sb set" \
	-font -*-Helvetica-Medium-R-Normal--*-140-*-*-*-*-*-*
    $w.help.text tag configure margins -lmargin1 12m -lmargin2 6m \
	-rmargin 10m
    set f [open $st_library/doc/UserGuide]
    while {![eof $f]} {
        $w.help.text insert end [read $f 10000]
    }
    close $f
    $w.help.text configure -state disabled
    pack $w.help.sb -side right -fill y -in $w.help
    pack $w.help.text -in $w.help -fill both -expand y

    return $w.help
}

proc procDefault {w retval} {
    return 0
}
