# stgrep.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc formatMenuString {pattern path pid} {
    return [format "%-.8s \# %-.20s\t\[%d\]" $pattern $path $pid]
}

proc getMenuString {pattern path} {
    global stProcId
    set idx [list $pattern $path]
    return [formatMenuString $pattern $path $stProcId($idx)]
}

proc createMenuString {mstr pattern path pid} {
    upvar $mstr menuStr
    global stProcId
    set idx [list $pattern $path]
    set oldMenuStr ""
    if [info exists stProcId($idx)] {
	set oldMenuStr [getMenuString $pattern $path]
    }
    set stProcId($idx) $pid
    set menuStr [formatMenuString $pattern $path $pid]
    return $oldMenuStr
}

proc checkQueryHistory {cbPattern cbPath} {
    global pattern path
    if {$cbPattern != $pattern || $cbPath != $path} {
	set idx [list $cbPattern $cbPath]
	global stHistory$idx
	if {[array size stHistory$idx] != 0} {
	    printStatus .status \
		"Cached output available: select\
                     '[getMenuString $cbPattern $cbPath]' from Enquiries menu"
	}
    }
}

proc updateMenuState {label} {
    global historyPos
    set curPos [umGetMenuPos .menu 2 $label]
    set endPos [umGetMenuPos .menu 2 end]
    if {[expr $curPos-$historyPos] == 0} {
	set prevState disabled
    } else {
	set prevState normal
    }
    if {[expr $endPos-$curPos] == 0} {
	set nextState disabled
    } else {
	set nextState normal
    }
    umSetMenuState .menu 2 0 $prevState
    umSetMenuState .menu 2 1 $nextState
    ctSetCacheState .control $prevState $nextState
}

proc getCurrentQuery {pattern path} {
    return [umGetMenuPos .menu 2 [getMenuString $pattern $path]]
}

proc showPrevious {} {
    global pattern path
    set prev [expr [getCurrentQuery $pattern $path]-1]
    umInvokeMenu .menu 2 $prev
}

proc showNext {} {
    global pattern path
    set next [expr [getCurrentQuery $pattern $path]+1]
    umInvokeMenu .menu 2 $next
}

proc search {} {
    disableInputs
    send -async grepserv { search }
}

proc stop {} {
    global servId st_home grepserv
    exec kill $servId
    printStatus .status "Search Cancelled."
    after 250 ;# small delay for the kill to take affect
    set servId [exec $st_home/$grepserv [winfo name .] &]
    enableInputs
    ctSetStopState .control disabled
}

proc searchCallback {input pid} {
    if {$pid < 0} {
	set ctrlEnt [ctGetEntries .control]
	set pattern [lindex $ctrlEnt 0]
	if {$pid == -2} {
	    printStatus .status "Pattern not found: \"$pattern\""
	}
	umClearHistoryIndicator .menu 2
	umSetMenuState .menu 2 0 disabled
	umSetMenuState .menu 2 1 disabled
	ctSetCacheState .control disabled disabled
	ctSetReplaceState .control disabled
	exec rm -f $input
	enableInputs
	return
    } 

    global content homePath pathlist pattern path options
    catch {unset content}
    brClear .browser
    brSetupOutlineLevel .browser 0 stOpenFile stHelp 10
    update
    set lastfile ""
    set fd [open $input r]
    while {[gets $fd line] >= 0} {
	if {[llength $pathlist] > 1} {
	    regexp {([^:]+):([0-9]+):(.*)} $line dummy filename linenum match
	} else {
	    regexp {([0-9]+):(.*)} $line dummy linenum match
	    set filename [lindex $pathlist 0]
	}
	if {$filename != $lastfile} {
	    set lastfile $filename
	    regsub $homePath $filename ~ file
	    brAddHeading .browser 0 $file stExpandHdr stContractHdr \
		-foreground slateblue -activeforeground cadetblue
	}
	append content($filename) [format "%8d: %s\n" $linenum $match]
    }

    saveBrowserOutputs $pattern $path $pid
    set options(rescan) 0
    ctSetReplaceState .control normal
    umSetMenuState .menu 1 3 normal
    umSetMenuState .menu 1 4 normal
    
    global function
    if [array size function] {
	umSetMenuState .menu 1 6 normal
	umSetMenuState .menu 1 7 normal
    }
    catch {close $fd}
    exec rm -f $input
    enableInputs
    printStatus .status "Done."
}

proc saveBrowserOutputs {pattern path pid} {
    set idx [list $pattern $path]
    global stHistory$idx content
    if {[array size content] != 0} {
        set stHistorySize [array size stHistory$idx]
	set oldMenuStr [createMenuString menuStr $pattern $path $pid]
	if {$stHistorySize != 0} {
	    umDeleteHistory .menu 2 $oldMenuStr
	    unset stHistory$idx
	}
	array set stHistory$idx [array get content]
	ctUpdateHistory .control
	umAddHistory .menu 2 $menuStr "showHistory {$pattern} {$path}"
    }
    updateMenuState [getMenuString $pattern $path]
}

proc showHistory {ppattern ppath} {
    set idx [list $ppattern $ppath]
    global content stHistory$idx homePath pattern path

    set pattern $ppattern
    set path $ppath
    catch {unset content}
    brClear .browser    
    array set content [array get stHistory$idx]
    set revrNames {}
    foreach filename [array names content] { 
	set revrNames [concat $filename $revrNames]
    }
    set revrNames [lsort $revrNames]
    foreach filename $revrNames {
	regsub $homePath $filename ~ filename
	brAddHeading .browser 0 $filename stExpandHdr stContractHdr \
	    -foreground slateblue -activeforeground cadetblue
	regsub -all {\.|\*|\?|\[|\\} "$filename" {\\&} filename
	if {[eval glob -nocomplain {$filename}] == ""} {
	    brDeleteHeading .browser 0 [expr [brGetCurLine .browser]-1].0
	}
    }
    ctUpdateEntries .control
    updateMenuState [getMenuString $pattern $path]
    global function
    if [array size function] {
	umSetMenuState .menu 1 6 normal
	umSetMenuState .menu 1 7 normal
    }
}
