# utils.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc capitalise {str} {
    set newStr ""
    foreach word $str {
	set char [string range $word 0 0]
	set capChar [string toupper $char]
	append newStr $capChar [string range $word 1 end] " "
    }
    return $newStr
}

proc getOptions {options args} {
    foreach optName $options {
	upvar $optName opt
	set opt ""
	set lidx [eval lsearch $args $optName]	
	if {$lidx != -1} {
	    set opt [eval lindex $args [expr $lidx+1]]
	}
    }
}

proc getDupString {a b} {
    global lGetDupString
    set retCode [string compare $a $b]
    if {!$retCode} {
	lappend lGetDupString $a
    }
    return $retCode
}

proc removeDuplicate {list} {
    global lGetDupString
    set lGetDupString {}
    set list [lsort -command getDupString $list]
    foreach i $lGetDupString {
	set dup [lsearch $list $i]
	set list [lreplace $list $dup $dup]
    }
    return $list
}

proc fatal {msg} {
    puts stderr $msg
    exit
}

