# umenu.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc umenu {w args} {
    frame $w -relief raised -borderwidth 2
    set menuCount 0
    foreach menuButton $args {
	set menuHdr [lindex $menuButton 0]
	set menuPos [lindex $menuButton 1]
	eval menubutton $w.menu$menuCount $menuHdr \
	    -menu $w.menu$menuCount.m
	menu $w.menu$menuCount.m -tearoff 0
	set menuList [lrange $menuButton 2 end]
	foreach menuOption $menuList {
	    eval $w.menu$menuCount.m add $menuOption
	}
	pack $w.menu$menuCount -side $menuPos
	incr menuCount
    }
}

proc umSetMenuState {w menuIdx menuPos state} {
    $w.menu$menuIdx.m entryconfigure $menuPos -state $state
}

proc umGetMenuState {w menuIdx menuPos} {
    return [$w.menu$menuIdx.m entrycget $menuPos -state]
}

proc umAddHistory {w menuIdx label command} {
    global umHistory umHistorySelect umHistoryLastSelect
    if ![info exists umHistory($menuIdx)] {
	set umHistory($menuIdx) [$w.menu$menuIdx.m index end] 
	incr umHistory($menuIdx)
	$w.menu$menuIdx.m insert $umHistory($menuIdx) separator
	incr umHistory($menuIdx)
	set umHistoryLastSelect ""
    }
    $w.menu$menuIdx.m activate none
    $w.menu$menuIdx.m insert $umHistory($menuIdx) radiobutton \
	-variable umHistorySelect -value $label -label $label \
	-command "umAdjustSelFlag $w $menuIdx {$label} ; $command" \
	-selectcolor yellow
    set umHistorySelect $label
    umAdjustSelFlag $w $menuIdx
}

proc umDeleteHistory {w menuIdx label} {
    global umHistoryLastSelect
    if {$umHistoryLastSelect == $label} {
	set umHistoryLastSelect ""
    }
    regsub -all {\.|\*|\?|\[|\\} "$label" {\\&} label
    $w.menu$menuIdx.m delete $label
}

proc umGetMenuPos {w menuIdx label} {
    regsub -all {\.|\*|\?|\[|\\} "$label" {\\&} label
    return [$w.menu$menuIdx.m index $label]
}

proc umInvokeMenu {w menuIdx index} {
    return [$w.menu$menuIdx.m invoke $index]
}

proc umAdjustSelFlag {w menuIdx {active ""}} {
    global umHistory umHistorySelect umHistoryLastSelect
    set historyBegin $umHistory($menuIdx)
    set historyEnd [$w.menu$menuIdx.m index end]
    if {$active == ""} {
	set active $umHistory($menuIdx)
    } else {
	regsub -all {\.|\*|\?|\[|\\} "$active" {\\&} active
	set active [$w.menu$menuIdx.m index $active]
    }
    if {$umHistoryLastSelect != ""} {
	regsub -all {\.|\*|\?|\[|\\} "$umHistoryLastSelect" {\\&} mlabel
	set lastActive [$w.menu$menuIdx.m index $mlabel]
	$w.menu$menuIdx.m entryconfigure $lastActive -indicatoron 0
	$w.menu$menuIdx.m entryconfigure $lastActive -state normal
    }
    $w.menu$menuIdx.m entryconfigure $active -indicatoron 1
    $w.menu$menuIdx.m entryconfigure $active -state disabled
    set umHistoryLastSelect $umHistorySelect
}

proc umClearHistoryIndicator {w menuIdx} {
    catch {
        global umHistorySelect
	if {$umHistorySelect != ""} {
	    regsub -all {\.|\*|\?|\[|\\} "$umHistorySelect" {\\&} mlabel
	    set active [$w.menu$menuIdx.m index $mlabel]
	    $w.menu$menuIdx.m entryconfigure $active -state normal
	    set umHistorySelect ""
	}
    }
}

proc umToggleIndicatorFlag {w menuIdx label} {
    set menuPos [$w.menu$menuIdx.m index $label]
    set state [expr ![$w.menu$menuIdx.m entrycget $menuPos -indicatoron]]
    $w.menu$menuIdx.m entryconfigure $menuPos -indicatoron $state
    return $state
}
