# status.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc status {w} {
    global $w stFont sbBlob
    set $w ""
    frame $w -relief raised -bd 1 -class StatusBar
    label $w.mesg -font $stFont -justify left -textvariable $w -anchor w
    canvas $w.progress -relief sunken -borderwidth 2 -height 6 -width 150
    set sbBlob($w) [$w.progress create rectangle 5 5 50 12 -fill blue \
			-outline blue]
    pack $w.mesg -side left -expand yes -fill both
}

proc printStatus {w {msg ""}} {
    global $w stLastTimer
    set $w $msg
    update
    catch { after cancel $stLastTimer }
    set stLastTimer [after 5000 "set $w \"\" ; unset stLastTimer"]
}

proc printStatusHelp {w {msg ""}} {
    global $w stLastTimer
    if {![info exists stLastTimer]} {
       set $w $msg
    }
    update
}

proc sbInProgress {w} {
    global sbBlob sbPos sbPhase sbStop
    $w.progress coords $sbBlob($w) \
	[expr 5+$sbPos($w)] 5 [expr 50+$sbPos($w)] 12
    if {$sbPos($w) > 95} {
	set sbPhase($w) 0
    } elseif {$sbPos($w) < 5} {
	set sbPhase($w) 1
    }
    if {$sbPhase($w) == 0} {
	set sbPos($w) [expr $sbPos($w)-5]
    } else {
	set sbPos($w) [expr $sbPos($w)+5]
    }
    if {!$sbStop($w)} {
	after 100 "sbInProgress $w"
    }
}

proc sbShowProgress {w state} {
    global sbBlob sbPos sbPhase sbStop
    if {$state} {
	set sbPhase($w) 1
	set sbPos($w) 5
	set sbStop($w) 0
	pack $w.progress -side left -ipady 2 -padx 5
	after 100 "sbInProgress $w"
    } else {
	set sbStop($w) 1
	pack forget $w.progress
    }
}
