# optbox.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc optionBox {w {args}} {
    global options
    getOptions {-command} $args
    frame $w -relief groove -borderwidth 2 -class OptionBox
    checkbutton $w.subdir -text "Search subdirs" -anchor w \
	-variable options(subdir) -command ${-command} 
    checkbutton $w.rescan -text "Rescan path" -anchor w -state disabled \
	-variable options(rescan)
    pack $w.subdir $w.rescan -side top -expand yes -fill x -in $w
}

proc obEblRescanButton {w state} {
    $w.rescan configure -state $state
}

