# navbar.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc navBar {w {args ""}} {
    eval frame $w -class Navbar -relief raised -bd 1
    foreach nb $args {
	set nb [string trim $nb]
	eval button $w.$nb -state disabled \
	    -command { $nb } -text [capitalise $nb]
	pack $w.$nb -side left -in $w
    }
}

proc nbConfigure {w nb {args ""}} {
    eval $w.$nb configure $args
}

proc nbSetButtonState {w nb state} {
    $w.$nb configure -state $state
}

proc nbGetButtonState {w nb} {
    return [lindex [$w.$nb configure -state] end]
}

proc nbSetHelpText {w nb status help} {
    global nbHelp nbStatus
    set nbHelp($w.$nb)   $help
    set nbStatus($w.$nb) $status
    set_balloon $w.$nb $help
#    bind $w.$nb <Enter> { printStatusHelp $nbStatus(%W) $nbHelp(%W) }
#    bind $w.$nb <Leave> { printStatusHelp $nbStatus(%W) }
#    bindtags $w.$nb "Button $w.$nb . all"
}
