# groupbox.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc groupbox {w {title ""}} {
    global gbId gbFont
    frame $w -relief groove -borderwidth 2 -class Groupbox
    set parent [winfo parent $w]
    frame $parent.grp$gbId
    pack $w -in $parent.grp$gbId -fill both -expand yes \
	-padx 2m -pady 3m -ipady 1.5m
    if {$title != ""} {
	label $parent.title$gbId -text $title -font $gbFont
	place $parent.title$gbId -in $w -x 5 -y -10 -anchor nw \
	    -bordermode outside
    }
    incr gbId
}
