# control.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc control {w args} {
    global ctMenu ctUpdateProc options
    set entStyle  "-side top -anchor nw -fill x -expand yes -pady 3"
    getOptions {-menu -updateProc} $args
    if {${-menu} == ""} {
	error "wrong \# args: should be \"control pathName\
                    -menu menuName -updateProc procName \""
    }
    set ctMenu ${-menu}
    set ctUpdateProc ${-updateProc}
    frame $w
    ctSetupToolbar $w

    frame $w.ufield -relief raised -bd 1
    frame $w.ufield.ipt
    comboBox $w.ufield.ipt.pattern -labelOpt {-text "Pattern: "}
    comboBox $w.ufield.ipt.path -labelOpt {-text "Path: "} \
	-browse ctBrowseDirectory
    optionBox $w.ufield.options -command "ctUpdateOptionBox $w"
    eval pack $w.ufield.ipt.pattern $entStyle
    eval pack $w.ufield.ipt.path $entStyle
    pack $w.ufield.ipt -side left -fill x -expand yes -padx 5
    pack $w.ufield.options -side right -fill x -padx 5
    pack $w.ufield -fill both -expand yes 
    ctSetupBindings $w
    ctReadData $w
}

proc ctSetupToolbar {w} {
    global imgPath TRANSPARENT_GIF_COLOR
    navBar $w.navbar search replace analyse prev next stop close
    pack $w.navbar -side top -fill x -anchor n -in $w
    image create photo searchIcon -file $imgPath/search.gif
    image create photo replaceIcon -file $imgPath/translate.gif
    image create photo analyseIcon -file $imgPath/gear.gif
    image create photo nextIcon -file $imgPath/right.gif
    image create photo prevIcon -file $imgPath/left.gif
    image create photo stopIcon -file $imgPath/stop.gif
    image create photo closeIcon -file $imgPath/close.gif
    nbConfigure $w.navbar search -image searchIcon
    nbConfigure $w.navbar replace -image replaceIcon
    nbConfigure $w.navbar analyse -image analyseIcon -command createTags
    nbConfigure $w.navbar prev -image prevIcon -command showPrevious
    nbConfigure $w.navbar next -image nextIcon -command showNext
    nbConfigure $w.navbar stop -image stopIcon -command stop
    nbConfigure $w.navbar close -image closeIcon -state normal -command exitApp

    nbSetHelpText $w.navbar search .status "Activate search engine"
    nbSetHelpText $w.navbar replace .status "Replace matches with new pattern"
    nbSetHelpText $w.navbar analyse .status "Analyse C source files in path"
    nbSetHelpText $w.navbar prev .status "Display Previous item in search cache"
    nbSetHelpText $w.navbar next .status "Display Next item in search cache"
    nbSetHelpText $w.navbar stop .status "Cancel current search"
    nbSetHelpText $w.navbar close .status "Exit application"
}

proc ctSetupBindings {w} {
    event add <<UserInput>> <Any-KeyRelease>
    event add <<UserInput>> <ButtonRelease-2>
    cbBind $w.ufield.ipt.pattern <<UserInput>> {
	ctUpdateWidgetState .control
    }
    cbBind $w.ufield.ipt.path <<UserInput>> {
	ctUpdateWidgetState .control
    }
}

proc ctUpdateWidgetState {w {forcedState ""}} {
    global ctMenu ctUpdateProc options path pattern content
    set rstate disabled
    set sstate disabled
    set tstate disabled
    set cbPattern [cbGetEntry $w.ufield.ipt.pattern]
    set cbPath [cbGetEntry $w.ufield.ipt.path]
    if {$cbPattern != "" && $cbPath != ""} {
	set sstate normal
	if {[info exists content] && 
	       $cbPattern == $pattern && $cbPath == $path} {
	    set rstate normal
	}
    }
    if {$cbPath != ""} {
	set tstate normal
    }
    ctUpdateOptionBox $w
    umSetMenuState $ctMenu 0 0 $sstate
    umSetMenuState $ctMenu 0 1 $rstate
    umSetMenuState $ctMenu 0 3 $tstate
    nbSetButtonState $w.navbar search $sstate
    nbSetButtonState $w.navbar replace $rstate
    nbSetButtonState $w.navbar analyse $tstate
    $ctUpdateProc $cbPattern $cbPath
    update idletasks
}

proc ctUpdateOptionBox {w} {
    global options fileCache savOptions subdir curdir cwd path

    set optState normal
    set cbPath [cbGetEntry $w.ufield.ipt.path]
    if {$cbPath != $path || $subdir != $options(subdir) || $curdir != $cwd} {
	set savOptions(rescan) $options(rescan)
	set options(rescan) 1
	set optState disabled
	catch { unset fileCache }
    } else {
	catch { 
	    set options(rescan) $savOptions(rescan) 
	    unset savOptions(rescan)
	}
    }
    obEblRescanButton $w.ufield.options $optState
}

proc ctGetEntries {w} {
    return [list "[cbGetEntry $w.ufield.ipt.pattern]" \
		 "[cbGetEntry $w.ufield.ipt.path]"]
}

proc ctSetCacheState {w prev next} {
    nbSetButtonState $w.navbar prev $prev
    nbSetButtonState $w.navbar next $next
}

proc ctSetSearchState {w state} {
    global ctMenu
    umSetMenuState $ctMenu 0 0 $state
    nbSetButtonState $w.navbar search $state
}

proc ctGetSearchState {w} {
    nbGetButtonState $w.navbar search
}

proc ctSetReplaceState {w state} {
    global ctMenu
    umSetMenuState $ctMenu 0 1 $state
    nbSetButtonState $w.navbar replace $state
}

proc ctGetReplaceState {w} {
    nbGetButtonState $w.navbar replace
}

proc ctSetAnalyseState {w state} {
    global ctMenu
    umSetMenuState $ctMenu 0 3 $state
    nbSetButtonState $w.navbar analyse $state
}

proc ctSetStopState {w state} {
    nbSetButtonState $w.navbar stop $state
}

proc ctSetExpandState {w state} {
    global ctMenu
    umSetMenuState $ctMenu 1 3 $state
    umSetMenuState $ctMenu 1 4 $state
}

proc ctSetInputState {w state} {
    global chkboxDisableFg chkboxFg
    if {$state == "disabled"} {
	$w.ufield configure -cursor watch
	cbConfigure $w.ufield.ipt.pattern -cursor watch -state disabled
	cbConfigure $w.ufield.ipt.path -cursor watch -state disabled
	sbShowProgress .status 1
	busy hold $w.ufield 
    } else {
	sbShowProgress .status 0
	$w.ufield configure -cursor {}
	cbConfigure $w.ufield.ipt.pattern -cursor {} -state normal
	cbConfigure $w.ufield.ipt.path -cursor {} -state normal
	busy release $w.ufield
    }
}

proc ctUpdateHistory {w} {
    cbAddEntry $w.ufield.ipt.pattern "ctUpdateWidgetState $w"
    cbAddEntry $w.ufield.ipt.path "ctUpdateWidgetState $w"
    ctUpdateWidgetState $w
}

proc ctUpdateEntries {w} {
    global pattern path
    cbSetEntry $w.ufield.ipt.pattern $pattern
    cbSetEntry $w.ufield.ipt.path $path
}

proc ctSetFocus {w} {
    cbSetFocus $w.ufield.ipt.pattern
}

proc ctWriteData {w fd} {
    puts $fd "set $w {\\"
    set patternHistory [cbGetHistoryList $w.ufield.ipt.pattern]
    set pathHistory [cbGetHistoryList $w.ufield.ipt.path]
    if [llength patternHistory] {
	puts $fd "cbSetHistoryList $w.ufield.ipt.pattern \{$patternHistory\} \
                    \"ctUpdateWidgetState $w\";\\"
    }
    if [llength pathHistory] {
	puts $fd "cbSetHistoryList $w.ufield.ipt.path \{$pathHistory\} \
                    \"ctUpdateWidgetState $w\";\\"
    }
    puts $fd "}"
}

proc ctReadData {w} {
    global $w
    catch { eval [set $w] }
}

proc ctShowToolbar {w state} {
    if {$state} {
	pack $w.navbar -side top -fill x -anchor n -in .control \
	    -before $w.ufield
    } else {
	pack forget $w.navbar
    }
}

proc ctBrowseDirectory {entry} {
    set types {
        {"All files"            *}
        {"Text files"           {.txt .doc}     }
        {"C Source Files"       {.c .h}         }
        {"Tcl Scripts"          {.tcl}          TEXT}
    }
    set file [tk_getOpenFile -filetypes $types -parent $entry -title Browse]
    if {[$entry get] != ""} {
	$entry insert end ":"
    }
    global homePath
    regsub $homePath $file ~ file
    $entry insert end $file
    $entry xview end
    ctUpdateWidgetState .control
}
