# combobox.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc comboBox {w {args ""}} {
    global cbFont $w
    getOptions {-labelOpt -entryOpt -browse} $args
    frame $w -class Combobox
    eval label $w.lbl -width 6 -anchor w -font $cbFont ${-labelOpt}
    eval entry $w.ety -relief sunken -font $cbFont ${-entryOpt} \
	-textvariable $w
    pack $w.lbl -side left -anchor w -fill x -in $w
    pack $w.ety -side left -anchor w -padx 2m -expand yes \
	-fill x -in $w
    cbSetupButton $w.ety ${-browse}

    # This is required because the textvariable of the entry is not
    # updated until the default bindings for the Entry widget is
    # executed.
    bindtags $w.ety "Entry $w.ety . all"
}

proc cbConfigure {w {args ""}} {
    eval $w.ety configure $args
}

proc cbSetupButton {entry browse} {
    global cbFont imgPath
    if {$browse != ""} {
	set b ${entry}_browse
	button $b -bitmap @$imgPath/folder.xbm -width 15 -height 15 \
	    -highlightthickness 0 -takefocus 0 -command "$browse $entry"
	pack $b -side right -before $entry
    }
    set m ${entry}_history
    menubutton $m -bitmap @$imgPath/arrow.xbm -state disabled \
	-relief raised -borderwidth 2
    pack $m -side right -before $entry
    menu $m.m -tearoff 0 -font $cbFont
    $m configure -menu "$m.m"
}

proc cbSetFocus {w} {
    focus $w.ety
}

proc cbBind {w seq script} {
    bind $w.ety $seq +$script
}

proc cbGetEntry {w} {
    global $w
    return [set $w]
}

proc cbSetEntry {w text} {
    global $w
    set $w $text
}

proc cbConfigLabel {w args} {
    eval $w.lbl configure $args
}

proc cbConfigEntry {w args} {
    eval $w.ety configure $args
}

proc cbAddEntry {w {chgAction ""}} {
    $w.ety_history configure -state normal
    if {[cbPrivAddEntryCheck $w.ety_history $w.ety]} {
	set event [$w.ety get]
	if {[string trim $event] != ""} {
	    cbAddHistory $w.ety_history $w.ety $event \
		$event $chgAction
	}
    }
}

proc cbGetHistoryList {w} {
    set last [$w.ety_history.m index end]
    if {$last == "none"} {set last -1}
    set history {}
    for {set i 0} {$i <= $last} {incr i} {
	lappend history [$w.ety_history.m entrycget $i -label]
    }
    return $history
}

proc cbSetHistoryList {w list {chgAction ""}} {
    global cbKeep
    set last [expr [llength $list]-1]
    set first [expr $last-$cbKeep+1]
    set list [lrange $list $first $last]
    foreach i $list {
	$w.ety_history.m add command -label $i \
	    -command "cbHistoryInvoke $w.ety_history $w.ety\
                                      \{$i\} \{$chgAction\}"
    }
    if {[llength $list] > 0} {
	$w.ety_history configure -state normal
    }
}

proc cbPrivAddEntryCheck {mb ety} {
  set b $mb ; append b "button"
  if {![winfo exists $ety]} {
      catch "destroy $b"
      catch "destroy $mb"
      return 0
  } else {
      return 1
  }
}

proc cbAddHistory {mb ety menuoption event {chgAction ""}} {
    global cbKeep
    set last [$mb.m index end]
    if {$last == "none"} {set last -1}
    for {set c 0} {$c <= $last} {incr c} {
	if {[$mb.m entrycget $c -label] == $menuoption} {return}
    }
    $mb.m add command -label $menuoption \
	-command "cbHistoryInvoke $mb $ety \{$event\} \{$chgAction\}"    
    if {$last == [expr $cbKeep-1]} {
	$mb.m delete 0
    }
}

proc cbHistoryInvoke {mb ety event {chgAction ""}} {
    if {[cbPrivAddEntryCheck $mb $ety]} {
	$ety delete 0 end
	$ety insert 0 $event
	if {$chgAction != ""} {eval $chgAction}
    }
}
