# browser.tcl --
#
# Copyright (c) 1996-1997 Daniel M. Wu
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc browser {w {args ""}} {
    frame $w -relief raised -bd 1 -class Browser
    scrollbar $w.sb -orient vertical -width 12 -takefocus 0 \
	-command "$w.text yview"
    eval text $w.text -wrap none -setgrid 1 -cursor {{}} -spacing1 3 \
	-spacing2 3 -state disabled -yscrollcommand {"$w.sb set"} $args
    $w.text tag configure hot -relief raised -borderwidth 1 \
        -background darkseagreen2
    $w.text tag configure overstrike -overstrike 1 -foreground gray
    $w.text tag configure select -background paleturquoise
    $w.text tag configure focus -underline 1
    pack $w.sb -side right -fill y -in $w
    pack $w.text -expand y -fill both -in $w

    bind BrButton <Button-1> {
	if {[%W cget -state] != "disabled"} {
	    set wp [winfo parent %W]
	    set curIdx [$wp.text index %W]
	    set heading [$wp.text get "$curIdx linestart" "$curIdx lineend"]
	    $wp.text configure -state normal
	    if {$brToggle(%W) == "off"} {
		%W configure -bitmap @$imgPath/collapse.xbm -relief flat
		set brToggle(%W) on
		$brOnScript(%W) $wp $curIdx $heading
	    } else {
		%W configure -bitmap @$imgPath/expand.xbm -relief flat
		set brToggle(%W) off
		$brOffScript(%W) $wp $curIdx $heading
	    }
	    $wp.text configure -state disabled
	}
    }
}

proc brConfigure {w {args ""}} {
    eval $w.text configure $args
}

proc brSetupOutlineLevel {w level action help {offset 0}} {
    global brOffset brAction brHelp
    set brOffset(active$level) $offset
    set brAction(active$level) $action
    set brHelp(active$level)   $help
    $w.text tag configure active$level -spacing1 1 -spacing3 1
    $w.text tag bind active$level <Enter> {
	set wp [winfo parent %W]
	set activeTag [brGetActiveTag $wp @%x,%y]
	set offset $brOffset($activeTag)
	set lastLine [$wp.text index "@%x,%y linestart + $offset c"]
	$wp.text tag add hot $lastLine "$lastLine lineend"
	$brHelp($activeTag) $wp
    }
    $w.text tag bind active$level <Leave> {
	set wp [winfo parent %W]	
	$wp.text tag remove hot 1.0 end
    }
    $w.text tag bind active$level <Motion> {
	set wp [winfo parent %W]	
	set offset $brOffset([brGetActiveTag $wp @%x,%y])
	set newLine [$wp.text index "@%x,%y linestart + $offset c"]
	if {[string compare $newLine $lastLine] != 0} {
	    $wp.text tag remove hot 1.0 end
	    set lastLine $newLine
	    $wp.text tag add hot $lastLine "$lastLine lineend"
	}
    }
    $w.text tag bind active$level <Button-2> {
	set wp [winfo parent %W]
	set curIdx [$wp.text index @%x,%y]
	set line [$wp.text get "$curIdx linestart" "$curIdx lineend"]
	set hdrTag [brGetHeaderTag $wp @%x,%y]
	set hdrTxt [string range $hdrTag 4 end]
	$brAction([brGetActiveTag $wp @%x,%y]) $wp $hdrTxt $line
    }
}

proc brAddHeading {w level heading onCmd offCmd {args {}}} {
    global brToggle brOnScript brOffScript imgPath
    set cl [brGetCurLine $w]
    set textbg [lindex [$w.text configure -background] end]
    eval button $w.b$level:$cl \
	-bitmap @$imgPath/expand.xbm -relief flat -width 8 -height 8 \
	-background $textbg -highlightbackground $textbg \
	-activebackground $textbg -borderwidth 0 -takefocus 0 $args
    bindtags $w.b$level:$cl "Button BrButton $w.b$level:$cl . all"
    $w.text configure -state normal
    for {set i 0} {$i < $level} {incr i} {
	$w.text insert end "    "
    }
    $w.text window create end -window $w.b$level:$cl -padx 3
    set brToggle($w.b$level:$cl) off
    set brOnScript($w.b$level:$cl) $onCmd
    set brOffScript($w.b$level:$cl) $offCmd
    $w.text insert end "$heading\n"
    $w.text configure -state disabled
}

proc brDeleteHeading {w level cur} {
    global brToggle brOnScript brOffScript imgPath
    set cl [expr int($cur)]
    set ci [$w.text index $w.b$level:$cl]
    $w.text configure -state normal
    $w.text tag add overstrike $ci "$ci lineend"
    $w.b$level:$cl configure -bitmap @$imgPath/expand.xbm -relief flat
    $w.b$level:$cl configure -state disabled
    $w.text configure -state disabled
}

proc brGetCurLine {w} {
    return [expr int([$w.text index current])]
}

proc brClear {w} {
    $w.text configure -state normal
    $w.text delete 1.0 end
    $w.text configure -state disabled
}

proc brExpandHeading {w level cur text hdr} {
    $w.text insert \
	"$cur + 1 lines linestart" $text "hdr:$hdr active$level"
}

proc brContractHeading {w cur tag} {
    set range [$w.text tag ranges hdr:$tag]
    catch { $w.text tag delete t$cur }
    catch { eval $w.text delete $range }
}

proc brHighlightText {w rTag pattern args} {
    global brBFont
    set curIdx    [$w.text tag ranges hdr:$rTag]
    set cur_begin [lindex $curIdx 0]
    set cur_end   [lindex $curIdx 1]
    while 1 {
	set cur_begin [eval $w.text search -count length $args \{$pattern\} \
				 $cur_begin $cur_end]
	if {$cur_begin == ""} {
	    break
	}
	$w.text tag add search $cur_begin "$cur_begin + $length char"
	set cur_begin [$w.text index "$cur_begin + $length char"]
    }
    $w.text tag configure search -font $brBFont
}

proc brGetHeaderTag {w idx} {
    set tagList [$w.text tag names $idx]
    set tagPos [lsearch $tagList hdr:*]
    return [lindex $tagList $tagPos]
}

proc brGetActiveTag {w idx} {
    set tagList [$w.text tag names $idx]
    set tagPos [lsearch $tagList active*]
    return [lindex $tagList $tagPos]
}

proc brActivateAll {w state} {
    global brToggle brOnScript brOffScript imgPath
    update idletasks
    set slist [lsort [$w.text window names]]
    $w.text configure -state normal
    foreach b $slist {
	if {[$b cget -state] != "disabled"} {	    
	    set curIdx [$w.text index $b]
	    set heading [$w.text get "$curIdx linestart" "$curIdx lineend"]
	    if {$state} {
		$b configure -bitmap @$imgPath/collapse.xbm -relief flat
		set brToggle($b) on
		$brOnScript($b) $w $curIdx $heading
	    } else {
		$b configure -bitmap @$imgPath/expand.xbm -relief flat
		set brToggle($b) off
		$brOffScript($b) $w $curIdx $heading
	    }
	}
    }
    $w.text configure -state disabled
}
