##############################################################################
# $Id: balloon.tcl,v 1.3 1997/04/18 02:00:38 stewart Exp $
#
# balloon.tcl - procedures used by balloon help
#
# Copyright (C) 1996-1997 Stewart Allen
#
# 15/07/97  Modified source for searchtool, mainly proc names. (DMW)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

##############################################################################
#

bind st(balloon) <Enter> {
    set st(balloon,set) 0
    set st(balloon,first) 1
    set st(balloon,id) [after 500 {st:balloon %W $st(balloon,%W)}]
}

bind st(balloon) <Button> {
    set st(balloon,first) 0
    st:kill_balloon
}

bind st(balloon) <Leave> {
    set st(balloon,first) 0
    st:kill_balloon
}

bind st(balloon) <Motion> {
    if {$st(balloon,set) == 0} {
        after cancel $st(balloon,id)
        set st(balloon,id) [after 500 {st:balloon %W $st(balloon,%W)}]
    }
}

proc set_balloon {target message} {
    global st
    set st(balloon,$target) $message
    bindtags $target "[bindtags $target] st(balloon)"
}

proc st:kill_balloon {} {
    global st
    after cancel $st(balloon,id)
    if {[winfo exists .balloon] == 1} {
        destroy .balloon
    }
    set st(balloon,set) 0
}

proc st:balloon {target message} {
    global st stFont
    if {$st(balloon,first) == 1} {
        set st(balloon,first) 2
        set x [expr [winfo rootx $target] + ([winfo width $target]/2)]
        set y [expr [winfo rooty $target] + [winfo height $target] + 4]
        toplevel .balloon -bg black
        wm overrideredirect .balloon 1
        label .balloon.l \
            -text $message -relief flat \
            -bg #ffffaa -fg black -padx 2 -pady 0 -anchor w \
	    -font $stFont
        pack .balloon.l -side left -padx 1 -pady 1
        wm geometry .balloon +${x}+${y}
        set st(balloon,set) 1
    }
}
