/* Simple implementation of MSB in-memory radix sort. */
#include <stdlib.h>
#include "getln.h"
#include "readwrite.h"
#include "stralloc.h"
#include "strerr.h"
#include "substdio.h"
#include "uint32.h"
#include "version.h"

#define LINELENGTH 31
#define FATAL "rsort: fatal: "

void die_nomem()
{
  strerr_die2x(1,FATAL,"out of memory");
}
void die_read()
{
  strerr_die2sys(2,FATAL,"unable to read standard input: ");
}
void die_sort(void) {
  strerr_die2x(3,FATAL,"radix sort failed");
}

int main(void) {
  char **base	   = 0;		/* Pointers to strings to sort */
  uint32 lines_in  = 0;		/* Count lines loaded so far */
  uint32 lines_tot = 128;	/* Count of allocated lines */
  int a		   = 0;		/* Loop counter */
  int b		   = 0;		/* Loop counter */
  int match	   = 0;		/* Status message from getln() */
  char iobuf[512];		/* Input/Output buffer */
  substdio in;			/* Standard input */
  substdio out;			/* Standard output */

  /* Initialize substdio buffer for input */
  substdio_fdbuf(&in,read,0,iobuf,sizeof(iobuf));

  /* Initialize array for line pointers */
  base = (char **) alloc(128*sizeof(uint32 *));

  /* Loop until EOF */
  while(1) {
    /* Read a line of text, appending a null byte */
    stralloc line    = {0};
    if(getln(&in, &line, &match, '\n') == -1) die_read();
    if(line.len && !match) if(!stralloc_append(&line,"\n")) die_nomem();
    if(!stralloc_0(&line)) die_nomem();

    /* Add an index for the _next_ line. */
    base[lines_in] = line.s;
    if(!match) break;
    if (lines_in == lines_tot - 1) {
      if (!alloc_re((char *)&base,
		    lines_tot*sizeof(uint32 *),
		    (lines_tot + 128)*sizeof(uint32 *)))
	die_nomem();
      lines_tot += 128;
    }
    lines_in++;
  }

  /* Perform the radix sort */
  if (0 != radixsort((unsigned char **) base, lines_in, 0, 0)) die_sort();

  /* Print the results */
  substdio_fdbuf(&out,write,1,iobuf,sizeof(iobuf));
  while (lines_in-- > 0) substdio_puts(&out, *base++);
  substdio_flush(&out);
}
