
/*

	rmsafe, rmrest - file deletion recover utilities

	June 11, 1998

	Matt Kressel	(matty@inch.com)

	This program is protected under the GNU public license.
	If you don't know what that is you should read the file
	COPYING that should have been included with this document.

	I make no claims about the stability nor rubustness of
	the software.  Should you find a bug.  Please record the
	exact circumstance in which you encountered it and
	mail it to: matty@inch.com. And please, NO MORE SPAM!

	Happy Recovering!

	PS: Look for version 0.3 and X11 support coming soon...

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <unistd.h>
#include <pwd.h>
#include <errno.h>
#include <fcntl.h>
#include <dirent.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>

extern char progname[];
void rmsafe_error(char *error_string);
void read_conf(char *trash_home, char *user_name);
struct passwd *get_user();
char *get_filename(char *pathname);
void check_trash_dir(char *trash_dir);
void rmsafe_help();
void rmsafe_version();
void rmsafe_file(char *filename, char *trash_dir, struct stat *stbuf);
void rmsafe_directory(char *dirname, char *trash_dir);
	

typedef struct tag_file_node {
	char	real_name[FILENAME_MAX];	/* name of original location to restore to */
	char	trash_name[FILENAME_MAX];	/* full pathname of file in trash */
	struct tag_file_node *next;		/* next in list */
	struct tag_file_node *prev;		/* prev in list */
	int visited;
	int skip;
} file_node; 
void rmrest_help();
void rmrest_version();
void empty_dir_check(char *dirname);
void build_file_list(char *trash_dir);
void print_file_list();
void remove_file_node(char *trash_name,char *real_name);
void write_index_file();
file_node *in_trash(char *filename);
void rmrest_clean(char *filename);
void rmrest_file(file_node *file_ptr,char *t_file, char *r_file);
void rmrest_substring();

					
