
/*

	rmsafe, rmrest - file deletion recover utilities

	June 11, 1998

	Matt Kressel	(matty@inch.com)

	This program is protected under the GNU public license.
	If you don't know what that is you should read the file
	COPYING that should have been included with this document.

	I make no claims about the stability nor rubustness of
	the software.  Should you find a bug.  Please record the
	exact circumstance in which you encountered it and
	mail it to: matty@inch.com. And please, NO MORE SPAM!

	Happy Recovering!

	PS: Look for version 0.3 and X11 support coming soon...

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <unistd.h>
#include <pwd.h>
#include <errno.h>
#include <fcntl.h>
#include <dirent.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>

extern char progname[];


void rmsafe_error(char *error_string)
{
	char the_error[256];
	sprintf(the_error,"%s: %s",progname,error_string);
	perror(the_error);
}


/* read in /etc/rmsafe.conf for location of trash directory */

void read_conf(char *trash_home, char *user_name)
{
	FILE *conf = NULL;
	char aLine[256];
	
	if((conf=fopen("/etc/rmsafe.conf","r"))==NULL)
	{
		printf("%s: WARNING, file `/etc/rmsafe.conf' not found!\n",progname);
		printf("Using /tmp as trash directory.\n");
		sprintf(trash_home,"/tmp/%s",user_name);
	} else
	{
		/* on;y first character can be # comment */
		while(fgets(aLine,255,conf))	
		{
			if((aLine[0] == '#') || (aLine[0] == '\n'))
				continue;
			sscanf(aLine,"%s",trash_home);
			strcat(trash_home,"/");
			strcat(trash_home,user_name);
			fclose(conf);
			break;
		}
	}
}


/* return the user structure */		
struct passwd *get_user()
{
	uid_t	user_id;
	struct passwd *the_user;



	user_id = getuid();
	the_user = getpwuid(user_id);
	if(the_user == NULL)
	{
		printf("%s: Unable to retrieve pw entry for UID: %d\n",progname,user_id);
		exit(1);
	}
	return the_user;
}

/* strips leading directories from pathname */

char *get_filename(char *pathname)
{
	int i,j;


	j = 0;
	if((strlen(pathname) == 1) && (pathname[i] == '/'))
	{
		printf("%s: Command Not Allowed !\n",progname);
		exit(1);
	}

	for(i=0;i<strlen(pathname);i++)
	{
		if((pathname[i] == '/') && (pathname[i+1] != '\0'))
			j = i+1;
	}
	return pathname+j;

}
		
void check_trash_dir(char *trash_dir)
{
	struct stat stbuf;
	char yes_no;

	if(stat(trash_dir,&stbuf) < 0)
	{
		rmsafe_error(trash_dir);
		if(errno == ENOENT)
		{
			printf("\nDo you wish to create the trash directory now? (y/n): ");
			scanf("%c",&yes_no);
			if((yes_no == '\n') || (yes_no == 'y') || (yes_no == 'Y'))
			{
				if(mkdir(trash_dir,S_IRWXU) < 0)
				{
					rmsafe_error(trash_dir);
					exit(1);
				}
			} else
			{
				printf("Bye!\n");
				exit(0);
			}
			
		}
	} else
	{
		if(!S_ISDIR(stbuf.st_mode))
			printf("%s: %s is a file but must be a directory!\n",progname,trash_dir);
	}
		
}

					
