#!/bin/sh
BINDIR=$1
MANDIR=$2/man1
TRASHDIR=$3
PERMS=$4

for p in rmsafe rmrest; do
  echo Installing $p as $BINDIR/$p...
  if [ -f $BINDIR/$p ]; then
    mv $BINDIR/$p $BINDIR/$p.old
  fi
  cp $p $BINDIR/$p
  chown root:bin $BINDIR/$p
  chmod $PERMS $BINDIR/$p
done
echo
for d in rmsafe.1.gz rmrest.1.gz; do
  echo Installing $d as $MANDIR/$d...
  if [ -f $MANDIR/$d ]; then
    mv $MANDIR/$d $MANDIR/$d.old
  fi
  cp $d $MANDIR/$d
  chmod 755 $MANDIR/$d
done

echo Installing configuration file /etc/rmsafe.conf... 
cat ./rmsafe.conf > /etc/rmsafe.conf

echo Setting trash directory to $TRASHDIR...
echo $TRASHDIR >> /etc/rmsafe.conf
chmod 644 /etc/rmsafe.conf
mkdir $TRASHDIR
chmod 1777 $TRASHDIR

echo
echo Done!
echo
echo Try \"man rmsafe\" for more details.
echo




