/*
 * prepend - prepends contents of one file onto another
 * Copyright (C) 2002 Kurt Weber <kmw@rowsw.com> 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#define errmsg "prepend: error"

int main (int argc, char **argv){
	FILE *dest;
	FILE *src;
	FILE *tmp;
	char a;

	if (!argv[1] || !argv[2]){
		printf("usage: prepend dest src\n");
		printf("prepends file \"src\" to file \"dest\" and writes to standard output\n");
		printf("version 0.1 by Kurt Weber <kmw@rowsw.com>\n");
		return -1;
		}

	if ((tmp = tmpfile()) == NULL){
		perror(errmsg);
		return -1;
		}

	if ((src = fopen(argv[2], "r")) == NULL){
		perror(errmsg);
		return -1;
		}

	while (!feof(src)){
		fputc(fgetc(src), tmp);
		}

	if ((dest = fopen(argv[1], "r")) == NULL){
		perror(errmsg);
		return -1;
		}

	while (!feof(dest)){
		fputc(fgetc(dest), tmp);
		}

	if (fclose(src) == EOF){
		perror(errmsg);
		return -1;
		}

	if (fclose(dest) == EOF){
		perror(errmsg);
		return -1;
		}

	rewind(tmp);

	while (!feof(tmp)){
		a = fgetc(tmp);
		if (a != EOF){
			putc(a, stdout);
			}
		}

	if (fclose(tmp) == EOF){
		perror(errmsg);
		return -1;
		}

	return 0;
	}
