#include <string.h>
#include <getopt.h>
#include "crcmodel.h"

int     main( int argc, char *argv[] );
unsigned long getcrc( FILE *fp );

cm_t cmvar;
p_cm_t p_cmvar = &cmvar;

int main( int argc, char *argv[] ) {
  int     i;
  FILE   *fp;
  unsigned long crc;
  int c;

  p_cmvar->cm_width = 32;
  p_cmvar->cm_poly  = 0x04C11DB7L;
  p_cmvar->cm_init  = 0xFFFFFFFFL;
  p_cmvar->cm_refin = TRUE;
  p_cmvar->cm_refot = TRUE;
  p_cmvar->cm_xorot = 0xFFFFFFFFL;

  while (1) {
    int option_index = 0;
    static struct option long_options[] = {
      {"name", 1, 0, 'n'},
      {"width", 1, 0, 'w'},
      {"poly", 1, 0, 'p'},
      {"init", 0, 0, 'i'},
      {"refin", 1, 0, 'r'},
      {"refout", 1, 0, 'R'},
      {"xorout", 1, 0, 'x'},
      {"help", 0, 0, 'h'},
      {0, 0, 0, 0}
    };

    c = getopt_long (argc, argv, "n:w:p:i:rRx:h?",
         long_options, &option_index);
    if (c == -1)
      break;

    switch (c) {
      case 'n':
        if (strcmp (optarg, "arc") == 0){
          p_cmvar->cm_width = 16;
          p_cmvar->cm_poly  = 0x8005L;
          p_cmvar->cm_init  = 0L;
          p_cmvar->cm_refin = TRUE;
          p_cmvar->cm_refot = TRUE;
          p_cmvar->cm_xorot = 0L;
        } else if (strcmp (optarg, "citt") == 0) {
          p_cmvar->cm_width = 16;
          p_cmvar->cm_poly  = 0x1021L;
          p_cmvar->cm_init  = 0xffffL;
          p_cmvar->cm_refin = FALSE;
          p_cmvar->cm_refot = FALSE;
          p_cmvar->cm_xorot = 0L;
        } else if (strcmp (optarg, "zmodem16") == 0) {
          p_cmvar->cm_width = 16;
          p_cmvar->cm_poly  = 0x1021L;
          p_cmvar->cm_init  = 0x0L;
          p_cmvar->cm_refin = FALSE;
          p_cmvar->cm_refot = FALSE;
          p_cmvar->cm_xorot = 0L;
        } else if (strcmp (optarg, "xmodem") == 0) {
          p_cmvar->cm_width = 16;
          p_cmvar->cm_poly  = 0x8408L;
          p_cmvar->cm_init  = 0L;
          p_cmvar->cm_refin = TRUE;
          p_cmvar->cm_refot = TRUE;
          p_cmvar->cm_xorot = 0L;
        } else if (strcmp (optarg, "crc32") == 0 || 
                 strcmp (optarg, "pkzip") == 0 ||
                 strcmp (optarg, "ethernet") == 0 ||
                 strcmp (optarg, "fddi") == 0) {
          p_cmvar->cm_width = 32;
          p_cmvar->cm_poly  = 0x04C11DB7L;
          p_cmvar->cm_init  = 0xFFFFFFFFL;
          p_cmvar->cm_refin = TRUE;
          p_cmvar->cm_refot = TRUE;
          p_cmvar->cm_xorot = 0xFFFFFFFFL;
        }
      break;

      case 'w':
        p_cmvar->cm_width = (int) strtoul(optarg, 0, 0);
        break;

      case 'p':
        p_cmvar->cm_poly = strtoul(optarg, 0, 0);
        break;

      case 'i':
        p_cmvar->cm_init = strtoul(optarg, 0, 0);
        break;

      case 'r':
        p_cmvar->cm_refin == TRUE ? p_cmvar->cm_refin = FALSE : TRUE;
        break;

      case 'R':
        p_cmvar->cm_refot == TRUE ? p_cmvar->cm_refot = FALSE : TRUE;
        break;

      case 'x':
        p_cmvar->cm_xorot = strtoul(optarg, 0, 0);
        break;

      case 'h':
        case '?':
        printf ("\
%s [OPTION]... [FILE]...\n\n\
 calculate CRCs with different parameters\n\n\
  -w, --width  WIDTH   width of the algorithm expressed in bits (32)\n\
  -p, --poly   POLY    the polynomial (0x04C11DB7)\n\
  -i, --init   INIT    initial value when the algorithm starts (0xFFFFFFFF)\n\
  -r, --refin          each input byte will/will not be reflected\n\
  -R, --refout         final value is/is not reflected before being XORed\n\
  -x, --xorout XOROUT  this value is XORed with the final value (0xFFFFFFFF)\n\
  -n, --name   NAME    name of crc algoritm (untested, use with care) (crc32):\n\
                         crc32, arc, citt, zmodem16, xmodem, pkzip,\n\
                         ethernet, fddi\n\n\
   Please send your bugfixes and patches to\n\
   Soenke J. Peters <soenke+rpm@simprovement.com>\n\n"
         , argv[0]);
        exit (0);
        break;
      }
  }

    cm_ini(p_cmvar);

    if (argc == optind) {
        crc = getcrc( stdin );
        printf("crc32 = %08lx for <stdin>\n", crc);
    } else {
        for (i=optind; i<argc; i++) {
            if ( (fp=fopen(argv[i],"rb")) == NULL ) {
                printf("error opening file \"%s\"!\n", argv[i]);
            } else {
                crc = getcrc( fp );
                printf("crc32 = %08lx for \"%s\"\n", crc, argv[i]);
                fclose( fp );
            }
        }
    }
    return( 0 );
}

/****************************************************************************/
unsigned long getcrc( FILE *fp )
{
    int d;
    
    while( (d=getc(fp)) != EOF ) {
        cm_nxt(p_cmvar, d);
    }
    return( cm_crc(p_cmvar) );
}